/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothBytesStreamManager
extends BluetoothStreamManager {
    private List<Byte> messageBuffer = new ArrayList<Byte>();
    private byte[] terminator;
    private byte[] tempData;
    private int state;
    private boolean appendTerminator;

    public BluetoothBytesStreamManager(BluetoothHelper helper, byte[] terminator, boolean appendTerminator) {
        super(helper);
        this.terminator = terminator == null || terminator.length == 0 ? new byte[]{0} : terminator;
        this.state = 0;
        this.tempData = new byte[this.terminator.length];
        this.appendTerminator = appendTerminator;
    }

    @Override
    public void OnMessageReceived(byte[] buff) {
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] == this.terminator[this.state]) {
                this.tempData[this.state] = this.terminator[this.state];
                ++this.state;
            } else {
                for (int j = 0; j < this.state; ++j) {
                    this.messageBuffer.add(this.tempData[j]);
                }
                if (this.state != 0) {
                    this.state = 0;
                    --i;
                    continue;
                }
                this.messageBuffer.add(buff[i]);
                continue;
            }
            if (this.state != this.terminator.length) continue;
            this.state = 0;
            this.helper.invokeDataReceivedEvent(new CharArrayWrapper(this.messageBuffer.toArray()));
            this.messageBuffer.clear();
        }
    }

    @Override
    public void Listen() {
        this.transceiver.listen();
    }

    @Override
    public void sendData() {
        if (!this.appendTerminator) {
            this.transceiver.write(this.data_out);
        } else {
            byte[] buff = Arrays.copyOf(this.data_out, this.data_out.length + this.terminator.length);
            System.arraycopy(this.terminator, 0, buff, this.data_out.length, this.terminator.length);
            this.transceiver.write(buff);
        }
    }
}

