/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.tony.bluetoothunityapi.BLEBluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothBytesStreamManager;
import com.tony.bluetoothunityapi.BluetoothCustomStreamManager;
import com.tony.bluetoothunityapi.BluetoothDeviceAddress;
import com.tony.bluetoothunityapi.BluetoothEventListener;
import com.tony.bluetoothunityapi.BluetoothFixedLengthStreamManager;
import com.tony.bluetoothunityapi.BluetoothLengthStreamManager;
import com.tony.bluetoothunityapi.BluetoothOneCharStreamManager;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.BluetoothTerminatorCharStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;
import com.tony.bluetoothunityapi.ClassicBluetoothHelper;
import com.tony.bluetoothunityapi.IStreamManager;
import com.tony.bluetoothunityapi.ScanResultBluetoothDevice;
import com.tony.bluetoothunityapi.ble.BluetoothHelperCharacteristic;
import com.tony.bluetoothunityapi.ble.BluetoothHelperService;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class BluetoothHelper {
    public static final String TAG = "BluetoothAPI";
    private int id = ++identifiers;
    protected Context context;
    protected Handler handler;
    protected boolean stopThread;
    protected boolean connected;
    protected boolean devicePaired;
    protected static boolean isScanning = false;
    protected boolean isConnecting;
    protected String deviceName;
    protected String deviceAddress;
    protected BluetoothDeviceAddress device;
    protected ScanResultBluetoothDevice bt_device;
    protected static LinkedList<BluetoothDeviceAddress> nearbyDevices = new LinkedList();
    protected LinkedList<BluetoothEventListener> listeners;
    protected BluetoothAdapter bluetoothAdapter;
    protected BluetoothStreamManager streamManager;
    private static int identifiers = 0;

    public static BluetoothHelper GetInstance(Context context, String deviceName, boolean isBLE) {
        BluetoothHelper.EnablePermission(context);
        return isBLE ? new BLEBluetoothHelper(context, deviceName) : new ClassicBluetoothHelper(context, deviceName);
    }

    public static BluetoothHelper GetInstance(Context context, boolean isBLE) {
        return BluetoothHelper.GetInstance(context, null, isBLE);
    }

    BluetoothHelper(Context context, String deviceName) throws BluetoothHelperException {
        this.context = context;
        this.BTinit();
        this.setDeviceName(deviceName);
    }

    protected void BTinit() {
        this.handler = new Handler(this.context.getMainLooper());
        this.stopThread = true;
        this.listeners = new LinkedList();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.connected = false;
        this.isConnecting = false;
        if (this.bluetoothAdapter == null) {
            throw new BlueToothNotSupportedException();
        }
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.deviceAddress = null;
        this.bt_device = null;
        this.device = null;
        this.isDevicePaired();
    }

    public int getId() {
        return this.id;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress.toUpperCase();
        this.deviceName = null;
        this.bt_device = null;
        this.device = null;
        this.isDevicePaired();
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public abstract boolean scanNearbyDevices();

    public abstract ITransceiver getTransceiver();

    public boolean isConnected() {
        return this.connected;
    }

    protected abstract void searchForDevice();

    public boolean isDevicePaired() {
        this.searchForDevice();
        return this.devicePaired;
    }

    public abstract void connect();

    public void connect(String deviceName) {
        this.deviceName = deviceName;
        this.searchForDevice();
        this.connect();
    }

    public abstract void disconnect();

    public void setLengthBasedStream() {
        if (this.streamManager != null) {
            return;
        }
        this.streamManager = new BluetoothLengthStreamManager(this);
    }

    public void setCustomStreamManager(IStreamManager streamManager) {
        if (this.streamManager != null) {
            return;
        }
        this.streamManager = new BluetoothCustomStreamManager(this, streamManager);
    }

    public void setTerminatorBasedStream(String terminationStr) {
        this.setTerminatorBasedStream(terminationStr, true);
    }

    public void setTerminatorBasedStream(byte[] terminator) {
        this.setTerminatorBasedStream(terminator, true);
    }

    public void setTerminatorBasedStream(String terminationStr, boolean appendTerminator) {
        if (this.streamManager != null) {
            return;
        }
        this.streamManager = terminationStr == null || terminationStr.length() < 2 ? new BluetoothOneCharStreamManager(this, terminationStr, appendTerminator) : new BluetoothTerminatorCharStreamManager(this, terminationStr, appendTerminator);
    }

    public void setTerminatorBasedStream(byte[] terminator, boolean appendTerminator) {
        if (this.streamManager != null) {
            return;
        }
        this.streamManager = new BluetoothBytesStreamManager(this, terminator, appendTerminator);
    }

    public void setFixedLengthBasedStream(int length) {
        if (this.streamManager != null) {
            return;
        }
        this.streamManager = new BluetoothFixedLengthStreamManager(this, length);
    }

    public void startListening() {
        if (!this.connected) {
            throw new BlueToothNotConnectedException();
        }
        if (this.streamManager == null) {
            throw new BluetoothListeningMethodIsNotSetException();
        }
        this.streamManager.Listen();
    }

    public void sendData(String data) {
        if (!this.connected) {
            throw new BlueToothNotConnectedException();
        }
        if (this.streamManager == null) {
            throw new BluetoothListeningMethodIsNotSetException();
        }
        this.streamManager.set(data);
        this.streamManager.sendData();
    }

    public void sendData(byte[] data) {
        if (!this.devicePaired || !this.connected) {
            throw new BlueToothNotConnectedException();
        }
        if (this.streamManager == null) {
            throw new BluetoothListeningMethodIsNotSetException();
        }
        this.streamManager.set(data);
        this.streamManager.sendData();
    }

    public BluetoothDeviceAddress getBluetoothDevice() {
        if (!this.devicePaired) {
            throw new BlueToothNotReadyException();
        }
        return this.device;
    }

    public void setOnDataReceivedListener(BluetoothEventListener listener) {
        this.listeners.add(listener);
    }

    public static void EnablePermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
                permissions.add("android.permission.BLUETOOTH");
            } else {
                Log.d((String)TAG, (String)"Permission Granted android.permission.BLUETOOTH");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_COARSE_LOCATION");
            } else {
                Log.d((String)TAG, (String)"Permission Granted android.permission.ACCESS_COARSE_LOCATION");
            }
            if (context.checkSelfPermission("android.permission.BLUETOOTH_ADMIN") != 0) {
                permissions.add("android.permission.BLUETOOTH_ADMIN");
            } else {
                Log.d((String)TAG, (String)"Permission Granted android.permission.BLUETOOTH_ADMIN");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_FINE_LOCATION");
            } else {
                Log.d((String)TAG, (String)"Permission Granted android.permission.ACCESS_FINE_LOCATION");
            }
            if (Build.VERSION.SDK_INT >= 29 && context.checkSelfPermission("android.permission.ACCESS_BACKGROUND_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_BACKGROUND_LOCATION");
            } else if (Build.VERSION.SDK_INT >= 29) {
                Log.d((String)TAG, (String)"Permission Granted android.permission.ACCESS_BACKGROUND_LOCATION");
            }
            if (permissions.size() == 0) {
                Log.d((String)TAG, (String)"No permissions to request ");
                return;
            }
            String[] permissionArray = new String[permissions.size()];
            ((Activity)context).requestPermissions(permissions.toArray(permissionArray), 1414);
        }
    }

    public abstract List<BluetoothDeviceAddress> getPairedDevicesList();

    public void invokeDataReceivedEvent(CharArrayWrapper data) {
        for (BluetoothEventListener l : this.listeners) {
            l.OnDataReceived(data);
        }
    }

    public void invokeOnConnected() {
        Log.d((String)TAG, (String)"Connected");
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.isConnecting = false;
        for (BluetoothEventListener l : this.listeners) {
            l.OnConnected();
        }
    }

    public void invokeOnConnectionFailed() {
        Log.d((String)TAG, (String)"Failed");
        if (!this.connected && !this.isConnecting) {
            return;
        }
        this.connected = false;
        this.isConnecting = false;
        for (BluetoothEventListener l : this.listeners) {
            l.OnConnectionFailed();
        }
    }

    public void invokeOnScanEnded() {
        for (BluetoothEventListener l : this.listeners) {
            l.OnScanEnded(nearbyDevices);
        }
    }

    public void invokeOnServiceNotFound(String service) {
        for (BluetoothEventListener l : this.listeners) {
            l.OnServiceNotFound(service);
        }
    }

    public void invokeOnCharacteristicNotFound(String service, String characteristic) {
        for (BluetoothEventListener l : this.listeners) {
            l.OnCharacteristicNotFound(service, characteristic);
        }
    }

    public void invokeOnCharacteristicChanged(byte[] value, BluetoothHelperCharacteristic characteristic) {
        CharArrayWrapper wrapper = new CharArrayWrapper(value);
        for (BluetoothEventListener l : this.listeners) {
            l.OnCharacteristicChanged(wrapper, characteristic);
        }
    }

    public void invokeOnDescriptorNotFound(String service, String characteristic, String descriptor) {
        for (BluetoothEventListener l : this.listeners) {
            l.OnDescriptorNotFound(service, characteristic, descriptor);
        }
    }

    public void enableBluetooth(boolean status) {
        if (!status && this.bluetoothAdapter.isEnabled()) {
            this.bluetoothAdapter.disable();
        } else if (!this.bluetoothAdapter.isEnabled()) {
            this.context.startActivity(new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE"));
        }
    }

    public boolean isBluetoothEnabled() {
        return this.bluetoothAdapter.isEnabled();
    }

    public abstract void subscribe(BluetoothHelperService var1);

    public abstract void subscribe(BluetoothHelperCharacteristic var1);

    public abstract void writeCharacteristic(BluetoothHelperCharacteristic var1, byte[] var2);

    public abstract void readCharacteristic(BluetoothHelperCharacteristic var1);

    public abstract void setTxCharacteristic(BluetoothHelperCharacteristic var1);

    public abstract void setRxCharacteristic(BluetoothHelperCharacteristic var1);

    public void writeCharacteristic(BluetoothHelperCharacteristic characteristic, String value) {
        this.writeCharacteristic(characteristic, value.getBytes());
    }

    public abstract List<BluetoothHelperService> getGattServices();

    public static class MethodNotSupportedException
    extends BluetoothHelperException {
        public MethodNotSupportedException() {
            super("Method not supported for this platform");
        }
    }

    public static class BluetoothTransmissionCharacteristicNotSetException
    extends BluetoothHelperException {
        public BluetoothTransmissionCharacteristicNotSetException() {
            super("Tx Characteristic Not Found, set it with setTxCharacteristic");
        }
    }

    public static class BlueToothPermissionNotGrantedException
    extends BluetoothHelperException {
        public BlueToothPermissionNotGrantedException() {
            super("Bluetooth permission is not granted, please call ClassicBluetoothHelper.RequestPermission();");
        }
    }

    public static class CharacteristicNotFoundException
    extends BluetoothHelperException {
        public CharacteristicNotFoundException() {
            super("Characteristic Not Found");
        }
    }

    public static class ServiceNotFoundException
    extends BluetoothHelperException {
        public ServiceNotFoundException() {
            super("Service Not Found");
        }
    }

    public static class BluetoothListeningMethodIsNotSetException
    extends BluetoothHelperException {
        public BluetoothListeningMethodIsNotSetException() {
            super("Bluetooth listening method is not set");
        }
    }

    public static class BlueToothNotReadyException
    extends BluetoothHelperException {
        public BlueToothNotReadyException() {
            super("Bluetooth is not ready");
        }
    }

    public static class BlueToothNotConnectedException
    extends BluetoothHelperException {
        public BlueToothNotConnectedException() {
            super("Bluetooth is not connected");
        }
    }

    public static class BlueToothNotSupportedException
    extends BluetoothHelperException {
        public BlueToothNotSupportedException() {
            super("Bluetooth is not supported");
        }
    }

    public static class BlueToothNotEnabledException
    extends BluetoothHelperException {
        public BlueToothNotEnabledException() {
            super("Bluetooth is not enabled");
        }
    }

    public static abstract class BluetoothHelperException
    extends RuntimeException {
        BluetoothHelperException(String msg) {
            super(msg);
        }
    }
}

