/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser.sonic;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.sonic.ISonicController;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.device.Device;
import com.hpplay.sdk.source.device.ServiceUpdater;
import com.hpplay.sdk.source.log.SourceLog;

public class SonicBrowseBridge {
    private static final String TAG = "SonicBrowseBridge";
    private static SonicBrowseBridge sInstance;
    private ModuleLinker mModuleLinker;
    private ISonicController mSonicController;
    private IServiceInfoParseListener mServiceInfoParseListener;
    private boolean isStop = true;
    private boolean isBrowserSuccess = false;
    private final IBrowseResultListener mSonicPinBrowseListener = new IBrowseResultListener(){

        @Override
        public void onBrowseResultCallback(int n2, Object object) {
            if (SonicBrowseBridge.this.isStop) {
                return;
            }
            if (n2 != 3) {
                return;
            }
            String string = (String)object;
            if (TextUtils.isEmpty((CharSequence)string)) {
                SourceLog.w(SonicBrowseBridge.TAG, "onBrowseResultCallback: sonicPin is empty");
                return;
            }
            Device.addDeviceCodeServiceInfo(string, 9, SonicBrowseBridge.this.mServiceInfoParseListener);
        }
    };

    private SonicBrowseBridge() {
        if (!a.g()) {
            return;
        }
        try {
            this.mModuleLinker = ModuleLinker.getNewInstance();
            this.mSonicController = (ISonicController)this.mModuleLinker.loadModule("0659E74D5AD9B7041D071577472F03D7");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static synchronized SonicBrowseBridge getInstance() {
        if (sInstance != null) return sInstance;
        Class<SonicBrowseBridge> clazz = SonicBrowseBridge.class;
        synchronized (SonicBrowseBridge.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SonicBrowseBridge();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setServiceInfoParseListener(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mServiceInfoParseListener = iServiceInfoParseListener;
    }

    public boolean startBrowse(Context context) {
        if (this.mSonicController == null) {
            SourceLog.i(TAG, "startBrowse ignore");
            return false;
        }
        SourceLog.i(TAG, "startBrowse");
        this.isStop = false;
        this.mSonicController.startSonicBrowse(this.mSonicPinBrowseListener, new int[0]);
        this.isBrowserSuccess = true;
        ServiceUpdater.getInstance().updateServiceInfo(context);
        return this.isBrowserSuccess;
    }

    public void stopBrowse(Context context) {
        if (this.mSonicController == null) {
            SourceLog.i(TAG, "stopBrowse ignore");
            return;
        }
        if (this.isStop) {
            return;
        }
        SourceLog.i(TAG, "stopBrowse");
        this.isStop = true;
        this.isBrowserSuccess = false;
        this.mSonicController.stop();
        ServiceUpdater.getInstance().updateServiceInfo(context);
    }

    public boolean isBrowserSuccess() {
        return this.isBrowserSuccess;
    }

    public void release() {
        if (this.mModuleLinker != null) {
            this.mModuleLinker.removeObjOfMemory("3B5B9CF21B1389F9929454313D455A51");
            this.mModuleLinker = null;
        }
    }
}

