/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.business.LelinkPlayerListenerDispatcher;
import com.hpplay.sdk.source.business.PlayController;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.da.e;
import com.hpplay.sdk.source.da.m;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BusinessEntity {
    private static final String TAG = "BusinessEntity";
    private final ConcurrentLinkedQueue<PlayController> mControllers = new ConcurrentLinkedQueue();
    private static final int KEEP_SIZE = 1;
    private static BusinessEntity sInstance;
    private PlayController mCurrentPlayController;
    private final LelinkPlayerListenerDispatcher mListenerDispatcher = new LelinkPlayerListenerDispatcher();
    private long mPreCastTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BusinessEntity getInstance() {
        Class<BusinessEntity> clazz = BusinessEntity.class;
        synchronized (BusinessEntity.class) {
            if (sInstance == null) {
                sInstance = new BusinessEntity();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BusinessEntity() {
    }

    public void dispatch(Context context, OutParameter outParameter, boolean bl) {
        this.dispatch(context, outParameter, null);
    }

    public synchronized void dispatch(final Context context, final OutParameter outParameter, ArrayList arrayList) {
        if (!this.checkSdkUsable()) {
            SourceLog.i(TAG, "dispatch ignore");
            return;
        }
        if (outParameter == null) {
            return;
        }
        SourceLog.i(TAG, "dispatch " + outParameter);
        this.mListenerDispatcher.setCurrentPlayInfo(outParameter);
        ConnectBridge connectBridge = this.getConnectBridge(outParameter);
        if (connectBridge == null || !CastUtil.isSupportLelinkV2(outParameter.serviceInfo) && !CastUtil.isSupportIM(outParameter.serviceInfo) || outParameter.castType == 2 || this.isMirroring() || !this.isCurrentDevice(outParameter)) {
            this.destroyPreCast();
        } else {
            this.clearPreCast();
        }
        if (outParameter.castType == 1 && outParameter.mimeType == 102 && outParameter.urls == null) {
            e.d().a(outParameter, new m(){

                @Override
                public void onDaResult(boolean bl, String string) {
                    boolean bl2 = false;
                    if (bl && !TextUtils.isEmpty((CharSequence)string)) {
                        bl2 = true;
                        e.d().a(context, outParameter, string);
                    } else {
                        BusinessEntity.this.dispatchPlay(context, outParameter);
                    }
                    BusinessEntity.getInstance().onDaResult(outParameter, bl2);
                }
            });
        } else {
            this.dispatchPlay(context, outParameter);
        }
    }

    public void dispatchPlay(Context context, OutParameter outParameter) {
        this.mListenerDispatcher.setCurrentPlayInfo(outParameter);
        int n2 = -1;
        n2 = this.mPreCastTime == -1L ? -1 : (int)(System.currentTimeMillis() - this.mPreCastTime);
        this.mPreCastTime = System.currentTimeMillis();
        PlayController playController = new PlayController(context, outParameter);
        playController.setDataSource(outParameter, n2);
        playController.start();
        playController.setLelinkPlayerListener(this.mListenerDispatcher);
        this.mControllers.add(playController);
        this.mCurrentPlayController = playController;
    }

    public void setPlayerListener(ILelinkPlayerListener iLelinkPlayerListener) {
        this.mListenerDispatcher.setPlayerListener(iLelinkPlayerListener);
    }

    public void setNewPlayerListener(INewPlayerListener iNewPlayerListener) {
        this.mListenerDispatcher.setNewPlayerListener(iNewPlayerListener);
    }

    public void setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        this.mListenerDispatcher.setDaPlayListener(iDaPlayerListener);
    }

    public void onDaResult(OutParameter outParameter, boolean bl) {
        this.mListenerDispatcher.onDaResult(outParameter, bl);
    }

    private boolean isMirroring() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            return false;
        }
        OutParameter outParameter = playController.getPlayInfo();
        if (outParameter == null) {
            return false;
        }
        return outParameter.castType == 2;
    }

    private boolean isCurrentDevice(OutParameter outParameter) {
        if (this.mCurrentPlayController == null) {
            return false;
        }
        OutParameter outParameter2 = this.mCurrentPlayController.getPlayInfo();
        if (outParameter2 == null || outParameter2.serviceInfo == null) {
            return false;
        }
        return outParameter2.serviceInfo.equals(outParameter.serviceInfo);
    }

    private ConnectBridge getConnectBridge(OutParameter outParameter) {
        LelinkServiceInfo lelinkServiceInfo = outParameter.serviceInfo;
        if (lelinkServiceInfo == null || TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getUid())) {
            return ConnectManager.getInstance().getLastConnectBridge();
        }
        return ConnectManager.getInstance().getConnectBridge(lelinkServiceInfo.getUid());
    }

    private void destroyPreCast() {
        if (this.mControllers.size() >= 1) {
            int n2 = this.mControllers.size() - 1 + 1;
            Iterator<PlayController> iterator = this.mControllers.iterator();
            while (iterator.hasNext()) {
                PlayController playController = iterator.next();
                SourceLog.i(TAG, "destroyPreCast " + playController.getPlayInfo());
                playController.stop(1001);
                playController.release();
                iterator.remove();
                if (--n2 > 0) continue;
                break;
            }
        }
    }

    private void clearPreCast() {
        int n2 = this.mControllers.size() - 1 + 1;
        Iterator<PlayController> iterator = this.mControllers.iterator();
        while (iterator.hasNext()) {
            PlayController playController = iterator.next();
            SourceLog.i(TAG, "clearPreCast " + playController.getPlayInfo());
            playController.setStopType(1001);
            playController.release();
            iterator.remove();
            if (--n2 > 0) continue;
            break;
        }
    }

    public void resume() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "resume " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.resume();
        }
    }

    public void switchYim() {
        if (this.mCurrentPlayController != null) {
            this.mCurrentPlayController.doChangeChannel(4);
        }
    }

    public void switchLelink() {
        if (this.mCurrentPlayController != null) {
            this.mCurrentPlayController.doChangeChannel(1);
        }
    }

    public void pause() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "pause " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.pause();
        }
    }

    public void playDrama(String string) {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "playDrama " + this.mControllers.size() + " / " + string);
        for (PlayController playController : this.mControllers) {
            playController.playDrama(string);
        }
    }

    public void playNextDrama() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "playNextDrama " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.playNextDrama();
        }
    }

    public void playPreDrama() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "playPreDrama " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.playPreDrama();
        }
    }

    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "appendPlayList " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.appendPlayList(dramaInfoBeanArray, n2, n3, n4);
        }
    }

    public void clearPlayList() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "clearPlayList " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.clearPlayList();
        }
    }

    public void setWatermarkVisible(boolean bl) {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "setWatermarkVisible ignore");
            return;
        }
        this.mCurrentPlayController.setWatermarkVisible(bl);
    }

    public void setMirrorScreenSecret(boolean bl) {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "setMirrorScreenSecret ignore");
            return;
        }
        this.mCurrentPlayController.setMirrorScreenSecret(bl);
    }

    public void onAppResume() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "onAppResume " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.onAppResume();
        }
    }

    public void onAppPause() {
        if (!this.checkSdkUsable()) {
            return;
        }
        SourceLog.i(TAG, "onAppPause " + this.mControllers.size());
        for (PlayController playController : this.mControllers) {
            playController.onAppPause();
        }
    }

    public void seekTo(int n2) {
        if (!this.checkSdkUsable()) {
            return;
        }
        for (PlayController playController : this.mControllers) {
            playController.seekTo(n2);
        }
    }

    public int getCurrentPlayState() {
        if (!this.checkSdkUsable()) {
            return -1;
        }
        return this.mCurrentPlayController == null ? -1 : this.mCurrentPlayController.getCurrentPlayState();
    }

    public OutParameter getCurrentPlayInfo() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            return null;
        }
        return playController.getPlayInfo();
    }

    public void addVolume() {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "addVolume ignore");
            return;
        }
        this.mCurrentPlayController.addVolume();
    }

    public void subVolume() {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "subVolume ignore");
            return;
        }
        this.mCurrentPlayController.subVolume();
    }

    public void setVolume(int n2) {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "setVolume ignore");
            return;
        }
        this.mCurrentPlayController.setVolume(n2);
    }

    public void selectAudiotrack(int n2) {
        if (!this.checkSdkUsable()) {
            return;
        }
        if (this.mCurrentPlayController == null) {
            SourceLog.w(TAG, "selectAudiotrack ignore");
            return;
        }
        this.mCurrentPlayController.selectAudiotrack(n2);
    }

    public PlayController getCurrentPlayController() {
        return this.mCurrentPlayController;
    }

    public void stop(int n2) {
        for (PlayController playController : this.mControllers) {
            playController.stop(n2);
        }
    }

    public void onWifiConnected() {
        for (PlayController playController : this.mControllers) {
            playController.onWifiConnected();
        }
    }

    public void stopWithCallback(int n2) {
        for (PlayController playController : this.mControllers) {
            playController.stopWithCallback(n2);
        }
    }

    public void release() {
        SourceLog.i(TAG, "release");
        try {
            for (PlayController playController : this.mControllers) {
                playController.release();
            }
            this.mCurrentPlayController = null;
            this.mControllers.clear();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private boolean checkSdkUsable() {
        if (!AuthSDK.getInstance().checkSdkUsable()) {
            SourceLog.w(TAG, "checkSdkUsable auth failed authCode := " + AuthSDK.getInstance().getAuthCode());
            if (this.mListenerDispatcher != null) {
                if (AuthSDK.getInstance().getAuthCode() == -101) {
                    this.mListenerDispatcher.onError(null, -1, -2);
                } else {
                    this.mListenerDispatcher.onError(null, -1, 0);
                }
            }
            return false;
        }
        return true;
    }

    public LelinkPlayerListenerDispatcher getListenerDispatcher() {
        return this.mListenerDispatcher;
    }
}

