/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import com.hpplay.glide.request.FutureTarget;
import com.hpplay.glide.request.Request;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.target.SizeReadyCallback;
import com.hpplay.glide.util.Util;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<T, R>
implements FutureTarget<R>,
Runnable {
    private static final Waiter DEFAULT_WAITER = new Waiter();
    private final Handler mainHandler;
    private final int width;
    private final int height;
    private final boolean assertBackgroundThread;
    private final Waiter waiter;
    private R resource;
    private Request request;
    private boolean isCancelled;
    private Exception exception;
    private boolean resultReceived;
    private boolean exceptionReceived;

    public RequestFutureTarget(Handler handler, int n2, int n3) {
        this(handler, n2, n3, true, DEFAULT_WAITER);
    }

    RequestFutureTarget(Handler handler, int n2, int n3, boolean bl, Waiter waiter) {
        this.mainHandler = handler;
        this.width = n2;
        this.height = n3;
        this.assertBackgroundThread = bl;
        this.waiter = waiter;
    }

    @Override
    public synchronized boolean cancel(boolean bl) {
        boolean bl2;
        if (this.isCancelled) {
            return true;
        }
        boolean bl3 = bl2 = !this.isDone();
        if (bl2) {
            this.isCancelled = true;
            if (bl) {
                this.clear();
            }
            this.waiter.notifyAll(this);
        }
        return bl2;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCancelled || this.resultReceived;
    }

    @Override
    public R get() {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Override
    public R get(long l2, TimeUnit timeUnit) {
        return this.doGet(timeUnit.toMillis(l2));
    }

    @Override
    public void getSize(SizeReadyCallback sizeReadyCallback) {
        sizeReadyCallback.onSizeReady(this.width, this.height);
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void onLoadCleared(Drawable drawable) {
    }

    @Override
    public void onLoadStarted(Drawable drawable) {
    }

    @Override
    public synchronized void onLoadFailed(Exception exception, Drawable drawable) {
        this.exceptionReceived = true;
        this.exception = exception;
        this.waiter.notifyAll(this);
    }

    @Override
    public synchronized void onResourceReady(R r2, GlideAnimation<? super R> glideAnimation) {
        this.resultReceived = true;
        this.resource = r2;
        this.waiter.notifyAll(this);
    }

    private synchronized R doGet(Long l2) {
        if (this.assertBackgroundThread) {
            Util.assertBackgroundThread();
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.resultReceived) {
            return this.resource;
        }
        if (l2 == null) {
            this.waiter.waitForTimeout(this, 0L);
        } else if (l2 > 0L) {
            this.waiter.waitForTimeout(this, l2);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.resultReceived) {
            throw new TimeoutException();
        }
        return this.resource;
    }

    @Override
    public void run() {
        if (this.request != null) {
            this.request.clear();
            this.cancel(false);
        }
    }

    @Override
    public void clear() {
        this.mainHandler.post((Runnable)this);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }

    static class Waiter {
        Waiter() {
        }

        public void waitForTimeout(Object object, long l2) {
            object.wait(l2);
        }

        public void notifyAll(Object object) {
            object.notifyAll();
        }
    }
}

