/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPRequestListener;
import com.hpplay.cybergarage.http.HTTPServerList;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.DeviceList;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.ServiceList;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.control.RenewSubscriber;
import com.hpplay.cybergarage.upnp.device.DeviceChangeListener;
import com.hpplay.cybergarage.upnp.device.Disposer;
import com.hpplay.cybergarage.upnp.device.NotifyListener;
import com.hpplay.cybergarage.upnp.device.SearchResponseListener;
import com.hpplay.cybergarage.upnp.device.USN;
import com.hpplay.cybergarage.upnp.event.EventListener;
import com.hpplay.cybergarage.upnp.event.NotifyRequest;
import com.hpplay.cybergarage.upnp.event.Property;
import com.hpplay.cybergarage.upnp.event.PropertyList;
import com.hpplay.cybergarage.upnp.event.SubscriptionRequest;
import com.hpplay.cybergarage.upnp.event.SubscriptionResponse;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifySocketList;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacketHandleTask;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchResponseSocketList;
import com.hpplay.cybergarage.util.ListenerList;
import com.hpplay.cybergarage.util.Mutex;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.NodeList;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ControlPoint
implements HTTPRequestListener {
    private static final String TAG = "Cyber-ControlPoint";
    private static final int DEFAULT_EVENTSUB_PORT = 8058;
    private static final int DEFAULT_SSDP_PORT = 8008;
    private static final int DEFAULT_EXPIRED_DEVICE_MONITORING_INTERVAL = 60;
    public static final int RESULT_CODE_SEND_SEARCH_DATA_FAILED = 4;
    public static final int RESULT_CODE_SEND_SEARCH_INIT_FAILED = 5;
    private String cuid;
    private static final String DEFAULT_EVENTSUB_URI = "/evetSub";
    private SSDPPacketHandleTask mSsdpPacketHandleTasker;
    private SSDPNotifySocketList ssdpNotifySocketList;
    private SSDPSearchResponseSocketList ssdpSearchResponseSocketList;
    private HashSet<String> ssdpSet = new HashSet();
    private Mutex mutex = new Mutex();
    private int ssdpPort = 0;
    private int httpPort = 0;
    private boolean nmprMode;
    private final NodeList devNodeList = new NodeList();
    private final ReentrantReadWriteLock devNodeListLock = new ReentrantReadWriteLock();
    private Disposer deviceDisposer;
    private long expiredDeviceMonitoringInterval;
    private ListenerList deviceNotifyListenerList = new ListenerList();
    private ListenerList deviceSearchResponseListenerList = new ListenerList();
    ListenerList deviceChangeListenerList = new ListenerList();
    private int searchMx = 3;
    private HTTPServerList httpServerList = new HTTPServerList();
    private final ListenerList eventListenerList = new ListenerList();
    private String eventSubURI = "/evetSub";
    public static final int SUBSCIBE_SERVER_RETRY_COUNT = 10;
    private RenewSubscriber renewSubscriber;
    private Object userData = null;

    private SSDPNotifySocketList getSSDPNotifySocketList() {
        return this.ssdpNotifySocketList;
    }

    private SSDPSearchResponseSocketList getSSDPSearchResponseSocketList() {
        return this.ssdpSearchResponseSocketList;
    }

    public ControlPoint(int n2, int n3, InetAddress[] inetAddressArray) {
        this.ssdpNotifySocketList = new SSDPNotifySocketList(inetAddressArray);
        this.ssdpSearchResponseSocketList = new SSDPSearchResponseSocketList(inetAddressArray);
        this.setSSDPPort(n2);
        this.setHTTPPort(n3);
        this.setDeviceDisposer(null);
        this.setExpiredDeviceMonitoringInterval(60L);
        this.setRenewSubscriber(null);
        this.setNMPRMode(false);
        this.setRenewSubscriber(null);
        UPnP.setEnable(9);
    }

    public ControlPoint(int n2, int n3) {
        this(n2, n3, null);
    }

    public ControlPoint(String string) {
        this(8008, 8058);
        this.cuid = string;
    }

    public void finalize() {
        this.stop();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public int getSSDPPort() {
        return this.ssdpPort;
    }

    public void setSSDPPort(int n2) {
        this.ssdpPort = n2;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHTTPPort(int n2) {
        this.httpPort = n2;
    }

    public void setNMPRMode(boolean bl) {
        this.nmprMode = bl;
    }

    public boolean isNMPRMode() {
        return this.nmprMode;
    }

    public void addDevice(Node node) {
        this.devNodeListLock.writeLock().lock();
        try {
            this.devNodeList.add(node);
        }
        catch (Exception exception) {
        }
        finally {
            this.devNodeListLock.writeLock().unlock();
        }
    }

    private synchronized void addDevice(SSDPPacket sSDPPacket) {
        if (this.mSsdpPacketHandleTasker != null && !this.mSsdpPacketHandleTasker.isQuit()) {
            this.mSsdpPacketHandleTasker.updateSSDPPacket(sSDPPacket);
        } else {
            this.startSSDPPacketHandleTask();
            if (this.mSsdpPacketHandleTasker != null) {
                this.mSsdpPacketHandleTasker.updateSSDPPacket(sSDPPacket);
            }
        }
        this.ssdpSet.add(sSDPPacket.toString());
    }

    public HashSet<String> getSsdps() {
        return this.ssdpSet;
    }

    public Device getDevice(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getNode("device");
        if (node2 == null) {
            return null;
        }
        Device device = new Device(node, node2);
        if (device.getService("urn:schemas-upnp-org:service:AVTransport:1") == null) {
            return null;
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceList getDeviceList() {
        this.devNodeListLock.readLock().lock();
        try {
            DeviceList deviceList = new DeviceList();
            int n2 = this.devNodeList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = this.devNodeList.getNode(i2);
                Device device = this.getDevice(node);
                if (device == null) continue;
                deviceList.add(device);
            }
            DeviceList deviceList2 = deviceList;
            return deviceList2;
        }
        finally {
            this.devNodeListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getDevice(String string) {
        this.devNodeListLock.readLock().lock();
        try {
            int n2 = this.devNodeList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Device device;
                Node node = this.devNodeList.getNode(i2);
                Device device2 = this.getDevice(node);
                if (device2 == null) continue;
                if (device2.isDevice(string)) {
                    device = device2;
                    return device;
                }
                device = device2.getDevice(string);
                if (device == null) continue;
                Device device3 = device;
                return device3;
            }
            Device device = null;
            return device;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        finally {
            this.devNodeListLock.readLock().unlock();
        }
        return null;
    }

    public boolean hasDevice(String string) {
        return this.getDevice(string) != null;
    }

    private void removeDevice(Node node) {
        Device device = this.getDevice(node);
        if (device != null && device.isRootDevice()) {
            this.performRemoveDeviceListener(device);
        }
        this.devNodeListLock.writeLock().lock();
        try {
            this.devNodeList.remove(node);
        }
        finally {
            this.devNodeListLock.writeLock().unlock();
        }
    }

    protected void removeDevice(Device device) {
        if (device == null) {
            return;
        }
        this.removeDevice(device.getRootNode());
    }

    public void removeDevice(String string) {
        Device device = this.getDevice(string);
        this.removeDevice(device);
    }

    private void removeDevice(SSDPPacket sSDPPacket) {
        if (!sSDPPacket.isByeBye()) {
            return;
        }
        String string = sSDPPacket.getUSN();
        String string2 = USN.getUDN(string);
        this.removeDevice(string2);
    }

    public void removeExpiredDevices() {
        int n2;
        this.stopNotifySocket();
        DeviceList deviceList = this.getDeviceList();
        int n3 = deviceList.size();
        Device[] deviceArray = new Device[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            deviceArray[n2] = deviceList.getDevice(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!deviceArray[n2].isExpired()) continue;
            CLog.d(TAG, "Expired device = " + deviceArray[n2].getFriendlyName());
            this.removeDevice(deviceArray[n2]);
        }
    }

    public void setExpiredDeviceMonitoringInterval(long l2) {
        this.expiredDeviceMonitoringInterval = l2;
    }

    public long getExpiredDeviceMonitoringInterval() {
        return this.expiredDeviceMonitoringInterval;
    }

    public void setDeviceDisposer(Disposer disposer) {
        this.deviceDisposer = disposer;
    }

    public Disposer getDeviceDisposer() {
        return this.deviceDisposer;
    }

    public void addNotifyListener(NotifyListener notifyListener) {
        this.deviceNotifyListenerList.add(notifyListener);
    }

    public void removeNotifyListener(NotifyListener notifyListener) {
        this.deviceNotifyListenerList.remove(notifyListener);
    }

    public void performNotifyListener(SSDPPacket sSDPPacket) {
        int n2 = this.deviceNotifyListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NotifyListener notifyListener = (NotifyListener)this.deviceNotifyListenerList.get(i2);
            try {
                notifyListener.deviceNotifyReceived(sSDPPacket);
                continue;
            }
            catch (Exception exception) {
                CLog.d(TAG, "NotifyListener returned an error:", exception);
            }
        }
    }

    public void addSearchResponseListener(SearchResponseListener searchResponseListener) {
        this.deviceSearchResponseListenerList.add(searchResponseListener);
    }

    public void removeSearchResponseListener(SearchResponseListener searchResponseListener) {
        this.deviceSearchResponseListenerList.remove(searchResponseListener);
    }

    public void addDeviceChangeListener(DeviceChangeListener deviceChangeListener) {
        this.deviceChangeListenerList.add(deviceChangeListener);
    }

    public void removeDeviceChangeListener(DeviceChangeListener deviceChangeListener) {
        this.deviceChangeListenerList.remove(deviceChangeListener);
    }

    public void performAddDeviceListener(Device device) {
        int n2 = this.deviceChangeListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DeviceChangeListener deviceChangeListener = (DeviceChangeListener)this.deviceChangeListenerList.get(i2);
            deviceChangeListener.deviceAdded(device);
        }
    }

    public void performRemoveDeviceListener(Device device) {
        int n2 = this.deviceChangeListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DeviceChangeListener deviceChangeListener = (DeviceChangeListener)this.deviceChangeListenerList.get(i2);
            deviceChangeListener.deviceRemoved(device);
        }
    }

    public void performSearchResponseListener(SSDPPacket sSDPPacket) {
        int n2 = this.deviceSearchResponseListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SearchResponseListener searchResponseListener = (SearchResponseListener)this.deviceSearchResponseListenerList.get(i2);
            try {
                searchResponseListener.deviceSearchResponseReceived(sSDPPacket);
                continue;
            }
            catch (Exception exception) {
                CLog.d(TAG, "SearchResponseListener returned an error:", exception);
            }
        }
    }

    public void notifyReceived(SSDPPacket sSDPPacket) {
        if (sSDPPacket.isRootDevice()) {
            if (sSDPPacket.isAlive()) {
                this.addDevice(sSDPPacket);
            } else if (sSDPPacket.isByeBye()) {
                this.removeDevice(sSDPPacket);
            }
        }
        this.performNotifyListener(sSDPPacket);
    }

    public void searchResponseReceived(SSDPPacket sSDPPacket) {
        if (sSDPPacket.isRootDevice()) {
            this.addDevice(sSDPPacket);
        }
        this.performSearchResponseListener(sSDPPacket);
    }

    public int getSearchMx() {
        return this.searchMx;
    }

    public void setSearchMx(int n2) {
        this.searchMx = n2;
    }

    public void search(String string, int n2) {
        SSDPSearchRequest sSDPSearchRequest = new SSDPSearchRequest(string, n2, this.cuid);
        sSDPSearchRequest.print();
        SSDPSearchResponseSocketList sSDPSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        boolean bl = sSDPSearchResponseSocketList.post(sSDPSearchRequest);
        if (!bl && this.deviceChangeListenerList != null) {
            this.callbackResultCode(4);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        SSDPSearchRequest sSDPSearchRequest2 = new SSDPSearchRequest("urn:schemas-upnp-org:device:MediaRenderer:1", n2, this.cuid);
        sSDPSearchRequest2.print();
        sSDPSearchResponseSocketList.post(sSDPSearchRequest2);
    }

    public void callbackResultCode(int n2) {
        try {
            for (int i2 = 0; i2 < this.deviceChangeListenerList.size(); ++i2) {
                ((DeviceChangeListener)this.deviceChangeListenerList.get(i2)).deviceAdded(n2, null);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void search(String string) {
        this.search(string, 3);
    }

    public void search() {
        this.search("upnp:rootdevice", 3);
    }

    private HTTPServerList getHTTPServerList() {
        return this.httpServerList;
    }

    @Override
    public void httpRequestRecieved(HTTPRequest hTTPRequest) {
        try {
            hTTPRequest.print();
            if (hTTPRequest.isNotifyRequest()) {
                NotifyRequest notifyRequest = new NotifyRequest(hTTPRequest);
                String string = notifyRequest.getSID();
                long l2 = notifyRequest.getSEQ();
                PropertyList propertyList = notifyRequest.getPropertyList();
                if (propertyList != null) {
                    int n2 = propertyList.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Property property = propertyList.getProperty(i2);
                        String string2 = property.getName();
                        String string3 = property.getValue();
                        this.performEventListener(string, l2, string2, string3);
                    }
                    hTTPRequest.returnOK();
                } else {
                    hTTPRequest.returnBadRequest();
                }
                return;
            }
            hTTPRequest.returnBadRequest();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void addEventListener(EventListener eventListener) {
        this.eventListenerList.add(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.eventListenerList.remove(eventListener);
        if (this.eventListenerList.size() > 1) {
            this.eventListenerList.clear();
        }
    }

    public void performEventListener(String string, long l2, String string2, String string3) {
        try {
            int n2 = this.eventListenerList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                EventListener eventListener = (EventListener)this.eventListenerList.get(i2);
                eventListener.eventNotifyReceived(string, l2, string2, string3);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public String getEventSubURI() {
        return this.eventSubURI;
    }

    public void setEventSubURI(String string) {
        this.eventSubURI = string;
    }

    private String getEventSubCallbackURL(String string) {
        return HostInterface.getHostURL(string, this.getHTTPPort(), this.getEventSubURI());
    }

    public boolean subscribe(Service service, long l2) {
        if (service.isSubscribed()) {
            String string = service.getSID();
            return this.subscribe(service, string, l2);
        }
        Device device = service.getRootDevice();
        if (device == null) {
            return false;
        }
        String string = device.getInterfaceAddress();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest();
        subscriptionRequest.setSubscribeRequest(service, this.getEventSubCallbackURL(HostInterface.getIPv4Address()), l2);
        SubscriptionResponse subscriptionResponse = subscriptionRequest.post();
        if (subscriptionResponse.isSuccessful()) {
            service.setSID(subscriptionResponse.getSID());
            service.setTimeout(subscriptionResponse.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service) {
        if (this.subscribe(service, -1L)) {
            this.startSucribeServ();
            return true;
        }
        return false;
    }

    public boolean startSucribeServ() {
        HTTPServerList hTTPServerList = this.getHTTPServerList();
        if (hTTPServerList.isRuning()) {
            CLog.d(TAG, "server is started");
            return true;
        }
        int n2 = 0;
        int n3 = this.getHTTPPort();
        while (!hTTPServerList.open(n3)) {
            if (10 < ++n2) {
                return false;
            }
            this.setHTTPPort(n3 + 1);
            n3 = this.getHTTPPort();
        }
        hTTPServerList.addRequestListener(this);
        hTTPServerList.start();
        return true;
    }

    public boolean subscribe(Service service, String string, long l2) {
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest();
        subscriptionRequest.setRenewRequest(service, string, l2);
        subscriptionRequest.print();
        SubscriptionResponse subscriptionResponse = subscriptionRequest.post();
        subscriptionResponse.print();
        if (subscriptionResponse.isSuccessful()) {
            service.setSID(subscriptionResponse.getSID());
            service.setTimeout(subscriptionResponse.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service, String string) {
        return this.subscribe(service, string, -1L);
    }

    public boolean isSubscribed(Service service) {
        if (service == null) {
            return false;
        }
        return service.isSubscribed();
    }

    public boolean unsubscribe(Service service) {
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest();
        subscriptionRequest.setUnsubscribeRequest(service);
        SubscriptionResponse subscriptionResponse = subscriptionRequest.post();
        if (subscriptionResponse.isSuccessful()) {
            service.clearSID();
            return true;
        }
        return false;
    }

    public void unsubscribe(Device device) {
        try {
            if (device != null) {
                ServiceList serviceList = device.getServiceList();
                int n2 = serviceList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Service service = serviceList.getService(i2);
                    if (!service.hasSID()) continue;
                    this.unsubscribe(service);
                }
                DeviceList deviceList = device.getDeviceList();
                int n3 = deviceList.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Device device2 = deviceList.getDevice(i3);
                    this.unsubscribe(device2);
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void unsubscribe() {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            this.unsubscribe(device);
        }
    }

    public Service getSubscriberService(String string) {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            Service service = device.getSubscriberService(string);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public void renewSubscriberService(Device device, long l2) {
        ServiceList serviceList = device.getServiceList();
        int n2 = serviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            boolean bl;
            Service service = serviceList.getService(i2);
            if (!service.isSubscribed() || (bl = this.subscribe(service, string = service.getSID(), l2))) continue;
            this.subscribe(service, l2);
        }
        DeviceList deviceList = device.getDeviceList();
        int n3 = deviceList.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Device device2 = deviceList.getDevice(i3);
            this.renewSubscriberService(device2, l2);
        }
    }

    public void renewSubscriberService(long l2) {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            this.renewSubscriberService(device, l2);
        }
    }

    public void renewSubscriberService() {
        this.renewSubscriberService(-1L);
    }

    public void setRenewSubscriber(RenewSubscriber renewSubscriber) {
        this.renewSubscriber = renewSubscriber;
    }

    public RenewSubscriber getRenewSubscriber() {
        return this.renewSubscriber;
    }

    private void startSSDPPacketHandleTask() {
        this.mSsdpPacketHandleTasker = new SSDPPacketHandleTask(this);
        this.mSsdpPacketHandleTasker.start();
    }

    public boolean start(String string, int n2) {
        this.stop();
        boolean bl = false;
        this.startSSDPPacketHandleTask();
        SSDPNotifySocketList sSDPNotifySocketList = this.getSSDPNotifySocketList();
        if (!sSDPNotifySocketList.open()) {
            return false;
        }
        sSDPNotifySocketList.setControlPoint(this);
        sSDPNotifySocketList.start();
        this.createSearchList();
        this.search(string, n2);
        Disposer disposer = new Disposer(this);
        this.setDeviceDisposer(disposer);
        disposer.start();
        if (this.isNMPRMode()) {
            RenewSubscriber renewSubscriber = new RenewSubscriber(this);
            this.setRenewSubscriber(renewSubscriber);
            renewSubscriber.start();
        }
        return true;
    }

    private boolean createSearchList() {
        int n2 = this.getSSDPPort();
        int n3 = 0;
        SSDPSearchResponseSocketList sSDPSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        n2 += new Random().nextInt(10000);
        while (!sSDPSearchResponseSocketList.open(n2)) {
            if (100 < ++n3) {
                return false;
            }
            this.setSSDPPort(n2 + 1);
            n2 = this.getSSDPPort();
        }
        sSDPSearchResponseSocketList.setControlPoint(this);
        sSDPSearchResponseSocketList.start();
        return true;
    }

    public boolean start(String string) {
        return this.start(string, 3);
    }

    public boolean start() {
        return this.start("upnp:rootdevice", 3);
    }

    public boolean stop() {
        RenewSubscriber renewSubscriber;
        if (this.mSsdpPacketHandleTasker != null) {
            this.mSsdpPacketHandleTasker.release();
            this.mSsdpPacketHandleTasker = null;
        }
        this.unsubscribe();
        this.stopNotifySocket();
        SSDPSearchResponseSocketList sSDPSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        sSDPSearchResponseSocketList.stop();
        sSDPSearchResponseSocketList.close();
        sSDPSearchResponseSocketList.clear();
        HTTPServerList hTTPServerList = this.getHTTPServerList();
        hTTPServerList.stop();
        hTTPServerList.close();
        hTTPServerList.clear();
        Disposer disposer = this.getDeviceDisposer();
        if (disposer != null) {
            disposer.stop();
            this.setDeviceDisposer(null);
        }
        if ((renewSubscriber = this.getRenewSubscriber()) != null) {
            renewSubscriber.stop();
            this.setRenewSubscriber(null);
        }
        if (null != this.devNodeList) {
            // empty if block
        }
        return true;
    }

    public void stopNotifySocket() {
        SSDPNotifySocketList sSDPNotifySocketList = this.getSSDPNotifySocketList();
        if (sSDPNotifySocketList.isRuning()) {
            sSDPNotifySocketList.stop();
            sSDPNotifySocketList.close();
            sSDPNotifySocketList.clear();
        }
    }

    public synchronized void release() {
        this.stop();
    }

    public boolean stopSearch() {
        SSDPNotifySocketList sSDPNotifySocketList = this.getSSDPNotifySocketList();
        sSDPNotifySocketList.stop();
        sSDPNotifySocketList.close();
        sSDPNotifySocketList.clear();
        SSDPSearchResponseSocketList sSDPSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        sSDPSearchResponseSocketList.stop();
        sSDPSearchResponseSocketList.close();
        sSDPSearchResponseSocketList.clear();
        Disposer disposer = this.getDeviceDisposer();
        if (disposer != null) {
            disposer.stop();
            this.setDeviceDisposer(null);
        }
        return true;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void print() {
        DeviceList deviceList = this.getDeviceList();
        int n2 = deviceList.size();
        CLog.d(TAG, "Device Num = " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Device device = deviceList.getDevice(i2);
            CLog.d(TAG, "[" + i2 + "] " + device.getFriendlyName() + ", " + device.getLeaseTime() + ", " + device.getElapsedTime());
        }
    }

    static {
        UPnP.initialize();
    }
}

