/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.Date;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPHeader;
import com.hpplay.cybergarage.http.HTTPSocket;
import com.hpplay.cybergarage.http.HTTPStatus;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class HTTPPacket {
    private static final String TAG = "Cyber-HTTPPacket";
    private String version;
    private String firstLine = "";
    private Vector httpHeaderList = new Vector();
    private byte[] content = new byte[0];
    private InputStream contentInput = null;

    public HTTPPacket() {
        this.setVersion("1.1");
        this.setContentInputStream(null);
    }

    public HTTPPacket(HTTPPacket hTTPPacket) {
        this.setVersion("1.1");
        this.set(hTTPPacket);
        this.setContentInputStream(null);
    }

    public HTTPPacket(InputStream inputStream) {
        this.setVersion("1.1");
        this.set(inputStream);
        this.setContentInputStream(null);
    }

    public void init() {
        this.setFirstLine("");
        this.clearHeaders();
        this.setContent(new byte[0], false);
        this.setContentInputStream(null);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    private String readLine(BufferedInputStream bufferedInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1];
        try {
            int n2 = bufferedInputStream.read(byArray);
            while (0 < n2 && byArray[0] != 10) {
                if (byArray[0] != 13) {
                    byteArrayOutputStream.write(byArray[0]);
                }
                n2 = bufferedInputStream.read(byArray);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            CLog.d(TAG, null, iOException);
        }
        return byteArrayOutputStream.toString();
    }

    protected boolean set(InputStream inputStream, boolean bl) {
        try {
            Object object;
            Object object2;
            String string;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string2 = this.readLine(bufferedInputStream);
            if (string2 == null || string2.length() <= 0) {
                return false;
            }
            this.setFirstLine(string2);
            HTTPStatus hTTPStatus = new HTTPStatus(string2);
            int n2 = hTTPStatus.getStatusCode();
            if (n2 == 100) {
                string = this.readLine(bufferedInputStream);
                while (string != null && 0 < string.length()) {
                    object2 = new HTTPHeader(string);
                    if (((HTTPHeader)object2).hasName()) {
                        this.setHeader((HTTPHeader)object2);
                    }
                    string = this.readLine(bufferedInputStream);
                }
                object2 = this.readLine(bufferedInputStream);
                if (object2 != null && 0 < ((String)object2).length()) {
                    this.setFirstLine((String)object2);
                } else {
                    return true;
                }
            }
            string = this.readLine(bufferedInputStream);
            while (string != null && 0 < string.length()) {
                object2 = new HTTPHeader(string);
                if (((HTTPHeader)object2).hasName()) {
                    this.setHeader((HTTPHeader)object2);
                }
                string = this.readLine(bufferedInputStream);
            }
            if (bl) {
                this.setContent("", false);
                return true;
            }
            boolean bl2 = this.isChunked();
            long l2 = 0L;
            if (bl2) {
                try {
                    object = this.readLine(bufferedInputStream);
                    l2 = object != null ? Long.parseLong(((String)object).trim(), 16) : 0L;
                }
                catch (Exception exception) {}
            } else {
                l2 = this.getContentLength();
            }
            object = new ByteArrayOutputStream();
            while (0L < l2) {
                int n3;
                int n4 = HTTP.getChunkSize();
                byte[] byArray = new byte[(int)(l2 > (long)n4 ? (long)n4 : l2)];
                for (long i2 = 0L; i2 < l2; i2 += (long)n3) {
                    try {
                        long l3 = l2 - i2;
                        if ((long)n4 < l3) {
                            l3 = n4;
                        }
                        if ((n3 = bufferedInputStream.read(byArray, 0, (int)l3)) < 0) break;
                        ((ByteArrayOutputStream)object).write(byArray, 0, n3);
                        continue;
                    }
                    catch (Exception exception) {
                        CLog.d(TAG, null, exception);
                        break;
                    }
                }
                if (bl2) {
                    long l4;
                    long l5 = 0L;
                    while ((l4 = bufferedInputStream.skip((long)"\r\n".length() - l5)) >= 0L && (l5 += l4) < (long)"\r\n".length()) {
                    }
                    try {
                        String string3 = this.readLine(bufferedInputStream);
                        l2 = Long.parseLong(new String(string3.getBytes(), 0, string3.length() - 2), 16);
                    }
                    catch (Exception exception) {
                        l2 = 0L;
                    }
                    continue;
                }
                l2 = 0L;
            }
            this.setContent(((ByteArrayOutputStream)object).toByteArray(), false);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    protected boolean set(InputStream inputStream) {
        return this.set(inputStream, false);
    }

    protected boolean set(HTTPSocket hTTPSocket) {
        return this.set(hTTPSocket.getInputStream());
    }

    protected void set(HTTPPacket hTTPPacket) {
        this.setFirstLine(hTTPPacket.getFirstLine());
        this.clearHeaders();
        int n2 = hTTPPacket.getNHeaders();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPHeader hTTPHeader = hTTPPacket.getHeader(i2);
            this.addHeader(hTTPHeader);
        }
        this.setContent(hTTPPacket.getContent());
    }

    public boolean read(HTTPSocket hTTPSocket) {
        this.init();
        return this.set(hTTPSocket);
    }

    private void setFirstLine(String string) {
        this.firstLine = string;
    }

    protected String getFirstLine() {
        return this.firstLine;
    }

    protected String getFirstLineToken(int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.firstLine, " ");
        String string = "";
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (!stringTokenizer.hasMoreTokens()) {
                return "";
            }
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public boolean hasFirstLine() {
        return 0 < this.firstLine.length();
    }

    public int getNHeaders() {
        return this.httpHeaderList.size();
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        this.httpHeaderList.add(hTTPHeader);
    }

    public void addHeader(String string, String string2) {
        HTTPHeader hTTPHeader = new HTTPHeader(string, string2);
        this.httpHeaderList.add(hTTPHeader);
    }

    public HTTPHeader getHeader(int n2) {
        return (HTTPHeader)this.httpHeaderList.get(n2);
    }

    public HTTPHeader getHeader(String string) {
        int n2 = this.getNHeaders();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPHeader hTTPHeader = this.getHeader(i2);
            String string2 = hTTPHeader.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return hTTPHeader;
        }
        return null;
    }

    public void clearHeaders() {
        this.httpHeaderList.clear();
        this.httpHeaderList = new Vector();
    }

    public boolean hasHeader(String string) {
        return this.getHeader(string) != null;
    }

    public void setHeader(String string, String string2) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader != null) {
            hTTPHeader.setValue(string2);
            return;
        }
        this.addHeader(string, string2);
    }

    public void setHeader(String string, int n2) {
        this.setHeader(string, Integer.toString(n2));
    }

    public void setHeader(String string, long l2) {
        this.setHeader(string, Long.toString(l2));
    }

    public void setHeader(HTTPHeader hTTPHeader) {
        this.setHeader(hTTPHeader.getName(), hTTPHeader.getValue());
    }

    public String getHeaderValue(String string) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return "";
        }
        return hTTPHeader.getValue();
    }

    public void setStringHeader(String string, String string2, String string3, String string4) {
        String string5 = string2;
        if (!string5.startsWith(string3)) {
            string5 = string3 + string5;
        }
        if (!string5.endsWith(string4)) {
            string5 = string5 + string4;
        }
        this.setHeader(string, string5);
    }

    public void setStringHeader(String string, String string2) {
        this.setStringHeader(string, string2, "\"", "\"");
    }

    public String getStringHeaderValue(String string, String string2, String string3) {
        String string4 = this.getHeaderValue(string);
        if (string4.startsWith(string2)) {
            string4 = string4.substring(1, string4.length());
        }
        if (string4.endsWith(string3)) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        return string4;
    }

    public String getStringHeaderValue(String string) {
        return this.getStringHeaderValue(string, "\"", "\"");
    }

    public void setIntegerHeader(String string, int n2) {
        this.setHeader(string, Integer.toString(n2));
    }

    public void setLongHeader(String string, long l2) {
        this.setHeader(string, Long.toString(l2));
    }

    public int getIntegerHeaderValue(String string) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return 0;
        }
        return StringUtil.toInteger(hTTPHeader.getValue());
    }

    public long getLongHeaderValue(String string) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return 0L;
        }
        return StringUtil.toLong(hTTPHeader.getValue());
    }

    public String getHeaderString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getNHeaders();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPHeader hTTPHeader = this.getHeader(i2);
            stringBuffer.append(hTTPHeader.getName() + ": " + hTTPHeader.getValue() + "\r\n");
        }
        return stringBuffer.toString();
    }

    public void setContent(byte[] byArray, boolean bl) {
        this.content = byArray;
        if (bl) {
            this.setContentLength(byArray.length);
        }
    }

    public void setContent(byte[] byArray) {
        this.setContent(byArray, true);
    }

    public void setContent(String string, boolean bl) {
        if (string != null) {
            this.setContent(string.getBytes(), bl);
        }
    }

    public void setContent(String string) {
        this.setContent(string, true);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentString() {
        String string = this.getCharSet();
        if (string == null || string.length() <= 0) {
            return new String(this.content);
        }
        try {
            return new String(this.content, string);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return new String(this.content);
        }
    }

    public boolean hasContent() {
        return this.content.length > 0;
    }

    public void setContentInputStream(InputStream inputStream) {
        this.contentInput = inputStream;
    }

    public InputStream getContentInputStream() {
        return this.contentInput;
    }

    public boolean hasContentInputStream() {
        return this.contentInput != null;
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
    }

    public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public void setContentLanguage(String string) {
        this.setHeader("Content-Language", string);
    }

    public String getContentLanguage() {
        return this.getHeaderValue("Content-Language");
    }

    public String getCharSet() {
        String string = this.getContentType();
        if (string == null) {
            return "";
        }
        int n2 = (string = string.toLowerCase()).indexOf("charset");
        if (n2 < 0) {
            return "";
        }
        int n3 = n2 + "charset".length() + 1;
        String string2 = new String(string.getBytes(), n3, string.length() - n3);
        if (string2.length() < 0) {
            return "";
        }
        if (string2.charAt(0) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.length() < 0) {
            return "";
        }
        if (string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public void setContentLength(long l2) {
        this.setLongHeader("Content-Length", l2);
    }

    public long getContentLength() {
        return this.getLongHeaderValue("Content-Length");
    }

    public boolean hasConnection() {
        return this.hasHeader("Connection");
    }

    public void setConnection(String string) {
        this.setHeader("Connection", string);
        this.setHeader("Cache-Control", "no-cache");
    }

    public String getConnection() {
        return this.getHeaderValue("Connection");
    }

    public boolean isCloseConnection() {
        if (!this.hasConnection()) {
            return false;
        }
        String string = this.getConnection();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("close");
    }

    public boolean isKeepAliveConnection() {
        if (!this.hasConnection()) {
            return false;
        }
        String string = this.getConnection();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("Keep-Alive");
    }

    public boolean hasContentRange() {
        return this.hasHeader("Content-Range") || this.hasHeader("Range");
    }

    public void setContentRange(long l2, long l3, long l4) {
        String string = "";
        string = string + "bytes ";
        string = string + Long.toString(l2) + "-";
        string = string + Long.toString(l3) + "/";
        string = string + (0L < l4 ? Long.toString(l4) : "*");
        this.setHeader("Content-Range", string);
    }

    public long[] getContentRange() {
        long[] lArray = new long[3];
        lArray[2] = 0L;
        lArray[1] = 0L;
        lArray[0] = 0L;
        if (!this.hasContentRange()) {
            return lArray;
        }
        String string = this.getHeaderValue("Content-Range");
        if (string.length() <= 0) {
            string = this.getHeaderValue("Range");
        }
        if (string.length() <= 0) {
            return lArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
        if (!stringTokenizer.hasMoreTokens()) {
            return lArray;
        }
        String string2 = stringTokenizer.nextToken(" ");
        if (!stringTokenizer.hasMoreTokens()) {
            return lArray;
        }
        String string3 = stringTokenizer.nextToken(" -");
        try {
            lArray[0] = Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return lArray;
        }
        String string4 = stringTokenizer.nextToken("-/");
        try {
            lArray[1] = Long.parseLong(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return lArray;
        }
        String string5 = stringTokenizer.nextToken("/");
        try {
            lArray[2] = Long.parseLong(string5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lArray;
    }

    public long getContentRangeFirstPosition() {
        long[] lArray = this.getContentRange();
        return lArray[0];
    }

    public long getContentRangeLastPosition() {
        long[] lArray = this.getContentRange();
        return lArray[1];
    }

    public long getContentRangeInstanceLength() {
        long[] lArray = this.getContentRange();
        return lArray[2];
    }

    public void setCacheControl(String string) {
        this.setHeader("Cache-Control", string);
    }

    public void setCacheControl(String string, int n2) {
        String string2 = string + "=" + Integer.toString(n2);
        this.setHeader("Cache-Control", string2);
    }

    public void setCacheControl(int n2) {
        this.setCacheControl("max-age", n2);
    }

    public String getCacheControl() {
        return this.getHeaderValue("Cache-Control");
    }

    public void setServer(String string) {
        this.setHeader("Server", string);
    }

    public String getServer() {
        return this.getHeaderValue("Server");
    }

    public void setHost(String string, int n2) {
        String string2 = string;
        if (HostInterface.isIPv6Address(string)) {
            string2 = "[" + string + "]";
        }
        this.setHeader("HOST", string2 + ":" + Integer.toString(n2));
    }

    public void setHost(String string) {
        String string2 = string;
        if (HostInterface.isIPv6Address(string)) {
            string2 = "[" + string + "]";
        }
        this.setHeader("HOST", string2);
    }

    public String getHost() {
        return this.getHeaderValue("HOST");
    }

    public void setDate(Calendar calendar) {
        Date date = new Date(calendar);
        this.setHeader("Date", date.getDateString());
    }

    public String getDate() {
        return this.getHeaderValue("Date");
    }

    public boolean hasTransferEncoding() {
        return this.hasHeader("Transfer-Encoding");
    }

    public void setTransferEncoding(String string) {
        this.setHeader("Transfer-Encoding", string);
    }

    public String getTransferEncoding() {
        return this.getHeaderValue("Transfer-Encoding");
    }

    public boolean isChunked() {
        if (!this.hasTransferEncoding()) {
            return false;
        }
        String string = this.getTransferEncoding();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("Chunked");
    }
}

