/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.ClientEvidenceRoutine;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Routines;
import com.hpplay.component.protocol.srp6.ServerEvidenceRoutine;
import com.hpplay.component.protocol.srp6.URoutine;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public abstract class SRP6Session
implements Serializable {
    protected final SRP6Routines srp6Routines;
    private static final long serialVersionUID = 3813344182070859518L;
    protected SRP6CryptoParams config;
    protected SecureRandom random = new SecureRandom();
    protected final int timeout;
    protected long lastActivity;
    protected String userID = null;
    protected BigInteger s = null;
    protected BigInteger A = null;
    protected BigInteger B = null;
    protected BigInteger u = null;
    protected BigInteger k = null;
    protected BigInteger S = null;
    protected BigInteger M1 = null;
    protected BigInteger M2 = null;
    protected ClientEvidenceRoutine clientEvidenceRoutine = null;
    protected ServerEvidenceRoutine serverEvidenceRoutine = null;
    protected URoutine hashedKeysRoutine = null;
    private Map<String, Object> attributes = null;

    public SRP6Session(int n2, SRP6Routines sRP6Routines) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The timeout must be zero (no timeout) or greater");
        }
        this.timeout = n2;
        this.srp6Routines = sRP6Routines;
    }

    public SRP6Session(int n2) {
        this(n2, new SRP6Routines());
    }

    public SRP6Session() {
        this(0, new SRP6Routines());
    }

    protected void updateLastActivityTime() {
        this.lastActivity = System.currentTimeMillis();
    }

    public long getLastActivityTime() {
        return this.lastActivity;
    }

    public boolean hasTimedOut() {
        if (this.timeout == 0) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        return l2 > this.lastActivity + (long)(this.timeout * 1000);
    }

    public SRP6CryptoParams getCryptoParams() {
        return this.config;
    }

    public String getUserID() {
        return this.userID;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setClientEvidenceRoutine(ClientEvidenceRoutine clientEvidenceRoutine) {
        this.clientEvidenceRoutine = clientEvidenceRoutine;
    }

    public ClientEvidenceRoutine getClientEvidenceRoutine() {
        return this.clientEvidenceRoutine;
    }

    public void setServerEvidenceRoutine(ServerEvidenceRoutine serverEvidenceRoutine) {
        this.serverEvidenceRoutine = serverEvidenceRoutine;
    }

    public ServerEvidenceRoutine getServerEvidenceRoutine() {
        return this.serverEvidenceRoutine;
    }

    public URoutine getHashedKeysRoutine() {
        return this.hashedKeysRoutine;
    }

    public void setHashedKeysRoutine(URoutine uRoutine) {
        this.hashedKeysRoutine = uRoutine;
    }

    public BigInteger getSalt() {
        return this.s;
    }

    public BigInteger getPublicClientValue() {
        return this.A;
    }

    public BigInteger getPublicServerValue() {
        return this.B;
    }

    public BigInteger getClientEvidenceMessage() {
        return this.M1;
    }

    public BigInteger getServerEvidenceMessage() {
        return this.M2;
    }

    public BigInteger getSessionKey() {
        return this.S;
    }

    public byte[] getSessionKeyHash() {
        if (this.S == null) {
            return null;
        }
        MessageDigest messageDigest = this.config.getMessageDigestInstance();
        if (messageDigest == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + this.config.H);
        }
        return messageDigest.digest(BigIntegerUtils.bigIntegerToBytes(this.S));
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("The attribute key must not be null");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The attribute key must not be null");
        }
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }
}

