/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.mirror.AudioDataSender;
import com.hpplay.component.protocol.mirror.LelinkRtpPacker;
import com.hpplay.component.protocol.mirror.VideoDataSendStrategy;
import com.hpplay.component.protocol.mirror.rtsp.LelinkRtspClient;
import com.hpplay.component.protocol.mirror.rtsp.LelinkV2RtspClient;
import com.hpplay.component.protocol.mirror.rtsp.RtspClient;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class MirrorProtocolTask
extends Thread
implements IMirrorStateListener {
    private static final String TAG = "MirrorProtocolTask";
    private static final int KEEP_ALIVE_VALUE = 5000;
    private static final int CHECK_TIMEOUT_VALUE = 1000;
    private final Object mLock = new Object();
    private boolean isRunning = false;
    private boolean isOpen;
    private RtspClient mRtspClient;
    private IMirrorStateListener mListener;
    private LelinkRtpPacker mRtpPacker = new LelinkRtpPacker();
    private long mVideoSendTime;
    private long mAudioSendTime;
    private long mOptionSendTime;
    private int mProtocalType;
    private VideoDataSendStrategy mVideoDataSender;
    private AudioDataSender mAudioDataSender;
    private ParamsMap mMaramsMap;
    private boolean isAutoBitrate = false;
    private static final int RECONNECT_INTERVAL = 2000;
    private static final int RECONNECT_TIMEOUT = 42000;
    private int mReconnCount = 0;
    private int mMaxReconnect;
    private boolean isNetworkBroken;
    private int mEventPort;
    private String mMirrorType;
    private final AtomicBoolean isLocked = new AtomicBoolean(false);
    private boolean isChangeMode;
    private boolean isSwitchChannel;
    private int mTimeoutStopValue;
    private int mOpionErrorCount = 0;
    private int mChannelType = 2;

    public MirrorProtocolTask(ParamsMap paramsMap) {
        this.setName(TAG);
        this.mMaramsMap = paramsMap;
        this.isOpen = Boolean.parseBoolean(paramsMap.getParam("mirror_audio", false).toString());
        this.isAutoBitrate = Boolean.parseBoolean(paramsMap.getParam("auto_bitrate", false).toString());
        this.mMaxReconnect = (Integer)paramsMap.getParam("reconnect_count", 0);
        CLog.i(TAG, "==========> " + this.mMaxReconnect + " ==== " + this.isOpen + "  == " + this.isAutoBitrate);
        if (!TextUtils.isEmpty((CharSequence)paramsMap.getVV()) && TextUtils.equals((CharSequence)paramsMap.getVV(), (CharSequence)"2")) {
            this.mRtspClient = new LelinkV2RtspClient(paramsMap);
            this.mProtocalType = 5;
        } else {
            this.mRtspClient = new LelinkRtspClient(paramsMap);
            this.mProtocalType = 1;
        }
    }

    public void setRtspListener(IMirrorStateListener iMirrorStateListener) {
        this.mListener = iMirrorStateListener;
    }

    public void setMirrorEventPort(int n2) {
        this.mEventPort = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean bl;
        String string = "mirror run ";
        int n2 = this.mRtspClient.exeLelinkRtsp(this.isOpen, String.valueOf(this.mEventPort), this.mMirrorType, String.valueOf(this.mChannelType));
        if (n2 != 1) {
            this.onError(n2, this.mRtspClient.getErrorMsg());
            return;
        }
        this.isRunning = true;
        this.onSuccessful(false);
        try {
            if (this.mProtocalType == 1) {
                this.mVideoDataSender.putVideoData(this.mRtpPacker.packetOldLelinkFrameInfoData(this.mMaramsMap.getMac()));
            }
        }
        catch (IOException iOException) {
            CLog.w(TAG, iOException);
        }
        CLog.i(TAG, string);
        try {
            while (this.isRunning) {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.isNeedReconnect()) {
                        if (!this.startReconnect()) {
                            CLog.i(TAG, " reconnect failed ...  ");
                            break;
                        }
                        CLog.i(TAG, " reconnect successful ...  ");
                    }
                    if (this.sendHeartbeat()) {
                        CLog.i(TAG, "   sendHeartbeat FAILED ");
                        break;
                    }
                    this.changeMode();
                    this.changeWLANChannel();
                    this.checkSendDataTimeout();
                    if (this.isRunning && !this.isNetworkBroken) {
                        this.isLocked.set(true);
                        this.mLock.wait(1000L);
                        this.isLocked.set(false);
                    }
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (this.mRtspClient != null && !this.isNetworkBroken && (bl = this.mRtspClient.sendRequestSetTeardown())) {
            CLog.i(TAG, "send tear down success ...");
        }
        CLog.i(TAG, " mirror thread exit ..." + this.isRunning);
        this.stopAll();
    }

    private boolean sendHeartbeat() {
        if (this.mVideoSendTime > 0L && System.currentTimeMillis() - this.mVideoSendTime >= 5000L && this.mVideoDataSender != null) {
            CLog.i(TAG, "send video  heartbeat data ..  ");
            this.mVideoSendTime = System.currentTimeMillis();
            this.mVideoDataSender.putVideoData(this.mRtpPacker.getHeartbeatData());
        }
        if (this.mAudioSendTime > 0L && System.currentTimeMillis() - this.mAudioSendTime >= 10000L && this.mAudioDataSender != null) {
            CLog.i(TAG, "send audio  heartbeat data ..  ");
            this.mAudioSendTime = System.currentTimeMillis();
            this.mAudioDataSender.putAudioData(new byte[0], 0, 0);
        }
        if (System.currentTimeMillis() - this.mOptionSendTime < 5000L) {
            return false;
        }
        CLog.i(TAG, "send mirror main connection heartbeat ... ");
        this.mOptionSendTime = System.currentTimeMillis();
        if (!this.mRtspClient.sendRequestSetOptions()) {
            CLog.i(TAG, " send option error  ..  ");
            if (this.mOpionErrorCount > 2) {
                CLog.i(TAG, " mirror exit  ");
                this.onError(120105111, null);
                return true;
            }
            ++this.mOpionErrorCount;
        } else {
            this.mOpionErrorCount = 0;
        }
        return false;
    }

    private void changeMode() {
        if (this.isChangeMode) {
            CLog.i(TAG, " change mirror mode  ");
            this.isChangeMode = false;
            this.mRtspClient.setMirrorMode(this.mMirrorType);
        }
    }

    private boolean isNeedReconnect() {
        if (this.mMaxReconnect > 0 && this.mProtocalType == 5 && this.mVideoDataSender != null && (this.mVideoDataSender.isWriteTimeout() || this.isNetworkBroken)) {
            this.isNetworkBroken = false;
            return true;
        }
        return false;
    }

    private void checkSendDataTimeout() {
        if (this.mVideoDataSender != null && this.mTimeoutStopValue > 0 && this.mVideoDataSender.getWritTimeout() >= this.mTimeoutStopValue) {
            CLog.i(TAG, "  SendData Timeout ");
            this.onBroken();
        }
    }

    private synchronized void startAudioEncoder() {
        if (this.isOpen) {
            CLog.i(TAG, "  startAudioEncoder ");
            this.mAudioDataSender = new AudioDataSender();
            this.mAudioDataSender.setServerInfo(this.mRtspClient.getAudioServerIp(), this.mRtspClient.getAudioPort());
            this.mAudioDataSender.start();
        }
    }

    public void switchWLANChannel(int n2) {
        this.mChannelType = n2;
        if (this.mListener != null) {
            this.mListener.onPauseEncode();
        }
        this.isSwitchChannel = true;
        this.wakeup();
    }

    private void changeWLANChannel() {
        if (this.isSwitchChannel && this.mRtspClient != null) {
            this.isSwitchChannel = false;
            try {
                int n2 = this.mRtspClient.sendRequestVideoSetup(this.mEventPort, this.mChannelType);
                CLog.i(TAG, " change wlan channel ret :" + n2);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (this.mListener != null) {
                this.mListener.resetEncoder();
            }
        }
    }

    public void setMirrorMode(String string) {
        this.mMirrorType = string;
        this.isChangeMode = true;
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        if (this.isRunning && this.isLocked.get()) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
    }

    private boolean startReconnect() {
        if (this.mReconnCount > this.mMaxReconnect) {
            return false;
        }
        this.onPauseEncode();
        if (this.mRtspClient != null) {
            this.mRtspClient.release();
        }
        if (this.mAudioDataSender != null) {
            this.mAudioDataSender.stopTask();
        }
        if (this.mVideoDataSender == null) {
            return false;
        }
        this.mVideoDataSender.stopTask();
        this.mVideoDataSender = null;
        CLog.i(TAG, "start reconnect mirror ...");
        ++this.mReconnCount;
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - l2 < 42000L && this.mRtspClient != null) {
                bl = this.mRtspClient.exeLelinkRtsp(this.isOpen, String.valueOf(this.mEventPort), this.mMirrorType) == 1;
                CLog.i(TAG, "reconnect mirror " + bl);
                if (!bl && !this.isInterrupted()) {
                    Thread.sleep(2000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.onSuccessful(true);
        try {
            this.resetEncoder();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            bl = false;
        }
        return bl;
    }

    private synchronized void onSuccessful(boolean bl) {
        this.mRtpPacker.setEncodeType(this.mRtspClient.getEncodeType());
        this.mVideoDataSender = new VideoDataSendStrategy(this.mRtspClient.getVideoDataSender(), this, (int)this.mRtspClient.getRefreshRate());
        this.mVideoDataSender.setAutoBitrate(this.isAutoBitrate);
        this.mVideoDataSender.start();
        this.startAudioEncoder();
        if (!bl) {
            this.onSinkPrepared(this.mRtspClient.getSinkWidth(), this.mRtspClient.getSinkHeight(), (int)this.mRtspClient.getRefreshRate(), this.mRtspClient.getBitRate(), this.mRtspClient.getEncodeType());
        }
    }

    public void setAutoBitrate(boolean bl) {
        this.isAutoBitrate = bl;
    }

    public void sendVideoData(ByteBuffer byteBuffer, int n2, long l2) {
        if (this.mVideoDataSender != null) {
            if (this.mVideoDataSender.isQuit()) {
                this.onError(120105111, null);
                this.stopAll();
                return;
            }
            if (100 == n2) {
                n2 = (byte)(byteBuffer.get(4) & 0xF);
                byteBuffer.rewind();
            }
            this.mVideoSendTime = System.currentTimeMillis();
            this.mVideoDataSender.putVideoData(this.mRtpPacker.videoDataPacked(byteBuffer, this.mRtspClient.mMirrorFrameEcrypto, n2, l2));
        }
    }

    public void sendAudioData(byte[] byArray, int n2, int n3) {
        if (this.mAudioDataSender != null) {
            this.mAudioSendTime = System.currentTimeMillis();
            this.mAudioDataSender.putAudioData(byArray, n2, n3);
        }
    }

    public synchronized void stopMirror() {
        CLog.i(TAG, " stop mirror ...  ");
        this.isRunning = false;
        this.interrupt();
        this.stopAll();
    }

    private synchronized void stopAll() {
        CLog.i(TAG, " stop  mirror protocol");
        this.isRunning = false;
        this.interrupt();
        if (this.mVideoDataSender != null) {
            this.mVideoDataSender.stopTask();
            this.mVideoDataSender = null;
        }
        if (this.mAudioDataSender != null) {
            this.mAudioDataSender.stopTask();
            this.mAudioDataSender = null;
        }
    }

    @Override
    public void onError(int n2, String string) {
        if (this.mListener != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("errCode", n2);
                jSONObject.put("errMsg", (Object)string);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            this.mListener.onError(n2, jSONObject.toString());
        }
    }

    @Override
    public void onSinkStop(String string, int n2) {
        if (this.mListener != null) {
            this.mListener.onSinkStop(string, n2);
        }
    }

    @Override
    public void onSinkPrepared(int n2, int n3, int n4, int n5, String string) {
        if (this.mListener != null) {
            this.mListener.onSinkPrepared(n2, n3, n4, n5, string);
        }
    }

    @Override
    public void onPauseEncode() {
        if (this.mListener != null) {
            this.mListener.onPauseEncode();
        }
    }

    @Override
    public void onResumeEncode() {
        if (this.mListener != null) {
            this.mListener.onResumeEncode();
        }
    }

    @Override
    public void resetEncoder() {
        if (this.mListener != null) {
            this.mListener.resetEncoder();
        }
    }

    @Override
    public void onBroken() {
        this.stopMirror();
        this.isNetworkBroken = true;
        if (this.mListener != null) {
            this.mListener.onBroken();
        }
    }

    @Override
    public void onBitrateCallback(int n2) {
        if (this.mListener != null) {
            this.mListener.onBitrateCallback(n2);
        }
    }

    @Override
    public void onResolutionCallback(int n2, int n3) {
        if (this.mListener != null) {
            this.mListener.onResolutionCallback(n2, n3);
        }
    }

    @Override
    public void onMirrorModeCallback(String string) {
        if (this.mListener != null) {
            this.mListener.onMirrorModeCallback(string);
        }
    }

    @Override
    public boolean onNetworkPoor() {
        if (this.mListener != null) {
            return this.mListener.onNetworkPoor();
        }
        return false;
    }

    @Override
    public void onFrameCallback(int n2) {
        if (this.mListener != null) {
            this.mListener.onFrameCallback(n2);
        }
    }

    @Override
    public void onNetStateChange(int n2) {
        if (this.mListener != null) {
            this.mListener.onNetStateChange(n2);
        }
    }

    public void setSendDataTimeout(int n2) {
        CLog.i(TAG, "-----------setSendDataTimeout -----" + n2);
        this.mTimeoutStopValue = n2 * 1000;
    }

    protected void finalize() {
        super.finalize();
    }
}

