/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.os.Build;
import android.os.StatFs;
import com.hpplay.common.log.LeLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2Bytes(String string) {
        LeLog.i(TAG, "file2String");
        byte[] byArray = new byte[]{};
        File file = new File(string);
        if (!file.exists()) {
            LeLog.w(TAG, string + " is not exist: ");
            return byArray;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n2 = fileInputStream.available();
            byte[] byArray2 = new byte[n2];
            fileInputStream.read(byArray2);
            byArray = byArray2;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(String string) {
        LeLog.i(TAG, "file2String");
        String string2 = "";
        File file = new File(string);
        if (!file.exists()) {
            LeLog.w(TAG, string + " is not exist: ");
            return string2;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n2 = fileInputStream.available();
            byte[] byArray = new byte[n2];
            fileInputStream.read(byArray);
            string2 = new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            LeLog.w(TAG, "read " + string + " failed");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void string2File(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string2);
            file.delete();
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            LeLog.w(TAG, "string2File failed," + string2);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
        }
    }

    public static long getAvailSize(String string) {
        StatFs statFs = new StatFs(string);
        long l2 = 0L;
        l2 = Build.VERSION.SDK_INT < 18 ? (long)statFs.getBlockSize() : statFs.getBlockSizeLong();
        long l3 = 0L;
        l3 = Build.VERSION.SDK_INT < 18 ? (long)statFs.getAvailableBlocks() : statFs.getAvailableBlocksLong();
        long l4 = l3 * l2;
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string2));
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            filterOutputStream = new BufferedOutputStream(zipOutputStream);
            File file = new File(string);
            FileUtil.compress(zipOutputStream, (BufferedOutputStream)filterOutputStream, file, file.getName());
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ZipOutputStream zipOutputStream, BufferedOutputStream bufferedOutputStream, File file, String string) {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray.length == 0) {
                    zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
                } else {
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        FileUtil.compress(zipOutputStream, bufferedOutputStream, fileArray[i2], string + "/" + fileArray[i2].getName());
                    }
                }
            } else {
                int n2;
                zipOutputStream.putNextEntry(new ZipEntry(string));
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                while ((n2 = bufferedInputStream.read()) != -1) {
                    bufferedOutputStream.write(n2);
                }
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            }
        }
    }

    public static boolean deleteFile(String string) {
        return FileUtil.deleteFile(new File(string));
    }

    public static boolean deleteFile(File file) {
        LeLog.i(TAG, "delete dir: " + file.getAbsolutePath());
        if (file.isDirectory()) {
            FileUtil.deleteAllChildFile(file);
        }
        boolean bl = file.delete();
        return bl;
    }

    public static void deleteAllChildFile(File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                boolean bl = FileUtil.deleteFile(new File(file, stringArray[i2]));
                if (bl) continue;
            }
        }
    }
}

