/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.hpplay.common.log.LeLog;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ContextPath {
    private static final String TAG = "ContextPath";
    public static final int TYPE_THINK_SDK = 0;
    public static final int TYPE_THINK_APP = 1;
    public static final int TYPE_SOURCE_SDK = 2;
    public static final int TYPE_SOURCE_APP = 3;
    public static final String DATA_HPPLAY = "data_hpplay";
    public static final String DATA_FILE = "data_file";
    public static final String DATA_IMG = "data_img";
    public static final String DATA_AV = "data_av";
    public static final String DATA_APK = "data_apk";
    public static final String DATA_UPDATE = "data_update";
    public static final String DATA_COMMON = "data_common";
    public static final String LIB = "lib";
    public static final String CACHE_HPPLAY = "cache_hpplay";
    public static final String CACHE_DATA_FILE = "cache_data_file";
    public static final String CACHE_DATA_IMG = "cache_data_img";
    public static final String CACHE_DATA_AV = "cache_data_av";
    public static final String CACHE_DATA_APK = "cache_data_apk";
    public static final String CACHE_DATA_COMMON = "cache_data_common";
    public static final String SDCARD_HPPLAY = "sdcard_hpplay";
    public static final String SDCARD_FILE = "sdcard_file";
    public static final String SDCARD_IMG = "sdcard_img";
    public static final String SDCARD_AV = "sdcard_av";
    public static final String SDCARD_APK = "sdcard_apk";
    public static final String SDCARD_UPDATE = "sdcard_update";
    public static final String SDCARD_COMMON = "sdcard_common";
    public static final String APP_PATH = "app_path";
    private Map<String, String> dirMap = new HashMap<String, String>();
    private static Map<Integer, ContextPath> mPathMap = new HashMap<Integer, ContextPath>();

    public static ContextPath getInstance(Context context, int n2, String string) {
        ContextPath contextPath = mPathMap.get(n2);
        if (contextPath == null) {
            contextPath = new ContextPath(context, n2, string);
            mPathMap.put(n2, contextPath);
        }
        return contextPath;
    }

    private ContextPath(Context context, int n2, String string) {
        this.initDirs(context, n2, string);
    }

    public String getPath(String string) {
        String string2 = this.dirMap.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static String jointPath(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 == objectArray.length - 1) {
                stringBuilder.append(objectArray[i2]);
                continue;
            }
            stringBuilder.append(objectArray[i2]).append(File.separator);
        }
        return stringBuilder.toString();
    }

    private void initDirs(Context context, int n2, String string) {
        if (context == null) {
            throw new NullPointerException("context con not null");
        }
        this.dirMap.clear();
        String string2 = "hpplay";
        String string3 = context.getCacheDir().getAbsolutePath();
        String string4 = ContextPath.jointPath(string3, string2);
        String[] stringArray = new String[]{CACHE_DATA_FILE, CACHE_DATA_IMG, CACHE_DATA_AV, CACHE_DATA_APK, CACHE_DATA_COMMON};
        this.makeDir(stringArray, ContextPath.jointPath(string4));
        this.dirMap.put(CACHE_HPPLAY, string3);
        String string5 = context.getFilesDir().getAbsolutePath();
        String string6 = ContextPath.jointPath(string5, string2);
        String[] stringArray2 = new String[]{DATA_FILE, DATA_IMG, DATA_AV, DATA_APK, DATA_COMMON, DATA_UPDATE};
        this.makeDir(stringArray2, string6);
        this.dirMap.put(DATA_HPPLAY, string5);
        String string7 = context.getPackageResourcePath();
        String string8 = new File(string7).getParent();
        this.dirMap.put(APP_PATH, string8);
        String string9 = "";
        switch (n2) {
            case 0: {
                string9 = "sink/sdk";
                break;
            }
            case 1: {
                string9 = "sink/app";
                break;
            }
            case 2: {
                string9 = "source/sdk";
                break;
            }
            case 3: {
                string9 = "source/app";
            }
        }
        String string10 = "";
        String string11 = "/mnt/sdcard";
        try {
            if (Environment.getExternalStorageDirectory() != null) {
                string11 = Environment.getExternalStorageDirectory().getPath();
            } else {
                LeLog.w(TAG, "can not get sdcard path, use default");
            }
            string10 = !TextUtils.isEmpty((CharSequence)string) ? ContextPath.jointPath(string11, string, string9) : ContextPath.jointPath(string11, context.getPackageName(), string9);
            String[] stringArray3 = new String[]{SDCARD_FILE, SDCARD_IMG, SDCARD_AV, SDCARD_APK, SDCARD_COMMON, SDCARD_UPDATE};
            this.makeDir(stringArray3, string10);
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        this.dirMap.put(SDCARD_HPPLAY, string10);
        this.dirMap.put(LIB, context.getFilesDir().getParent() + "/lib");
    }

    private void makeDir(String[] stringArray, String string) {
        String[] stringArray2 = new String[]{"file", "image", "av", "apk", "common", "hpdata"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 >= stringArray2.length) continue;
            String string2 = ContextPath.jointPath(string, stringArray2[i2]);
            this.mkdirs(string2);
            this.dirMap.put(stringArray[i2], string2);
        }
    }

    private void mkdirs(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

