/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi.transceiver;

import android.util.Log;
import com.tony.bluetoothunityapi.ClassicBluetoothHelper;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class SocketTransceiver
implements ITransceiver {
    private ClassicBluetoothHelper helper;
    private InputStream inputStream;
    private boolean stopThread;
    private Thread thread;
    private boolean listening;
    private ITransceiver.OnTransceiverMessageReceived listener;

    public SocketTransceiver(ClassicBluetoothHelper helper) {
        this.helper = helper;
        this.stopThread = false;
        this.listening = false;
    }

    @Override
    public void listen() {
        this.stopThread = false;
        if (this.listening) {
            return;
        }
        this.listening = true;
        this.inputStream = this.helper.getInputStream();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[100];
                while (!Thread.currentThread().isInterrupted() && !SocketTransceiver.this.stopThread) {
                    try {
                        if (SocketTransceiver.this.inputStream.available() == 0) {
                            Thread.sleep(10L);
                            continue;
                        }
                        int bytes_read = SocketTransceiver.this.inputStream.read(buffer);
                        if (SocketTransceiver.this.listener == null) continue;
                        Log.d((String)"BluetoothAPI", (String)("Received " + bytes_read));
                        byte[] out = Arrays.copyOfRange(buffer, 0, bytes_read);
                        SocketTransceiver.this.listener.OnMessageReceived(out);
                    }
                    catch (IOException | InterruptedException ex) {
                        Log.e((String)"BluetoothAPI", (String)ex.getMessage());
                        ex.printStackTrace();
                        if (!SocketTransceiver.this.stopThread) {
                            SocketTransceiver.this.helper.invokeOnConnectionFailed();
                        }
                        SocketTransceiver.this.stopThread = true;
                    }
                }
                SocketTransceiver.this.listening = false;
                if (!SocketTransceiver.this.stopThread) {
                    SocketTransceiver.this.helper.invokeOnConnectionFailed();
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void setOnMessageReceived(ITransceiver.OnTransceiverMessageReceived listener) {
        this.listener = listener;
    }

    @Override
    public void write(byte b) {
        try {
            this.helper.getOutputStream().write(b);
        }
        catch (Exception ex) {
            this.stopThread = true;
            this.helper.invokeOnConnectionFailed();
            ex.printStackTrace();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void write(byte[] b) {
        try {
            Log.d((String)"BluetoothAPI", (String)"Sending message");
            this.helper.getOutputStream().write(b);
            Log.d((String)"BluetoothAPI", (String)"Message sent");
        }
        catch (Exception ex) {
            Log.e((String)"BluetoothAPI", (String)ex.getMessage());
            this.stopThread = true;
            this.helper.invokeOnConnectionFailed();
            ex.printStackTrace();
        }
    }

    @Override
    public void stop(boolean s) {
        this.stopThread = s;
    }
}

