/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartbowlib;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class BluetoothHelper {
    private static final String TAG = "SB-BluetoothHelper";
    private static final int PERMISSION_REQUEST_CODE = 1414;

    public static boolean requestPermissions(Context context) {
        return new BluetoothPermissionRequester(context).enablePermission();
    }

    private static class BluetoothPermissionRequester {
        private Context m_context;

        private BluetoothPermissionRequester(Context context) {
            this.m_context = context;
        }

        private boolean enablePermission() {
            ArrayList<String> permissions = new ArrayList<String>();
            if (Build.VERSION.SDK_INT >= 23) {
                permissions.add("android.permission.ACCESS_COARSE_LOCATION");
                permissions.add("android.permission.ACCESS_FINE_LOCATION");
                this.removeGrantedPermission(permissions);
                if (permissions.size() > 0) {
                    this.requestPermission(permissions);
                    return false;
                }
                if (Build.VERSION.SDK_INT < 31) {
                    permissions.add("android.permission.BLUETOOTH");
                    permissions.add("android.permission.BLUETOOTH_ADMIN");
                } else {
                    permissions.add("android.permission.BLUETOOTH_SCAN");
                    permissions.add("android.permission.BLUETOOTH_ADVERTISE");
                    permissions.add("android.permission.BLUETOOTH_CONNECT");
                }
                this.removeGrantedPermission(permissions);
                if (permissions.size() > 0) {
                    this.requestPermission(permissions);
                    return false;
                }
            }
            return permissions.size() == 0;
        }

        private void removeGrantedPermission(List<String> permissions) {
            for (int i = permissions.size() - 1; i >= 0; --i) {
                String permission2 = permissions.get(i);
                if (this.m_context.checkSelfPermission(permission2) != 0) continue;
                permissions.remove(i);
                Log.d((String)BluetoothHelper.TAG, (String)("Permission Granted " + permission2));
            }
        }

        private void requestPermission(List<String> permissions) {
            ((Activity)this.m_context).requestPermissions(permissions.toArray(new String[0]), 1414);
        }
    }
}

