/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.connect;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.component.common.protocol.IConnector;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.bean.BaseBean;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.protocol.connect.CloudConnectBridge;
import com.hpplay.sdk.source.protocol.connect.LocalConnectBridge;
import com.hpplay.sdk.source.utils.BrowseResultOnlineCheck;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CheckDisconnect;
import com.hpplay.sdk.source.utils.Feature;

public class ConnectBridge {
    private static final String TAG = "ConnectBridge";
    private Context mContext;
    public AbsConnectBridge mConnectBridge;
    public int mConnectProtocol = -1;
    private IConnectListener mAppListener;
    public boolean isGroup = false;
    private IConnectListener mConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            SourceLog.i(ConnectBridge.TAG, "onConnect");
            ConnectBridge.this.mConnectProtocol = n2;
            if (ConnectBridge.this.mAppListener != null) {
                ConnectBridge.this.mAppListener.onConnect(lelinkServiceInfo, n2);
            }
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            BrowserInfo browserInfo;
            SourceLog.i(ConnectBridge.TAG, "onDisconnect " + n2 + "/" + n3 + " " + lelinkServiceInfo);
            if (ConnectBridge.this.isGroup) {
                SourceLog.i(ConnectBridge.TAG, "group onDisconnect " + n2 + "/" + n3 + " " + lelinkServiceInfo);
                return;
            }
            if (CheckDisconnect.disableRetry(n2, n3)) {
                ConnectBridge.this.callbackDisconnect(lelinkServiceInfo, n2, n3);
                return;
            }
            if (n3 == 212018) {
                ConnectManager.getInstance().notifyOffline(lelinkServiceInfo);
                return;
            }
            if (ConnectBridge.this.mConnectBridge instanceof LocalConnectBridge && (browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4)) != null) {
                SourceLog.w(ConnectBridge.TAG, "connect retry by im");
                ConnectBridge.this.mConnectBridge = new CloudConnectBridge(ConnectBridge.this.mContext);
                ConnectBridge.this.mConnectBridge.setConnectListener(ConnectBridge.this.mConnectListener);
                ConnectBridge.this.mConnectBridge.connect(lelinkServiceInfo);
                return;
            }
            SourceLog.i(ConnectBridge.TAG, "onDisconnect go to online check " + lelinkServiceInfo);
            if (Feature.isLeboApp()) {
                LelinkSdkManager.getInstance().uploadLog("4001", "");
            }
            BrowseResultOnlineCheck.getInstance().checkDeviceOnline(lelinkServiceInfo, n2, n3);
        }
    };

    public ConnectBridge(Context context, LelinkServiceInfo lelinkServiceInfo) {
        this.mContext = context;
        this.mConnectBridge = CastUtil.isUseLocalCast(lelinkServiceInfo) ? new LocalConnectBridge(context) : new CloudConnectBridge(context);
        this.mConnectBridge.setConnectListener(this.mConnectListener);
    }

    public void setGroupConnect(boolean bl) {
        this.isGroup = bl;
    }

    public ConnectBridge(Context context, int n2) {
        this.mContext = context;
        this.mConnectBridge = n2 == 1 ? new LocalConnectBridge(context) : new CloudConnectBridge(context);
        this.mConnectBridge.setConnectListener(this.mConnectListener);
    }

    public ConnectBridge() {
    }

    public boolean checkBridge(LelinkServiceInfo lelinkServiceInfo) {
        if (CastUtil.isUseLocalCast(lelinkServiceInfo)) {
            return this.mConnectBridge instanceof LocalConnectBridge;
        }
        return this.mConnectBridge instanceof CloudConnectBridge;
    }

    public void setConnectListener(IConnectListener iConnectListener) {
        this.mAppListener = iConnectListener;
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        this.mConnectProtocol = -1;
        this.mConnectBridge.connect(lelinkServiceInfo);
    }

    public void disconnect(int n2) {
        this.mConnectProtocol = -1;
        this.mConnectBridge.disconnect(n2);
    }

    public int getConnectProtocol() {
        return this.mConnectProtocol;
    }

    public boolean isConnected() {
        return this.mConnectBridge.isConnected();
    }

    public void setSinkSM(String string) {
        this.mConnectBridge.setSinkSM(string);
    }

    public void saveConnectBean(String string) {
        this.mConnectBridge.saveConnectBean(string);
    }

    public void notifyPassReceivedData(int n2, BaseBean baseBean) {
        this.mConnectBridge.notifyPassReceivedData(n2, baseBean);
    }

    public void addOnPassReceivedListener(Object object, AbsConnectBridge.OnPassReceivedListener onPassReceivedListener) {
        this.mConnectBridge.addOnPassReceivedListener(object, onPassReceivedListener);
    }

    public void removeOnPassReceivedListener(Object object) {
        this.mConnectBridge.removeOnPassReceivedListener(object);
    }

    public void addOnPassSendCompleteListener(Object object, AbsConnectBridge.OnPassSendCompleteListener onPassSendCompleteListener) {
        this.mConnectBridge.addOnPassSendCompleteListener(object, onPassSendCompleteListener);
    }

    public void removeOnPassSendCompleteListener(Object object) {
        this.mConnectBridge.removeOnPassSendCompleteListener(object);
    }

    public boolean isSupportUrlList() {
        return this.mConnectBridge.isSupportUrlList();
    }

    public boolean isSupportTrack() {
        return this.mConnectBridge.isSupportTrack();
    }

    public boolean isSupportPassMsg(int n2) {
        return this.mConnectBridge.isSupportPassMsg(n2);
    }

    public boolean isSupportPassthrough() {
        return this.mConnectBridge != null && (CastUtil.isSupportLelinkV2(this.mConnectBridge.getServiceInfo()) || CastUtil.isSupportIM(this.mConnectBridge.getServiceInfo()));
    }

    public LelinkServiceInfo getServiceInfo() {
        return this.mConnectBridge.getServiceInfo();
    }

    public String getConnectSession() {
        return this.mConnectBridge.getConnectSession();
    }

    public void sendPassData(int n2, String string, String string2) {
        if (this.mConnectBridge == null) {
            SourceLog.w(TAG, "sendPassData ignore");
            return;
        }
        SourceLog.i(TAG, " ============sendPassData is local :" + (this.mConnectBridge instanceof LocalConnectBridge));
        this.mConnectBridge.sendPassData(n2, string, string2);
    }

    private void callbackDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
        if (this.mAppListener != null) {
            this.mAppListener.onDisconnect(lelinkServiceInfo, n2, n3);
        }
        try {
            OutParameter outParameter = BusinessEntity.getInstance().getCurrentPlayInfo();
            if (outParameter != null && outParameter.castType == 2 && outParameter.serviceInfo != null && TextUtils.equals((CharSequence)outParameter.serviceInfo.getUid(), (CharSequence)lelinkServiceInfo.getUid())) {
                LelinkSdkManager.getInstance().stopPlayWithCallback(1004);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public IConnector getConnector() {
        if (this.mConnectBridge instanceof LocalConnectBridge) {
            return ((LocalConnectBridge)this.mConnectBridge).getConnector();
        }
        return null;
    }

    public boolean isLocalBridge() {
        return this.mConnectBridge instanceof LocalConnectBridge;
    }

    public void release() {
        this.mAppListener = null;
        this.mConnectBridge.release();
    }
}

