/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.business.IMQueue;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.connect.OnPlayStateListener;
import org.json.JSONObject;

public class CloudBridge
extends AbsBridge {
    private static final String TAG = "CloudBridge";
    private String mReportPrepareDramaId = null;
    private final OnPlayStateListener mStateListener = new OnPlayStateListener(){

        @Override
        public void onStart(String string) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)CloudBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(CloudBridge.TAG, "onStart ignore, " + string + "/" + CloudBridge.this.mPlayInfo.urlID);
                return;
            }
            if (CloudBridge.this.mPlayInfo != null && CloudBridge.this.mPlayInfo.urls != null) {
                if (CloudBridge.this.mReportPrepareDramaId == null || !CloudBridge.this.mReportPrepareDramaId.equals(CloudBridge.this.mPlayInfo.dramaID)) {
                    CloudBridge.this.mReportPrepareDramaId = CloudBridge.this.mPlayInfo.dramaID;
                    if (CloudBridge.this.mPreparedListener != null) {
                        CloudBridge.this.mPreparedListener.onPrepared(null);
                    }
                } else if (CloudBridge.this.mStateChangeListener != null) {
                    CloudBridge.this.mStateChangeListener.onStateChanged(null, 3);
                }
            } else if (!CloudBridge.this.isCallPrepared) {
                CloudBridge.this.isCallPrepared = true;
                if (CloudBridge.this.mPreparedListener != null) {
                    CloudBridge.this.mPreparedListener.onPrepared(null);
                }
            } else if (CloudBridge.this.mStateChangeListener != null) {
                CloudBridge.this.mStateChangeListener.onStateChanged(null, 3);
            }
        }

        @Override
        public void onPause(String string) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)CloudBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(CloudBridge.TAG, "onPause ignore, " + string + "/" + CloudBridge.this.mPlayInfo.urlID);
                return;
            }
            if (CloudBridge.this.mStateChangeListener != null) {
                CloudBridge.this.mStateChangeListener.onStateChanged(null, 4);
            }
        }

        @Override
        public void onPlaying(String string, int n2, int n3) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)CloudBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(CloudBridge.TAG, "onPlaying ignore, " + string + "/" + CloudBridge.this.mPlayInfo.urlID);
                return;
            }
            if (CloudBridge.this.mInfoListener != null) {
                CloudBridge.this.mInfoListener.onInfo(null, 100, n2, n3);
            }
        }

        @Override
        public void onError(String string, String string2) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)CloudBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(CloudBridge.TAG, "onError ignore, " + string + "/" + CloudBridge.this.mPlayInfo.urlID);
                return;
            }
            if (CloudBridge.this.mErrorListener != null) {
                CloudBridge.this.mErrorListener.onError(null, 210010, 210011, null);
            }
        }

        @Override
        public void onStop(String string, int n2) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)CloudBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(CloudBridge.TAG, "onStop ignore, " + string + "/" + CloudBridge.this.mPlayInfo.urlID);
                return;
            }
            CloudBridge.this.isCallPrepared = false;
            if (n2 == 0) {
                if (CloudBridge.this.mCompletionListener != null) {
                    CloudBridge.this.mCompletionListener.onComplete(null);
                }
            } else if (CloudBridge.this.mStopListener != null) {
                StopInfo stopInfo = new StopInfo();
                stopInfo.type = n2 == 2 ? 3 : 1;
                CloudBridge.this.mStopListener.onStop(null, stopInfo);
            }
        }
    };
    private boolean isCallPrepared = false;

    public CloudBridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
    }

    @Override
    public void play(String string) {
        SourceLog.i(TAG, "play: " + string);
        IMQueue.getInstance().clearTask();
        PublicCastClient.getInstance().setOnPlayStateListener(this.mStateListener);
        this.isCallPrepared = false;
        if (this.mPlayInfo.playerInfoBean != null && !this.mPlayInfo.playerInfoBean.isEmpty()) {
            this.mPlayInfo.playerInfoBean.setUri(this.mPlayInfo.urlID);
            PassSender.getInstance().sendPlayerInfo(this.mPlayInfo.playerInfoBean, this.mPlayInfo.session);
        }
        if (this.mPlayInfo.mediaAssetBean != null && !this.mPlayInfo.mediaAssetBean.isEmpty()) {
            this.mPlayInfo.mediaAssetBean.setUri(this.mPlayInfo.urlID);
            PassSender.getInstance().sendMediaAssets(this.mPlayInfo.mediaAssetBean, this.mPlayInfo.session);
        }
        PublicCastClient.getInstance().play(this.mPlayInfo, "", new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter != null && asyncHttpParameter.out != null && asyncHttpParameter.out.resultType == 2) {
                    SourceLog.w(CloudBridge.TAG, "play onRequestResult cancel ");
                    return;
                }
                if (asyncHttpParameter == null || asyncHttpParameter.out == null || asyncHttpParameter.out.result == null) {
                    SourceLog.w(CloudBridge.TAG, "play onRequestResult failed ");
                    if (CloudBridge.this.mErrorListener != null) {
                        CloudBridge.this.mErrorListener.onError(null, 210000, 210011, null);
                    }
                    return;
                }
                String string = asyncHttpParameter.out.result;
                SourceLog.debug(CloudBridge.TAG, "play onRequestResult " + string);
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    int n2 = jSONObject.optInt("status");
                    JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                    String string2 = "";
                    if (jSONObject2 != null) {
                        string2 = jSONObject2.optString("msg");
                    }
                    if (n2 == 403) {
                        if (CloudBridge.this.mErrorListener != null) {
                            CloudBridge.this.mErrorListener.onError(null, 210010, 210004, string2);
                        }
                        return;
                    }
                    if (n2 == 200) {
                        if (CloudBridge.this.mLoadingListener != null) {
                            CloudBridge.this.mLoadingListener.onLoading(null, null);
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(CloudBridge.TAG, exception);
                }
                if (CloudBridge.this.mErrorListener != null) {
                    CloudBridge.this.mErrorListener.onError(null, 210010, 210011, string);
                }
            }
        });
    }

    @Override
    public void resume(String string) {
        SourceLog.i(TAG, "resume: " + string);
        PublicCastClient.getInstance().resume(this.mPlayInfo);
    }

    @Override
    public void pause(String string) {
        SourceLog.i(TAG, "pause: " + string);
        PublicCastClient.getInstance().pause(this.mPlayInfo);
    }

    @Override
    public void playDrama(String string, String string2) {
        SourceLog.i(TAG, "playDrama " + string + " / " + string2);
        PublicCastClient.getInstance().playDrama(this.mPlayInfo, string2);
    }

    @Override
    public void playNextDrama(String string) {
        SourceLog.i(TAG, "playNextDrama " + string);
        PublicCastClient.getInstance().playNextDrama(this.mPlayInfo);
    }

    @Override
    public void playPreDrama(String string) {
        SourceLog.i(TAG, "playPreDrama " + string);
        PublicCastClient.getInstance().playPreDrama(this.mPlayInfo);
    }

    @Override
    public void appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        SourceLog.i(TAG, "appendPlayList " + string);
        PublicCastClient.getInstance().setPlayList(this.mPlayInfo, "append-playlist", dramaInfoBeanArray, n2, n3, n4);
    }

    @Override
    public void clearPlayList(String string) {
        SourceLog.i(TAG, "clearPlayList " + string);
        PublicCastClient.getInstance().setPlayList(this.mPlayInfo, "clear-playlist", null, 0, -1, -1);
    }

    @Override
    public void seekTo(int n2) {
        SourceLog.i(TAG, "seekTo: second := " + n2);
        PublicCastClient.getInstance().seekTo(this.mPlayInfo, n2);
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "stop: " + string);
        PublicCastClient.getInstance().stop(this.mPlayInfo);
    }

    @Override
    public void addVolume() {
        SourceLog.i(TAG, "addVolume");
        PublicCastClient.getInstance().addVolume(this.mPlayInfo);
    }

    @Override
    public void subVolume() {
        SourceLog.i(TAG, "subVolume");
        PublicCastClient.getInstance().subVolume(this.mPlayInfo);
    }

    @Override
    public void setVolume(int n2) {
        SourceLog.i(TAG, "setVolume");
        PublicCastClient.getInstance().setVolume(this.mPlayInfo, n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        SourceLog.i(TAG, "selectAudiotrack index:" + n2);
        PublicCastClient.getInstance().selectTrack(this.mPlayInfo, n2);
    }

    @Override
    public void release() {
    }
}

