/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.display.VirtualDisplay;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.screencupture.IScreenCapture;
import com.hpplay.component.common.screencupture.IScreenCaptureCallbackListener;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.WatermarkBean;
import com.hpplay.sdk.source.browse.api.OptionCentral;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.MirrorNotification;
import com.hpplay.sdk.source.utils.Adapter;
import com.hpplay.sdk.source.utils.BitmapUtils;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.nio.ByteBuffer;

public class CaptureBridge {
    private static final String TAG = "CaptureBridge";
    private static final int BITRATE_HIGH = 0x700000;
    private static final int BITRATE_LOW = 0x100000;
    private static final int BITRATE_DEFAULT = 0x400000;
    private ModuleLinker mModuleLinker;
    private IScreenCapture mScreenCapture;
    public static CaptureBridge mCaptureController;
    private OutParameter mPlayInfo;
    private SparseArray<AbsBridge> mAbsBridges = new SparseArray();
    private boolean isInitialize;
    private ICaptureDispatcher mCaptureDispatcher;
    private boolean isFirstVideoFrame = true;
    private int mBitRate = Integer.MAX_VALUE;
    private boolean isReuseDisplay = true;
    private int mRotation;
    private boolean isAdjust;
    private IScreenCaptureCallbackListener mCaptureListener = new IScreenCaptureCallbackListener(){

        @Override
        public void onVideoDataCallback(ByteBuffer byteBuffer, int n2, int n3, int n4, long l2) {
            this.sendNoneAudioData();
            try {
                if (CaptureBridge.this.mCaptureDispatcher != null) {
                    CaptureBridge.this.mCaptureDispatcher.onVideoDataCallback(byteBuffer, n2, n3, n4, l2);
                    return;
                }
                for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                    ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).sendVideoData(byteBuffer, n2, n3, n4, l2);
                }
            }
            catch (Exception exception) {
                SourceLog.w(CaptureBridge.TAG, exception);
            }
        }

        void sendNoneAudioData() {
            if (CaptureBridge.this.isFirstVideoFrame) {
                CaptureBridge.this.isFirstVideoFrame = false;
                if (this.needInsertAudio()) {
                    byte[] byArray = new byte[1];
                    if (CaptureBridge.this.mCaptureDispatcher != null) {
                        CaptureBridge.this.mCaptureDispatcher.onAudioDataCallback(byArray, 0, 1, 1);
                        return;
                    }
                    for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                        ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).sendAudioData(byArray, 0, 1);
                    }
                }
            }
        }

        private boolean needInsertAudio() {
            int n2 = CaptureBridge.this.getAudioSwitch();
            return CaptureBridge.this.mPlayInfo != null && ((CaptureBridge)CaptureBridge.this).mPlayInfo.serviceInfo != null && CastUtil.isSupportLelinkV2(((CaptureBridge)CaptureBridge.this).mPlayInfo.serviceInfo) && (n2 == 0 || n2 == 1);
        }

        @Override
        public void onAudioDataCallback(byte[] byArray, int n2, int n3, int n4) {
            try {
                if (CaptureBridge.this.mCaptureDispatcher != null) {
                    CaptureBridge.this.mCaptureDispatcher.onAudioDataCallback(byArray, n2, n3, n4);
                    return;
                }
                for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                    ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).sendAudioData(byArray, n2, n3);
                }
            }
            catch (Exception exception) {
                SourceLog.w(CaptureBridge.TAG, exception);
            }
        }

        @Override
        public void onScreenshot(int n2) {
            if (CaptureBridge.this.mCaptureDispatcher != null) {
                CaptureBridge.this.mCaptureDispatcher.onCaptureScreenshot(n2);
                return;
            }
            for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).screenshot(n2);
            }
        }

        @Override
        public void onStop(int n2) {
            SourceLog.i(CaptureBridge.TAG, "onStop capture " + n2);
            if (CaptureBridge.this.mCaptureDispatcher != null) {
                CaptureBridge.this.mCaptureDispatcher.onCaptureStop(n2);
                return;
            }
            for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).onCaptureStop(n2);
            }
        }

        @Override
        public void onStart(int n2) {
            SourceLog.i(CaptureBridge.TAG, "onStart capture " + n2 + " " + (Object)((Object)((CaptureBridge)CaptureBridge.this).mPlayInfo.secondMirrorView));
            boolean bl = Preference.getInstance().get("mirror_secret_switch", false);
            if (((CaptureBridge)CaptureBridge.this).mPlayInfo.secondMirrorView != null) {
                ((CaptureBridge)CaptureBridge.this).mPlayInfo.secondMirrorView.post(new Runnable(){

                    @Override
                    public void run() {
                        CaptureBridge.this.mScreenCapture.setSecondMirrorView((View)((CaptureBridge)CaptureBridge.this).mPlayInfo.secondMirrorView);
                    }
                });
            }
            if (CaptureBridge.this.mCaptureDispatcher != null) {
                CaptureBridge.this.mCaptureDispatcher.onCaptureStart(n2);
                return;
            }
            for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).onCaptureStart(n2);
            }
        }

        @Override
        public void onInfo(int n2, String string) {
            if (CaptureBridge.this.mCaptureDispatcher != null) {
                CaptureBridge.this.mCaptureDispatcher.onCaptureInfo(n2, string);
                return;
            }
            for (int i2 = 0; i2 < CaptureBridge.this.mAbsBridges.size(); ++i2) {
                ((AbsBridge)CaptureBridge.this.mAbsBridges.valueAt(i2)).onInfo(n2, string);
            }
        }
    };

    public static synchronized CaptureBridge getInstance() {
        if (mCaptureController == null) {
            mCaptureController = new CaptureBridge();
        }
        return mCaptureController;
    }

    public void removeAbsBridge(int n2) {
        this.mAbsBridges.remove(n2);
    }

    public void setAbsBridges(int n2, AbsBridge absBridge) {
        this.mAbsBridges.put(n2, (Object)absBridge);
    }

    public synchronized void init() {
        try {
            if (this.isInitialize) {
                return;
            }
            this.mAbsBridges.clear();
            this.mModuleLinker = ModuleLinker.getInstance();
            this.mScreenCapture = (IScreenCapture)this.mModuleLinker.loadModule("611AA009C976C187CCF7D33B09C321D4");
            this.mScreenCapture.setFrameCallbackListener(this.mCaptureListener);
            this.isInitialize = true;
            SourceLog.i(TAG, " CaptureBridge init ");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public IScreenCapture getScreenCapture() {
        return this.mScreenCapture;
    }

    @Deprecated
    public void configCapture(OutParameter outParameter, int n2, int n3, int n4, int n5, String string) {
        if (this.mScreenCapture == null) {
            SourceLog.i(TAG, "configCapture ignore");
            return;
        }
        SourceLog.i(TAG, "configCapture");
        this.mPlayInfo = outParameter;
        if (outParameter.isExpandMirror) {
            this.mScreenCapture.setExpansionScreenInfo(outParameter.expandActivity, outParameter.expandView);
        } else {
            this.mScreenCapture.setExpansionScreenInfo(null, null);
        }
        this.mScreenCapture.setResolution(n2, n3, false);
        this.mScreenCapture.setFullScreenMode(CastUtil.isFullScreen(outParameter.fullScreenType, outParameter.currentBrowserInfo));
        int n6 = this.isExternalAudioSource() ? 1 : CaptureBridge.getInstance().getAudioCaptureType(this.mPlayInfo);
        this.setAudioSwitch(n6, n5, this.mPlayInfo.requestAudioFocus, false);
        this.mScreenCapture.setFrameRate(Adapter.adjustFrame(n4));
        switch (this.mPlayInfo.mirrorBitRateLevel) {
            case 4: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x700000));
                break;
            }
            case 6: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x100000));
                break;
            }
            default: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x400000));
            }
        }
        SourceLog.w(TAG, "startScreenCapture expand:" + outParameter.isExpandMirror + " audio:" + n6 + " ");
        this.mScreenCapture.setVideoEncodeType(string);
        this.mScreenCapture.startCapture(outParameter.mirrorIntent);
    }

    public synchronized void startScreenCapture(int n2, int n3, int n4, int n5, int n6, String string) {
        int n7;
        if (!this.isInitialize) {
            SourceLog.i(TAG, "startScreenCapture ignore");
            return;
        }
        if (this.mScreenCapture == null) {
            SourceLog.i(TAG, "startScreenCapture ignore 2");
            return;
        }
        SourceLog.i(TAG, "startScreenCapture");
        this.isFirstVideoFrame = true;
        ParamsMap paramsMap = ParamsMap.create();
        try {
            n7 = this.getNotificationType();
            if (n7 != 1) {
                if (Preference.getInstance().get("mirror_notification", false) || Feature.isLeboApp() || Feature.isHappyTest()) {
                    MirrorNotification mirrorNotification = new MirrorNotification();
                    Notification notification = mirrorNotification.createNotification(ModuleLinker.getInstance().getContext(), CastUtil.getSinkName(this.mPlayInfo.serviceInfo), n7);
                    if (notification != null) {
                        paramsMap.putParam("notification", notification);
                        NotificationChannel notificationChannel = mirrorNotification.createNotificationChannel(ModuleLinker.getInstance().getContext());
                        paramsMap.putParam("notification_channel", notificationChannel);
                        if (Feature.isZTEChannel()) {
                            paramsMap.putParam("notification_pid", 110);
                        }
                    }
                    paramsMap.putParam("use_default_notification", true);
                } else {
                    SourceLog.i(TAG, "startScreenCapture disable notification");
                    paramsMap.putParam("use_default_notification", Feature.isPhone360());
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (Feature.isPico()) {
            paramsMap.putParam("rotation_monitor", false);
        }
        this.mScreenCapture.init(ModuleLinker.getInstance().getContext(), paramsMap);
        if (this.mPlayInfo.isExpandMirror) {
            this.mScreenCapture.setExpansionScreenInfo(this.mPlayInfo.expandActivity, this.mPlayInfo.expandView);
        }
        this.mScreenCapture.setResolution(n3, n4, false);
        this.mScreenCapture.setFullScreenMode(CastUtil.isFullScreen(this.mPlayInfo.fullScreenType, this.mPlayInfo.currentBrowserInfo));
        n7 = this.getAudioSwitch();
        this.mScreenCapture.setAudioSwitch(n7, n2 == 4 ? 0 : 1, this.mPlayInfo.requestAudioFocus, false);
        this.mScreenCapture.setFrameRate(Adapter.adjustFrame(n5));
        this.mScreenCapture.setVideoEncodeType(string);
        this.setInitBitRate();
        if (n2 == 4) {
            this.mScreenCapture.setMirrorType(2);
            this.mScreenCapture.setFrameInterval(3000);
        } else {
            this.mScreenCapture.setMirrorType(1);
        }
        this.mScreenCapture.setBitRate(n6);
        SourceLog.w(TAG, "startScreenCapture expand:" + this.mPlayInfo.isExpandMirror + " audio:" + n7 + " isReuseDisplay " + this.isReuseDisplay);
        this.setWatermarkInfo();
        if (Feature.isPico() && Build.VERSION.SDK_INT >= 19) {
            this.mScreenCapture.setCaptureSource(3);
            this.mScreenCapture.setFrameInterval(1);
        }
        if (this.mRotation > 0) {
            this.setRotation(this.mRotation, this.isAdjust);
        }
        this.mScreenCapture.startCapture(this.mPlayInfo.mirrorIntent);
    }

    private void setInitBitRate() {
        switch (this.mPlayInfo.mirrorBitRateLevel) {
            case 4: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x700000));
                break;
            }
            case 6: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x100000));
                break;
            }
            default: {
                this.mScreenCapture.setBitRate(Adapter.adjustBitRate(0x400000));
            }
        }
    }

    private void setWatermarkInfo() {
        boolean bl = Preference.getInstance().get("mirror_watermark_switch", false);
        this.setWatermarkVisible(bl);
        if (!bl) {
            return;
        }
        String string = Preference.getInstance().get("mirror_watermark_obj_json_str", null);
        SourceLog.i(TAG, "setWatermarkInfo watermarkInfoStr:" + string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "setWatermarkInfo is null return");
            return;
        }
        WatermarkBean watermarkBean = WatermarkBean.formJson(string);
        float f2 = watermarkBean.xPositionRatio;
        float f3 = watermarkBean.yPositionRatio;
        String string2 = watermarkBean.sourcePath;
        int n2 = watermarkBean.sourceId;
        SourceLog.i(TAG, "setWatermarkInfo xPositionRatio:" + f2 + ", yPositionRatio:" + f3 + ", sourceId:" + n2 + ", path:" + string2);
        Bitmap bitmap = null;
        Rect rect = new Rect();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bitmap = BitmapUtils.getBitmapByPath(ModuleLinker.getInstance().getContext(), rect, string2);
        }
        if (bitmap == null && n2 > 0) {
            bitmap = BitmapUtils.getBitmapById(ModuleLinker.getInstance().getContext(), rect, n2);
        }
        if (bitmap == null) {
            SourceLog.w(TAG, "setWatermarkInfo can not get the bitmap");
        }
        if (f2 < 0.0f || f3 < 0.0f) {
            f2 = 0.0f;
            f3 = 0.0f;
        }
        this.setWatermarkInfo(bitmap, rect, f2 < 0.0f ? 0.0f : f2, f3 < 0.0f ? 0.0f : f3, 0);
    }

    public void setWatermarkInfo(Bitmap bitmap, Rect rect, float f2, float f3, int n2) {
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setWatermarkInfo(bitmap, rect, f2, f3, 0);
    }

    public void setWatermarkVisible(boolean bl) {
        SourceLog.i(TAG, "setWatermarkVisible visible:" + bl);
        if (this.mScreenCapture == null) {
            return;
        }
        if (bl) {
            this.mScreenCapture.watermarkVisible();
            return;
        }
        this.mScreenCapture.watermarkInvisible();
    }

    private int getNotificationType() {
        int n2 = Preference.getInstance().get("mirror_notify_type", -1);
        if (n2 >= 0) {
            return n2;
        }
        return Preference.getInstance().get("mirror_notification", true) ? 0 : 1;
    }

    public void setPlayInfo(OutParameter outParameter) {
        this.mPlayInfo = outParameter;
    }

    public void setExpansionScreenInfo(Activity activity, View view) {
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setExpansionScreenInfo(activity, view);
    }

    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        if (this.mScreenCapture == null) {
            return;
        }
        SourceLog.w(TAG, "setSecondMirrorView " + (Object)((Object)secondMirrorView));
        this.mScreenCapture.setSecondMirrorView((View)secondMirrorView);
    }

    public void setSampleRate(int n2) {
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setSampleRate(n2);
    }

    public void switchExpansionScreen(boolean bl) {
        if (this.mScreenCapture == null) {
            return;
        }
        SourceLog.w(TAG, "switchExpansionScreen " + bl);
        this.mScreenCapture.switchExpansionScreen(bl);
    }

    public void resetEncoder() {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "resetEncoder ignore");
            return;
        }
        SourceLog.i(TAG, "resetEncoder");
        this.mScreenCapture.resetEncoder();
    }

    public void requestKeyFrame() {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "requestKeyFrame ignore");
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.mScreenCapture.requestKeyFrame();
        } else {
            this.mScreenCapture.resetEncoder();
        }
    }

    public synchronized boolean stopCapture(int n2) {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "stopCapture ignore" + n2);
            return false;
        }
        SourceLog.i(TAG, "stopCapture " + n2);
        return this.mScreenCapture.stopCapture();
    }

    public boolean isRunning() {
        if (this.mScreenCapture == null) {
            return false;
        }
        return this.mScreenCapture.isRunning();
    }

    public void updatePCMData(int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.updatePCMData(n2, n3, n4, byArray, n5, n6);
    }

    public synchronized void resetCaptureEncoder(int n2, int n3, int n4, int n5, int n6, String string) {
        if (!this.isInitialize) {
            SourceLog.i(TAG, "resetCaptureEncoder ignore");
            return;
        }
        if (this.mScreenCapture == null) {
            SourceLog.i(TAG, " resetCaptureEncoder ignore 2");
            return;
        }
        SourceLog.i(TAG, " resetCaptureEncoder ");
        this.mScreenCapture.setResolution(n3, n4, false);
        this.mScreenCapture.setFullScreenMode(CastUtil.isFullScreen(this.mPlayInfo.fullScreenType, this.mPlayInfo.currentBrowserInfo));
        if (n2 == 4) {
            this.mScreenCapture.setMirrorType(2);
            this.mScreenCapture.setFrameInterval(3000);
            this.mScreenCapture.setFrameRate(30);
        } else {
            this.mScreenCapture.setMirrorType(1);
            this.setInitBitRate();
        }
        this.mScreenCapture.setAudioSwitch(this.getAudioSwitch(), n2 == 4 ? 0 : 1, this.mPlayInfo.requestAudioFocus, false);
        this.mScreenCapture.setFrameRate(Adapter.adjustFrame(n5));
        this.mScreenCapture.setVideoEncodeType(string);
        this.mScreenCapture.setBitRate(n6);
        this.mScreenCapture.resetEncoder();
    }

    private boolean isExternalAudioSource() {
        return OptionCentral.isEnableExternalAudio();
    }

    public int getAudioSwitch() {
        int n2 = 0;
        n2 = this.isExternalAudioSource() ? 1 : CaptureBridge.getInstance().getAudioCaptureType(this.mPlayInfo);
        SourceLog.i(TAG, "getAudioSwitch " + n2);
        return n2;
    }

    public void setAudioSwitch(int n2, int n3, boolean bl, boolean bl2) {
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setAudioSwitch(n2, n3, bl, bl2);
    }

    public void onError(int n2, int n3) {
        SourceLog.w(TAG, "Mirror onError " + n2 + " errorCode " + n3);
    }

    public void onSinkPrepared(int n2, AbsBridge absBridge, int n3, int n4, int n5, int n6, String string) {
        SourceLog.i(TAG, "onSinkPrepared Mirror sinkWidth:" + n3 + "  sinkHeight:" + n4 + "  sinkFrameRate:" + n5);
        if (this.mCaptureDispatcher != null) {
            this.mCaptureDispatcher.onSinkPrepared(n2, absBridge, n3, n4, n5, n6, string);
            return;
        }
        this.setAbsBridges(n2, absBridge);
        this.startScreenCapture(n2, n3, n4, n5, n6, string);
    }

    public boolean onNetworkPoor() {
        SourceLog.i(TAG, "onNetworkPoor");
        if (this.mCaptureDispatcher != null) {
            this.mCaptureDispatcher.onNetworkPoor();
            return true;
        }
        return false;
    }

    public boolean isGroupMirror() {
        return this.mCaptureDispatcher != null;
    }

    public void pauseEncode(boolean bl) {
        if (this.mScreenCapture == null) {
            SourceLog.i(TAG, "pauseEncode ignore");
            return;
        }
        SourceLog.i(TAG, "pauseEncode ");
        this.mScreenCapture.pauseEncoder(bl);
    }

    public void resumeEncode() {
        if (this.mScreenCapture == null) {
            SourceLog.i(TAG, "resumeEncode ignore");
            return;
        }
        SourceLog.i(TAG, "resumeEncode ");
        this.mScreenCapture.resumeEncoder();
    }

    public void onBroken(int n2) {
        SourceLog.i(TAG, "onBroken " + (this.mCaptureDispatcher == null));
        if (this.mCaptureDispatcher != null) {
            this.mCaptureDispatcher.onBroken(n2);
            return;
        }
        SourceLog.i(TAG, "onBroken call stopCapture");
        if (this.mScreenCapture != null) {
            this.mScreenCapture.stopCapture();
        }
    }

    public void setBitRate(int n2, int n3) {
        this.mBitRate = n3;
        if (this.mScreenCapture != null) {
            this.mScreenCapture.setBitRate(n3);
        }
    }

    public int getBitrate() {
        return this.mBitRate;
    }

    public void setResolution(int n2, int n3, int n4) {
        SourceLog.i(TAG, "onResolutionCallback " + n3 + "/" + n4);
        if (this.mScreenCapture != null) {
            this.mScreenCapture.setResolution(n3, n4, false);
        }
    }

    public void setFrameRate(int n2, int n3) {
        if (this.mScreenCapture != null) {
            this.mScreenCapture.setFrameRate(Adapter.adjustFrame(n3));
        }
    }

    public void setMirrorMode(String string) {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "setMirrorMode ignore");
            return;
        }
        SourceLog.i(TAG, "setMirrorMode " + string);
        this.mScreenCapture.setMirrorMode(string);
    }

    public void resize(int n2) {
        this.mScreenCapture.resize(n2);
        this.setDisplayReuse(false);
    }

    public void setDisplayReuse(boolean bl) {
        this.isReuseDisplay = bl;
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "setDisplayReuse ignore");
            return;
        }
        SourceLog.i(TAG, "setDisplayReuse " + bl);
        this.mScreenCapture.disPlayReuse(bl);
    }

    public int getAudioCaptureType(OutParameter outParameter) {
        switch (outParameter.mirrorAudioType) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 2: {
                if (Build.VERSION.SDK_INT < 29) break;
                return 3;
            }
        }
        return 2;
    }

    public void setMirrorScreenSecret(boolean bl) {
        SourceLog.i(TAG, "setMirrorScreenSecret status:" + bl);
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "setMirrorScreenSecret ignore");
            return;
        }
        if (!bl) {
            SourceLog.i(TAG, "showMirrorScreen ");
            this.mScreenCapture.showMirrorScreen();
            return;
        }
        int n2 = ScreenUtil.getScreenWidth(ModuleLinker.getInstance().getContext());
        int n3 = ScreenUtil.getScreenHeight(ModuleLinker.getInstance().getContext());
        SourceLog.i(TAG, "hideMirrorScreen w:" + n2 + ", h:" + n3);
        Bitmap bitmap = BitmapUtils.getNullBitmap(Math.min(n2, n3), Math.max(n2, n3));
        Bitmap bitmap2 = BitmapUtils.getNullBitmap(Math.max(n2, n3), Math.min(n2, n3));
        this.mScreenCapture.hideMirrorScreen(bitmap2, bitmap);
    }

    public synchronized void release(int n2) {
        SourceLog.i(TAG, "release " + n2);
        this.isInitialize = false;
        this.mAbsBridges.clear();
        if (this.mScreenCapture != null) {
            if (this.mScreenCapture.isRunning()) {
                this.mScreenCapture.stopCapture();
            }
            this.mScreenCapture.setFrameCallbackListener(null);
            this.mScreenCapture = null;
        }
        if (this.mModuleLinker != null) {
            this.mModuleLinker.removeObjOfMemory("611AA009C976C187CCF7D33B09C321D4");
            this.mModuleLinker = null;
        }
    }

    public void setICaptureDispatcher(ICaptureDispatcher iCaptureDispatcher) {
        SourceLog.i(TAG, " ++++++++++ setICaptureDispatcher : " + (iCaptureDispatcher == null));
        this.mCaptureDispatcher = iCaptureDispatcher;
    }

    public void setRotation(int n2, boolean bl) {
        this.mRotation = n2;
        this.isAdjust = bl;
        if (this.mScreenCapture != null) {
            this.mScreenCapture.setRotation(n2, bl);
        }
    }

    public VirtualDisplay getVirtualDisplay() {
        if (this.mScreenCapture != null) {
            return this.mScreenCapture.getVirtualDisplay();
        }
        return null;
    }

    public static interface ICaptureDispatcher {
        public void onSinkPrepared(int var1, AbsBridge var2, int var3, int var4, int var5, int var6, String var7);

        public boolean onNetworkPoor();

        public void onBroken(int var1);

        public void onVideoDataCallback(ByteBuffer var1, int var2, int var3, int var4, long var5);

        public void onAudioDataCallback(byte[] var1, int var2, int var3, int var4);

        public void onCaptureScreenshot(int var1);

        public void onCaptureStop(int var1);

        public void onCaptureStart(int var1);

        public void onCaptureInfo(int var1, String var2);
    }
}

