/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.os.Parcelable;
import android.util.Log;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import java.util.List;

public class PushFailedRetryManager {
    private static final String TAG = "PushFailedRetryManager";
    public static volatile PushFailedRetryManager mPlayFailedRetryManager;
    private BrowserInfo mBrowseInfo;
    private int type = 0;
    private PlayRetryListener mPlayRetryListener;
    private ConnectRetryListener mConnectRetryListener;
    private LelinkServiceInfo mServiceInfo;
    IBrowseListener iBrowseListener = new IBrowseListener(){

        @Override
        public void onBrowse(int n2, List<LelinkServiceInfo> list) {
            try {
                if (list.size() > 0) {
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        Parcelable parcelable;
                        if (PushFailedRetryManager.this.mPlayRetryListener != null && (parcelable = list.get(i2).getBrowserInfos().get(PushFailedRetryManager.this.type)) != null && (parcelable.getName().equals(PushFailedRetryManager.this.mBrowseInfo.getName()) || parcelable.getIp().equals(PushFailedRetryManager.this.mBrowseInfo.getIp()))) {
                            SourceLog.i(PushFailedRetryManager.TAG, "replay get device callback to player ");
                            PushFailedRetryManager.this.mPlayRetryListener.onBrowseInfoCallback(list.get(i2), (BrowserInfo)parcelable);
                            PushFailedRetryManager.this.mPlayRetryListener = null;
                        }
                        if (PushFailedRetryManager.this.mConnectRetryListener == null) continue;
                        parcelable = list.get(i2);
                        SourceLog.i(PushFailedRetryManager.TAG, "get retry devs  " + parcelable.getName());
                        if (!parcelable.getName().equals(PushFailedRetryManager.this.mServiceInfo.getName()) && !parcelable.getIp().equals(PushFailedRetryManager.this.mServiceInfo.getIp())) continue;
                        SourceLog.i(PushFailedRetryManager.TAG, "reconnect get device callback to controller");
                        PushFailedRetryManager.this.mConnectRetryListener.onLelinkServiceInfoCallback(PushFailedRetryManager.this.mServiceInfo);
                        PushFailedRetryManager.this.mConnectRetryListener = null;
                    }
                }
            }
            catch (Exception exception) {
                Log.w((String)PushFailedRetryManager.TAG, (Throwable)exception);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushFailedRetryManager getInstance() {
        if (mPlayFailedRetryManager != null) return mPlayFailedRetryManager;
        Class<PushFailedRetryManager> clazz = PushFailedRetryManager.class;
        synchronized (PushFailedRetryManager.class) {
            mPlayFailedRetryManager = new PushFailedRetryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mPlayFailedRetryManager;
        }
    }

    public void connectFailedRetry(LelinkServiceInfo lelinkServiceInfo, ConnectRetryListener connectRetryListener) {
        SourceLog.i(TAG, "connectFailedRetry ... ");
        this.mServiceInfo = lelinkServiceInfo;
        this.mConnectRetryListener = connectRetryListener;
        LelinkSdkManager.getInstance().setRetryBrowseListener(this.iBrowseListener);
        LelinkSdkManager.getInstance().stopBrowse();
        LelinkSdkManager.getInstance().browse(LelinkSdkManager.getInstance().getBrowserConfig());
    }

    public void stopRetry() {
        this.mPlayRetryListener = null;
        this.mConnectRetryListener = null;
        LelinkSdkManager.getInstance().stopBrowse();
    }

    public static interface ConnectRetryListener {
        public void onLelinkServiceInfoCallback(LelinkServiceInfo var1);
    }

    public static interface PlayRetryListener {
        public void onBrowseInfoCallback(LelinkServiceInfo var1, BrowserInfo var2);
    }
}

