/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ResolverConfig {
    private static final String TAG = "ResolverConfig";
    private String[] servers = null;
    private Name[] searchlist = null;
    private int ndots = -1;
    private static ResolverConfig currentConfig;

    public ResolverConfig() {
        this.findAndroid();
    }

    private void addServer(String string, List list) {
        if (!list.contains(string)) {
            if (Options.check("verbose")) {
                System.out.println("adding server " + string);
            }
            list.add(string);
        }
    }

    private void addSearch(String string, List list) {
        Name name;
        if (Options.check("verbose")) {
            System.out.println("adding search " + string);
        }
        try {
            name = Name.fromString(string, Name.root);
        }
        catch (Exception exception) {
            return;
        }
        if (!list.contains(name)) {
            list.add(name);
        }
    }

    private void configureFromLists(List list, List list2) {
        if (this.servers == null && list.size() > 0) {
            this.servers = list.toArray(new String[0]);
        }
        if (this.searchlist == null && list2.size() > 0) {
            this.searchlist = list2.toArray(new Name[0]);
        }
    }

    private void configureNdots(int n2) {
        if (this.ndots < 0 && n2 > 0) {
            this.ndots = n2;
        }
    }

    private boolean findProperty() {
        StringTokenizer stringTokenizer;
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList(0);
        String string = System.getProperty("dns.server");
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addServer(stringTokenizer.nextToken(), arrayList);
            }
        }
        if ((string = System.getProperty("dns.search")) != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addSearch(stringTokenizer.nextToken(), arrayList2);
            }
        }
        this.configureFromLists(arrayList, arrayList2);
        return this.servers != null && this.searchlist != null;
    }

    private void findAndroid() {
        String string = "^\\d+(\\.\\d+){3}$";
        String string2 = "^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class);
            String[] stringArray = new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object[] objectArray = new Object[]{stringArray[i2]};
                String string3 = (String)method.invoke(null, objectArray);
                if (string3 == null || !string3.matches("^\\d+(\\.\\d+){3}$") && !string3.matches("^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$") || arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("config + " + exception.toString()));
        }
        this.configureFromLists(arrayList, arrayList2);
    }

    public String[] servers() {
        return this.servers;
    }

    public String server() {
        return this.servers == null ? null : this.servers[0];
    }

    public Name[] searchPath() {
        return this.searchlist;
    }

    public int ndots() {
        return this.ndots < 0 ? 1 : this.ndots;
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig resolverConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = resolverConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        ResolverConfig.refresh();
    }
}

