/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.CNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.DNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Master;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SOARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.SetResponse;
import com.hpplay.sdk.source.mdns.xbill.dns.SingleNameBase;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cache {
    private CacheMap data;
    private int maxncache = -1;
    private int maxcache = -1;
    private int dclass;
    private static final int defaultMaxEntries = 50000;

    private static int limitExpire(long l2, long l3) {
        long l4;
        if (l3 >= 0L && l3 < l2) {
            l2 = l3;
        }
        if ((l4 = System.currentTimeMillis() / 1000L + l2) < 0L || l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }

    public Cache(int n2) {
        this.dclass = n2;
        this.data = new CacheMap(50000);
    }

    public Cache() {
        this(1);
    }

    public Cache(String string) {
        Record record;
        this.data = new CacheMap(50000);
        Master master = new Master(string);
        while ((record = master.nextRecord()) != null) {
            this.addRecord(record, 0, master);
        }
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized void removeName(Name name) {
        this.data.remove(name);
    }

    private synchronized Element[] allElements(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            int n2 = list.size();
            return list.toArray(new Element[n2]);
        }
        Element element = (Element)object;
        return new Element[]{element};
    }

    private synchronized Element oneElement(Name name, Object object, int n2, int n3) {
        Element element = null;
        if (n2 == 255) {
            throw new IllegalArgumentException("oneElement(ANY)");
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Element element2 = (Element)list.get(i2);
                if (element2.getType() != n2) continue;
                element = element2;
                break;
            }
        } else {
            Element element3 = (Element)object;
            if (element3.getType() == n2) {
                element = element3;
            }
        }
        if (element == null) {
            return null;
        }
        if (element.expired()) {
            this.removeElement(name, n2);
            return null;
        }
        if (element.compareCredibility(n3) < 0) {
            return null;
        }
        return element;
    }

    private synchronized Element findElement(Name name, int n2, int n3) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneElement(name, object, n2, n3);
    }

    private synchronized void addElement(Name name, Element element) {
        Object v2 = this.data.get(name);
        if (v2 == null) {
            this.data.put(name, element);
            return;
        }
        int n2 = element.getType();
        if (v2 instanceof List) {
            List list = (List)v2;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Element element2 = (Element)list.get(i2);
                if (element2.getType() != n2) continue;
                list.set(i2, element);
                return;
            }
            list.add(element);
        } else {
            Element element3 = (Element)v2;
            if (element3.getType() == n2) {
                this.data.put(name, element);
            } else {
                LinkedList<Element> linkedList = new LinkedList<Element>();
                linkedList.add(element3);
                linkedList.add(element);
                this.data.put(name, linkedList);
            }
        }
    }

    private synchronized void removeElement(Name name, int n2) {
        Object v2 = this.data.get(name);
        if (v2 == null) {
            return;
        }
        if (v2 instanceof List) {
            List list = (List)v2;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Element element = (Element)list.get(i2);
                if (element.getType() != n2) continue;
                list.remove(i2);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            Element element = (Element)v2;
            if (element.getType() != n2) {
                return;
            }
            this.data.remove(name);
        }
    }

    public synchronized void clearCache() {
        this.data.clear();
    }

    public synchronized void addRecord(Record record, int n2, Object object) {
        Name name = record.getName();
        int n3 = record.getRRsetType();
        if (!Type.isRR(n3)) {
            return;
        }
        Element element = this.findElement(name, n3, n2);
        if (element == null) {
            CacheRRset cacheRRset = new CacheRRset(record, n2, (long)this.maxcache);
            this.addRRset(cacheRRset, n2);
        } else if (element.compareCredibility(n2) == 0 && element instanceof CacheRRset) {
            CacheRRset cacheRRset = (CacheRRset)element;
            cacheRRset.addRR(record);
        }
    }

    public synchronized void addRRset(RRset rRset, int n2) {
        long l2 = rRset.getTTL();
        Name name = rRset.getName();
        int n3 = rRset.getType();
        Element element = this.findElement(name, n3, 0);
        if (l2 == 0L) {
            if (element != null && element.compareCredibility(n2) <= 0) {
                this.removeElement(name, n3);
            }
        } else {
            if (element != null && element.compareCredibility(n2) <= 0) {
                element = null;
            }
            if (element == null) {
                CacheRRset cacheRRset = rRset instanceof CacheRRset ? (CacheRRset)rRset : new CacheRRset(rRset, n2, (long)this.maxcache);
                this.addElement(name, cacheRRset);
            }
        }
    }

    public synchronized void addNegative(Name name, int n2, SOARecord sOARecord, int n3) {
        long l2 = 0L;
        if (sOARecord != null) {
            l2 = sOARecord.getTTL();
        }
        Element element = this.findElement(name, n2, 0);
        if (l2 == 0L) {
            if (element != null && element.compareCredibility(n3) <= 0) {
                this.removeElement(name, n2);
            }
        } else {
            if (element != null && element.compareCredibility(n3) <= 0) {
                element = null;
            }
            if (element == null) {
                this.addElement(name, new NegativeElement(name, n2, sOARecord, n3, this.maxncache));
            }
        }
    }

    protected synchronized SetResponse lookup(Name name, int n2, int n3) {
        int n4;
        for (int i2 = n4 = name.labels(); i2 >= 1; --i2) {
            Element element;
            SetResponse setResponse;
            boolean bl;
            boolean bl2 = i2 == 1;
            boolean bl3 = bl = i2 == n4;
            Name name2 = bl2 ? Name.root : (bl ? name : new Name(name, n4 - i2));
            Object v2 = this.data.get(name2);
            if (v2 == null) continue;
            if (bl && n2 == 255) {
                setResponse = new SetResponse(6);
                Element[] elementArray = this.allElements(v2);
                int n5 = 0;
                for (int i3 = 0; i3 < elementArray.length; ++i3) {
                    element = elementArray[i3];
                    if (element.expired()) {
                        this.removeElement(name2, element.getType());
                        continue;
                    }
                    if (!(element instanceof CacheRRset) || element.compareCredibility(n3) < 0) continue;
                    setResponse.addRRset((CacheRRset)element);
                    ++n5;
                }
                if (n5 > 0) {
                    return setResponse;
                }
            } else if (bl) {
                element = this.oneElement(name2, v2, n2, n3);
                if (element != null && element instanceof CacheRRset) {
                    setResponse = new SetResponse(6);
                    setResponse.addRRset((CacheRRset)element);
                    return setResponse;
                }
                if (element != null) {
                    setResponse = new SetResponse(2);
                    return setResponse;
                }
                element = this.oneElement(name2, v2, 5, n3);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(4, (CacheRRset)element);
                }
            } else {
                element = this.oneElement(name2, v2, 39, n3);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(5, (CacheRRset)element);
                }
            }
            if ((element = this.oneElement(name2, v2, 2, n3)) != null && element instanceof CacheRRset) {
                return new SetResponse(3, (CacheRRset)element);
            }
            if (!bl || (element = this.oneElement(name2, v2, 0, n3)) == null) continue;
            return SetResponse.ofType(1);
        }
        return SetResponse.ofType(0);
    }

    public SetResponse lookupRecords(Name name, int n2, int n3) {
        return this.lookup(name, n2, n3);
    }

    private RRset[] findRecords(Name name, int n2, int n3) {
        SetResponse setResponse = this.lookupRecords(name, n2, n3);
        if (setResponse.isSuccessful()) {
            return setResponse.answers();
        }
        return null;
    }

    private final int getCred(int n2, boolean bl) {
        if (n2 == 1) {
            return !bl ? 3 : 4;
        }
        if (n2 == 2) {
            return !bl ? 3 : 4;
        }
        if (n2 == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rRset, Set set) {
        Record record = rRset.first();
        if (record.getAdditionalName() == null) {
            return;
        }
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            Record record2 = (Record)iterator.next();
            Name name = record2.getAdditionalName();
            if (name == null) continue;
            set.add(name);
        }
    }

    public SetResponse addMessage(Message message) {
        int n2;
        Serializable serializable;
        boolean bl = message.getHeader().getFlag(5);
        Record record = message.getQuestion();
        int n3 = message.getHeader().getRcode();
        boolean bl2 = false;
        SetResponse setResponse = null;
        boolean bl3 = Options.check("verbosecache");
        if (n3 != 0 && n3 != 3 || record == null) {
            return null;
        }
        Name name = record.getName();
        int n4 = record.getType();
        int n5 = record.getDClass();
        Name name2 = name;
        HashSet hashSet = new HashSet();
        RRset[] rRsetArray = message.getSectionRRsets(1);
        for (int i2 = 0; i2 < rRsetArray.length; ++i2) {
            SingleNameBase singleNameBase;
            if (rRsetArray[i2].getDClass() != n5) continue;
            int n6 = rRsetArray[i2].getType();
            serializable = rRsetArray[i2].getName();
            n2 = this.getCred(1, bl);
            if ((n6 == n4 || n4 == 255) && serializable.equals(name2)) {
                this.addRRset(rRsetArray[i2], n2);
                bl2 = true;
                if (name2 == name) {
                    if (setResponse == null) {
                        setResponse = new SetResponse(6);
                    }
                    setResponse.addRRset(rRsetArray[i2]);
                }
                Cache.markAdditional(rRsetArray[i2], hashSet);
                continue;
            }
            if (n6 == 5 && serializable.equals(name2)) {
                this.addRRset(rRsetArray[i2], n2);
                if (name2 == name) {
                    setResponse = new SetResponse(4, rRsetArray[i2]);
                }
                singleNameBase = (CNAMERecord)rRsetArray[i2].first();
                name2 = singleNameBase.getTarget();
                continue;
            }
            if (n6 != 39 || !name2.subdomain((Name)serializable)) continue;
            this.addRRset(rRsetArray[i2], n2);
            if (name2 == name) {
                setResponse = new SetResponse(5, rRsetArray[i2]);
            }
            singleNameBase = (DNAMERecord)rRsetArray[i2].first();
            try {
                name2 = name2.fromDNAME((DNAMERecord)singleNameBase);
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        RRset[] rRsetArray2 = message.getSectionRRsets(2);
        RRset rRset = null;
        serializable = null;
        for (n2 = 0; n2 < rRsetArray2.length; ++n2) {
            if (rRsetArray2[n2].getType() == 6 && name2.subdomain(rRsetArray2[n2].getName())) {
                rRset = rRsetArray2[n2];
                continue;
            }
            if (rRsetArray2[n2].getType() != 2 || !name2.subdomain(rRsetArray2[n2].getName())) continue;
            serializable = rRsetArray2[n2];
        }
        if (!bl2) {
            int n7;
            int n8 = n2 = n3 != 3 ? n4 : 0;
            if (n3 == 3 || rRset != null || serializable == null) {
                n7 = this.getCred(2, bl);
                SOARecord sOARecord = null;
                if (rRset != null) {
                    sOARecord = (SOARecord)rRset.first();
                }
                this.addNegative(name2, n2, sOARecord, n7);
                if (setResponse == null) {
                    int n9 = n3 == 3 ? 1 : 2;
                    setResponse = SetResponse.ofType(n9);
                }
            } else {
                n7 = this.getCred(2, bl);
                this.addRRset((RRset)serializable, n7);
                Cache.markAdditional((RRset)serializable, hashSet);
                if (setResponse == null) {
                    setResponse = new SetResponse(3, (RRset)serializable);
                }
            }
        } else if (n3 == 0 && serializable != null) {
            n2 = this.getCred(2, bl);
            this.addRRset((RRset)serializable, n2);
            Cache.markAdditional((RRset)serializable, hashSet);
        }
        RRset[] rRsetArray3 = message.getSectionRRsets(3);
        for (int i3 = 0; i3 < rRsetArray3.length; ++i3) {
            Name name3;
            int n10 = rRsetArray3[i3].getType();
            if (n10 != 1 && n10 != 28 && n10 != 38 || !hashSet.contains(name3 = rRsetArray3[i3].getName())) continue;
            int n11 = this.getCred(3, bl);
            this.addRRset(rRsetArray3[i3], n11);
        }
        if (bl3) {
            System.out.println("addMessage: " + setResponse);
        }
        return setResponse;
    }

    public int getMaxCache() {
        return this.maxcache;
    }

    public int getSize() {
        return this.data.size();
    }

    public int getDClass() {
        return this.dclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Cache cache = this;
        synchronized (cache) {
            Iterator iterator = this.data.values().iterator();
            while (iterator.hasNext()) {
                Element[] elementArray = this.allElements(iterator.next());
                for (int i2 = 0; i2 < elementArray.length; ++i2) {
                    stringBuffer.append(elementArray[i2]);
                    stringBuffer.append("\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    public void release() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    private static interface Element {
        public boolean expired();

        public int compareCredibility(int var1);

        public int getType();
    }

    private class CacheRRset
    extends RRset
    implements Element {
        private static final long serialVersionUID = 5971755205903597024L;
        int credibility;
        int expire;

        @Override
        public final boolean expired() {
            int n2 = (int)(System.currentTimeMillis() / 1000L);
            return n2 >= this.expire;
        }

        @Override
        public final int compareCredibility(int n2) {
            return this.credibility - n2;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" cl = ");
            stringBuffer.append(this.credibility);
            return stringBuffer.toString();
        }

        public CacheRRset(Record record, int n2, long l2) {
            this.credibility = n2;
            this.expire = Cache.limitExpire(record.getTTL(), l2);
            this.addRR(record);
        }

        public CacheRRset(RRset rRset, int n2, long l2) {
            super(rRset);
            this.credibility = n2;
            this.expire = Cache.limitExpire(rRset.getTTL(), l2);
        }
    }

    private static class NegativeElement
    implements Element {
        int type;
        Name name;
        int credibility;
        int expire;

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public final boolean expired() {
            int n2 = (int)(System.currentTimeMillis() / 1000L);
            return n2 >= this.expire;
        }

        @Override
        public final int compareCredibility(int n2) {
            return this.credibility - n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.type == 0) {
                stringBuffer.append("NXDOMAIN " + this.name);
            } else {
                stringBuffer.append("NXRRSET " + this.name + " " + Type.string(this.type));
            }
            stringBuffer.append(" cl = ");
            stringBuffer.append(this.credibility);
            return stringBuffer.toString();
        }

        public NegativeElement(Name name, int n2, SOARecord sOARecord, int n3, long l2) {
            this.name = name;
            this.type = n2;
            long l3 = 0L;
            if (sOARecord != null) {
                l3 = sOARecord.getMinimum();
            }
            this.credibility = n3;
            this.expire = Cache.limitExpire(l3, l2);
        }
    }

    private static class CacheMap
    extends LinkedHashMap {
        private int maxsize = -1;

        int getMaxSize() {
            return this.maxsize;
        }

        void setMaxSize(int n2) {
            this.maxsize = n2;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.maxsize >= 0 && this.size() > this.maxsize;
        }

        CacheMap(int n2) {
            super(16, 0.75f, true);
            this.maxsize = n2;
        }
    }
}

