/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.browse.data;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.sdk.source.bean.StrategyBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class LelinkServiceInfoCreator {
    private static final String TAG = "LelinkServiceInfoCreator";
    private static final int BASE_PORT = 52244;
    private static final String IP_PREFIX_REGEX = "(?<!\\d)\\d{1,3}\\.\\d{1,3}(?=\\.\\d)";

    public static LelinkServiceInfo getLelinkTxtInfo(String string, String string2, String string3, String string4, String string5, String string6, int n2) {
        try {
            JSONObject jSONObject = new JSONObject(string6);
            JSONObject jSONObject2 = jSONObject.optJSONObject("leLinkTxt");
            if (null == jSONObject2 || jSONObject2.length() <= 0) {
                SourceLog.i(TAG, "getLelinkTxtInfo lelinkTxt is empty");
                return null;
            }
            BrowserInfo browserInfo = new BrowserInfo(1, n2);
            browserInfo.setUid(string);
            browserInfo.setName(string2);
            browserInfo.setIp(string3);
            browserInfo.setLocalWifi(true);
            browserInfo.setOnLine(true);
            browserInfo.setPort(HapplayUtils.parsePort(string4));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                String string8 = jSONObject2.optString(string7);
                hashMap.put(string7, string8);
            }
            hashMap.put("pt", string5);
            hashMap.put("htv", "1");
            browserInfo.setExtras(hashMap);
            return new LelinkServiceInfo(2, browserInfo);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static LelinkServiceInfo getQRCodeInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("qrUrl can't not be empty");
        }
        Map<String, String> map = LelinkServiceInfoCreator.getUrlParams(string);
        if (map == null || map.isEmpty()) {
            SourceLog.i(TAG, "getQRCodeInfo param is empty");
            return null;
        }
        String string2 = map.get("ip");
        String string3 = map.get("remotePort");
        String string4 = map.get("cname");
        String string5 = map.get("deviceName");
        BrowserInfo browserInfo = new BrowserInfo(4, 2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        browserInfo.setUid(string4);
        browserInfo.setName(string5);
        browserInfo.setIp(string2);
        browserInfo.setPort(HapplayUtils.parsePort(string3));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        browserInfo.setExtras(hashMap);
        return new LelinkServiceInfo(2, browserInfo);
    }

    public static LelinkServiceInfo createIMServiceByUID(String string, String string2, String string3, String string4, String string5, int n2) {
        try {
            int n3 = 4;
            BrowserInfo browserInfo = new BrowserInfo(n3, n2);
            browserInfo.setUid(string2);
            browserInfo.setOnLine(true);
            browserInfo.setName(string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("u", string2);
            hashMap.put("pt", string4);
            hashMap.put("a", string);
            hashMap.put("vv", "2");
            hashMap.put("tunnels", string5);
            browserInfo.setExtras(hashMap);
            return new LelinkServiceInfo(n2, browserInfo);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static LelinkServiceInfo createByServiceTxtInfo(JSONObject jSONObject, int n2) {
        String string = jSONObject.optString("a");
        String string2 = jSONObject.optString("uid");
        String string3 = jSONObject.optString("name");
        String string4 = jSONObject.optString(FieldUtil.getString(FieldUtil.m));
        String string5 = jSONObject.optString("ip");
        String string6 = jSONObject.optString("port");
        String string7 = jSONObject.optString("pt");
        String string8 = jSONObject.optString("vv");
        String string9 = jSONObject.optString("tunnels");
        try {
            int n3 = 4;
            BrowserInfo browserInfo = new BrowserInfo(n3, n2);
            browserInfo.setUid(string2);
            browserInfo.setName(string3);
            browserInfo.setIp(string5);
            browserInfo.setOnLine(true);
            browserInfo.setPort(HapplayUtils.parsePort(string6));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("u", string2);
            hashMap.put("pt", string7);
            hashMap.put("name", string3);
            hashMap.put("ip", string5);
            hashMap.put("port", string6);
            hashMap.put("lelinkport", string6);
            hashMap.put("airplay", string6);
            hashMap.put("raop", string6);
            hashMap.put(BrowserInfo.KEY_M, string4);
            hashMap.put("a", string);
            if (!TextUtils.isEmpty((CharSequence)string9)) {
                hashMap.put("tunnels", string9);
            }
            browserInfo.setExtras(hashMap);
            return new LelinkServiceInfo(n2, browserInfo);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static LelinkServiceInfo getLocalCacheInfo(JSONObject jSONObject) {
        return LelinkServiceInfoCreator.getCacheInfo(3, jSONObject);
    }

    private static LelinkServiceInfo getCacheInfo(int n2, JSONObject jSONObject) {
        if (null == jSONObject || jSONObject.length() <= 0) {
            return null;
        }
        String string = jSONObject.optString("u");
        String string2 = jSONObject.optString("name");
        BrowserInfo browserInfo = new BrowserInfo(4, 4);
        browserInfo.setUid(string);
        browserInfo.setName(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("u", string);
        hashMap.put("deviceName", string2);
        browserInfo.setExtras(hashMap);
        return new LelinkServiceInfo(n2, browserInfo);
    }

    public static LelinkServiceInfo getRemoteCacheInfo(JSONObject jSONObject) {
        return LelinkServiceInfoCreator.getCacheInfo(4, jSONObject);
    }

    public static LelinkServiceInfo getLocalPinCodeInfo(Context context, String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() == 9) {
            if (string.startsWith("7") || string.startsWith("8") || string.startsWith("9")) {
                Object object;
                int n2 = Integer.parseInt(string.substring(1, 4));
                int n3 = Integer.parseInt(string.substring(4, 6));
                int n4 = Integer.parseInt(string.substring(6, 8));
                int n5 = n2 * n4 + n3;
                int n6 = 52244 + Integer.parseInt(string.substring(8));
                int n7 = n5 / 256;
                int n8 = n5 % 256;
                Matcher matcher = Pattern.compile(IP_PREFIX_REGEX).matcher(DeviceUtil.getIPAddress(context));
                String string2 = null;
                if (matcher.find()) {
                    object = matcher.group();
                    string2 = String.format(Locale.getDefault(), "%s.%d.%d", object, n7, n8);
                }
                object = new BrowserInfo(1, 5);
                ((BrowserInfo)object).setIp(string2);
                ((BrowserInfo)object).setPort(n6);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ip", string2);
                hashMap.put("port", String.valueOf(n6));
                hashMap.put("airplay", String.valueOf(n6));
                hashMap.put("lelinkport", String.valueOf(n6));
                hashMap.put("raop", String.valueOf(n6));
                ((BrowserInfo)object).setExtras(hashMap);
                LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(5, (BrowserInfo)object);
                lelinkServiceInfo.setPinCode(string);
                return lelinkServiceInfo;
            }
        } else {
            SourceLog.i(TAG, "PinCode is empty or PinCode length not equlas 9");
        }
        return null;
    }

    public static LelinkServiceInfo getNetPinCodeInfo(JSONObject jSONObject, String string) {
        if (null == jSONObject || jSONObject.length() <= 0) {
            SourceLog.i(TAG, "getNetPinCodeInfo data json is empty");
            return null;
        }
        String string2 = jSONObject.optString("ip");
        String string3 = jSONObject.optString("raop_port");
        String string4 = jSONObject.optString("airplay_port");
        String string5 = jSONObject.optString("mirror_port");
        int n2 = jSONObject.optInt("link_port");
        String string6 = jSONObject.optString("agent_port");
        String string7 = jSONObject.optString("remote_port");
        String string8 = jSONObject.optString(FieldUtil.getString(FieldUtil.m));
        String string9 = jSONObject.optString("version");
        String string10 = jSONObject.optString("tmp");
        String string11 = jSONObject.optString("hostname");
        String string12 = jSONObject.optString("name");
        String string13 = jSONObject.optString("extendStr");
        String string14 = jSONObject.optString("pt");
        String string15 = jSONObject.optString("tunnels");
        BrowserInfo browserInfo = new BrowserInfo(1, 5);
        browserInfo.setName(string12);
        browserInfo.setIp(string2);
        browserInfo.setPort(n2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ip", string2);
        hashMap.put("lelinkport", String.valueOf(n2));
        hashMap.put("airplay", string4);
        hashMap.put("mirror", string5);
        hashMap.put("remote", string7);
        hashMap.put("raop", string3);
        hashMap.put("version", string9);
        hashMap.put(BrowserInfo.KEY_M, string8);
        hashMap.put("pt", string14);
        hashMap.put("tunnels", string15);
        browserInfo.setExtras(hashMap);
        LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(6, browserInfo);
        lelinkServiceInfo.setPinCode(string);
        return lelinkServiceInfo;
    }

    public static LelinkServiceInfo getConferenceInfo(JSONObject jSONObject, String string) {
        Object object;
        Object object2;
        if (null == jSONObject || jSONObject.length() <= 0) {
            SourceLog.i(TAG, "getConferenceInfo data json is empty");
            return null;
        }
        String string2 = jSONObject.optString("name");
        String string3 = jSONObject.optString("ip");
        int n2 = jSONObject.optInt("linkPort");
        String string4 = jSONObject.optString("raopPort");
        String string5 = jSONObject.optString("agentPort");
        BrowserInfo browserInfo = new BrowserInfo(1, 6);
        browserInfo.setName(string2);
        browserInfo.setIp(string3);
        browserInfo.setPort(n2);
        try {
            object2 = StrategyBean.getInstance();
            object = jSONObject.optJSONObject("testingConfig");
            int n3 = object.optInt("times");
            int n4 = object.optInt("cumulativeNumber");
            int n5 = object.optInt("delayTime");
            int n6 = object.optInt("intervalTime");
            int n7 = object.optInt("toastStatus");
            ((StrategyBean)object2).setCumulativeNumber(n4 * 1000);
            ((StrategyBean)object2).setDuration(n3 * 60 * 1000);
            ((StrategyBean)object2).setToastStatus(n7);
            ((StrategyBean)object2).setIntervalCount(n6);
            ((StrategyBean)object2).setTimeout(n5);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "", exception);
        }
        object2 = new HashMap();
        object2.put("raop", string4);
        object2.put("agentPort", string5);
        object2.put("lelinkport", String.valueOf(n2));
        object2.put("vv", "2");
        object2.put("isconference", "1");
        object = jSONObject.keys();
        while (object.hasNext()) {
            String string6 = (String)object.next();
            object2.put(string6, jSONObject.optString(string6));
        }
        browserInfo.setExtras((Map<String, String>)object2);
        LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(6, browserInfo);
        lelinkServiceInfo.setPinCode(string);
        return lelinkServiceInfo;
    }

    public static LelinkServiceInfo getConferenceFuzzyMatchingInfo(JSONObject jSONObject) {
        if (null == jSONObject || jSONObject.length() <= 0) {
            SourceLog.i(TAG, "getConferenceFuzzyMatchingInfo data json is empty");
            return null;
        }
        String string = jSONObject.optString("name");
        String string2 = jSONObject.optString("ip");
        int n2 = jSONObject.optInt("linkPort");
        String string3 = jSONObject.optString("raopPort");
        BrowserInfo browserInfo = new BrowserInfo(1, 6);
        browserInfo.setName(string);
        browserInfo.setIp(string2);
        browserInfo.setPort(n2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("raop", string3);
        hashMap.put("lelinkport", String.valueOf(n2));
        hashMap.put("vv", "2");
        hashMap.put("isconference", "1");
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            hashMap.put(string4, jSONObject.optString(string4));
        }
        browserInfo.setExtras(hashMap);
        LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(6, browserInfo);
        lelinkServiceInfo.setPinCode(jSONObject.optString("code"));
        return lelinkServiceInfo;
    }

    public static LelinkServiceInfo createNfcServiceInfo(Map<String, String> map) {
        try {
            if (map != null && map.size() > 0) {
                LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo();
                lelinkServiceInfo.setUid(map.get("cname"));
                lelinkServiceInfo.setIp(map.get("ip"));
                lelinkServiceInfo.setPort(Integer.parseInt(map.get("remotePort")));
                lelinkServiceInfo.setName(map.get("deviceName"));
                BrowserInfo browserInfo = new BrowserInfo(1, 7);
                browserInfo.setIp(map.get("ip"));
                browserInfo.setName(map.get("deviceName"));
                browserInfo.setUid(map.get("cname"));
                browserInfo.setPort(Integer.parseInt(map.get("remotePort")));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", map.get("deviceName"));
                hashMap.put("ip", map.get("ip"));
                hashMap.put("u", map.get("cname"));
                hashMap.put("lelinkport", map.get("remotePort"));
                hashMap.put("port", map.get("remotePort"));
                hashMap.put("raop", map.get("remotePort"));
                hashMap.put("airplay", map.get("remotePort"));
                hashMap.put("vv", "2");
                hashMap.put("version", "2.0");
                browserInfo.setExtras(hashMap);
                lelinkServiceInfo.updateByBrowseInfo(browserInfo);
                return lelinkServiceInfo;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception.toString());
            return null;
        }
        return null;
    }

    private static Map<String, String> getUrlParams(String string) {
        String[] stringArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }
}

