/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.net.Uri;
import android.text.TextUtils;
import com.hpplay.glide.load.model.Headers;
import java.net.URL;
import java.util.Map;

public class GlideUrl {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private final URL url;
    private final Headers headers;
    private final String stringUrl;
    private String safeStringUrl;
    private URL safeUrl;

    public GlideUrl(URL uRL) {
        this(uRL, Headers.DEFAULT);
    }

    public GlideUrl(String string) {
        this(string, Headers.DEFAULT);
    }

    public GlideUrl(URL uRL, Headers headers) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.url = uRL;
        this.stringUrl = null;
        this.headers = headers;
    }

    public GlideUrl(String string, Headers headers) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("String url must not be empty or null: " + string);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.stringUrl = string;
        this.url = null;
        this.headers = headers;
    }

    public URL toURL() {
        return this.getSafeUrl();
    }

    private URL getSafeUrl() {
        if (this.safeUrl == null) {
            this.safeUrl = new URL(this.getSafeStringUrl());
        }
        return this.safeUrl;
    }

    public String toStringUrl() {
        return this.getSafeStringUrl();
    }

    private String getSafeStringUrl() {
        if (TextUtils.isEmpty((CharSequence)this.safeStringUrl)) {
            String string = this.stringUrl;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = this.url.toString();
            }
            this.safeStringUrl = Uri.encode((String)string, (String)ALLOWED_URI_CHARS);
        }
        return this.safeStringUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers.getHeaders();
    }

    public String getCacheKey() {
        return this.stringUrl != null ? this.stringUrl : this.url.toString();
    }

    public String toString() {
        return this.getCacheKey() + '\n' + this.headers.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof GlideUrl) {
            GlideUrl glideUrl = (GlideUrl)object;
            return this.getCacheKey().equals(glideUrl.getCacheKey()) && this.headers.equals(glideUrl.headers);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.getCacheKey().hashCode();
        n2 = 31 * n2 + this.headers.hashCode();
        return n2;
    }
}

