/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.hpplay.glide.BitmapTypeRequest;
import com.hpplay.glide.DownloadOptions;
import com.hpplay.glide.DrawableRequestBuilder;
import com.hpplay.glide.GenericTranscodeRequest;
import com.hpplay.glide.GifTypeRequest;
import com.hpplay.glide.Glide;
import com.hpplay.glide.RequestManager;
import com.hpplay.glide.load.model.ImageVideoModelLoader;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.manager.Lifecycle;
import com.hpplay.glide.manager.RequestTracker;
import com.hpplay.glide.provider.DataLoadProvider;
import com.hpplay.glide.provider.FixedLoadProvider;
import com.hpplay.glide.request.FutureTarget;
import com.hpplay.glide.request.target.Target;
import java.io.File;
import java.io.InputStream;

public class DrawableTypeRequest<ModelType>
extends DrawableRequestBuilder<ModelType>
implements DownloadOptions {
    private final ModelLoader<ModelType, InputStream> streamModelLoader;
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final RequestManager.OptionsApplier optionsApplier;

    private static <A, Z, R> FixedLoadProvider<A, ImageVideoWrapper, Z, R> buildProvider(Glide glide, ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2, Class<Z> clazz, Class<R> clazz2, ResourceTranscoder<Z, R> resourceTranscoder) {
        if (modelLoader == null && modelLoader2 == null) {
            return null;
        }
        if (resourceTranscoder == null) {
            resourceTranscoder = glide.buildTranscoder(clazz, clazz2);
        }
        DataLoadProvider<ImageVideoWrapper, Z> dataLoadProvider = glide.buildDataProvider(ImageVideoWrapper.class, clazz);
        ImageVideoModelLoader<A> imageVideoModelLoader = new ImageVideoModelLoader<A>(modelLoader, modelLoader2);
        return new FixedLoadProvider(imageVideoModelLoader, resourceTranscoder, dataLoadProvider);
    }

    DrawableTypeRequest(Class<ModelType> clazz, ModelLoader<ModelType, InputStream> modelLoader, ModelLoader<ModelType, ParcelFileDescriptor> modelLoader2, Context context, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle, RequestManager.OptionsApplier optionsApplier) {
        super(context, clazz, DrawableTypeRequest.buildProvider(glide, modelLoader, modelLoader2, GifBitmapWrapper.class, GlideDrawable.class, null), glide, requestTracker, lifecycle);
        this.streamModelLoader = modelLoader;
        this.fileDescriptorModelLoader = modelLoader2;
        this.optionsApplier = optionsApplier;
    }

    public BitmapTypeRequest<ModelType> asBitmap() {
        return this.optionsApplier.apply(new BitmapTypeRequest<ModelType>(this, this.streamModelLoader, this.fileDescriptorModelLoader, this.optionsApplier));
    }

    public GifTypeRequest<ModelType> asGif() {
        return this.optionsApplier.apply(new GifTypeRequest<ModelType>(this, this.streamModelLoader, this.optionsApplier));
    }

    @Override
    public <Y extends Target<File>> Y downloadOnly(Y y) {
        return this.getDownloadOnlyRequest().downloadOnly(y);
    }

    @Override
    public FutureTarget<File> downloadOnly(int n2, int n3) {
        return this.getDownloadOnlyRequest().downloadOnly(n2, n3);
    }

    private GenericTranscodeRequest<ModelType, InputStream, File> getDownloadOnlyRequest() {
        return this.optionsApplier.apply(new GenericTranscodeRequest<ModelType, InputStream, File>(File.class, this, this.streamModelLoader, InputStream.class, File.class, this.optionsApplier));
    }
}

