/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.ssdp.HTTPUSocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchResponse;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SSDPSearchResponseSocket
extends HTTPUSocket
implements Runnable {
    private ControlPoint controlPoint = null;
    private Thread deviceSearchResponseThread = null;

    public SSDPSearchResponseSocket() {
        this.setControlPoint(null);
    }

    public SSDPSearchResponseSocket(String string, int n2) {
        super(string, n2);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        ControlPoint controlPoint = this.getControlPoint();
        while (this.deviceSearchResponseThread == thread) {
            Thread.yield();
            SSDPPacket sSDPPacket = this.receive();
            if (sSDPPacket == null) break;
            if (controlPoint == null) continue;
            controlPoint.searchResponseReceived(sSDPPacket);
        }
    }

    public void start() {
        StringBuffer stringBuffer = new StringBuffer("SSDPSearchResponseSocket/");
        DatagramSocket datagramSocket = this.getDatagramSocket();
        InetAddress inetAddress = datagramSocket.getLocalAddress();
        if (inetAddress != null) {
            stringBuffer.append(datagramSocket.getLocalAddress()).append(':');
            stringBuffer.append(datagramSocket.getLocalPort());
        }
        this.deviceSearchResponseThread = new Thread((Runnable)this, stringBuffer.toString());
        this.deviceSearchResponseThread.start();
    }

    public void stop() {
        this.deviceSearchResponseThread = null;
    }

    public boolean post(String string, int n2, SSDPSearchResponse sSDPSearchResponse) {
        return this.post(string, n2, sSDPSearchResponse.getHeader());
    }

    public boolean post(String string, int n2, SSDPSearchRequest sSDPSearchRequest) {
        return this.post(string, n2, sSDPSearchRequest.toString());
    }
}

