/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class HTTPMUSocket {
    private static final String TAG = "hpplay-HTTPMUSocket";
    private InetSocketAddress ssdpMultiGroup = null;
    private MulticastSocket ssdpMultiSock = null;
    private NetworkInterface ssdpMultiIf = null;

    public HTTPMUSocket() {
    }

    public HTTPMUSocket(String string, int n2, String string2) {
        this.open(string, n2, string2);
    }

    protected void finalize() {
    }

    public String getLocalAddress() {
        if (this.ssdpMultiGroup == null || this.ssdpMultiIf == null) {
            return "";
        }
        InetAddress inetAddress = this.ssdpMultiGroup.getAddress();
        Enumeration<InetAddress> enumeration = this.ssdpMultiIf.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress2 = enumeration.nextElement();
            if (inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet6Address) {
                return inetAddress2.getHostAddress();
            }
            if (!(inetAddress instanceof Inet4Address) || !(inetAddress2 instanceof Inet4Address)) continue;
            return inetAddress2.getHostAddress();
        }
        return "";
    }

    public int getMulticastPort() {
        return this.ssdpMultiGroup.getPort();
    }

    public int getLocalPort() {
        return this.ssdpMultiSock.getLocalPort();
    }

    public MulticastSocket getSocket() {
        return this.ssdpMultiSock;
    }

    public InetAddress getMulticastInetAddress() {
        try {
            return this.ssdpMultiGroup.getAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getMulticastAddress() {
        if (this.getMulticastInetAddress() != null) {
            return this.getMulticastInetAddress().getHostAddress();
        }
        return "";
    }

    public boolean open(String string, int n2, InetAddress inetAddress) {
        try {
            this.ssdpMultiSock = new MulticastSocket(null);
            this.ssdpMultiSock.setReuseAddress(true);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n2);
            this.ssdpMultiSock.bind(inetSocketAddress);
            this.ssdpMultiGroup = new InetSocketAddress(InetAddress.getByName(string), n2);
            this.ssdpMultiIf = NetworkInterface.getByInetAddress(inetAddress);
            this.ssdpMultiSock.joinGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public boolean open(String string, int n2, String string2) {
        try {
            return this.open(string, n2, InetAddress.getByName(string2));
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
    }

    public synchronized boolean close() {
        if (this.ssdpMultiSock == null) {
            return true;
        }
        try {
            this.ssdpMultiSock.leaveGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
            this.ssdpMultiSock.close();
            this.ssdpMultiSock = null;
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public boolean send(String string, String string2, int n2) {
        try {
            MulticastSocket multicastSocket;
            if (string2 != null && 0 < n2) {
                multicastSocket = new MulticastSocket(null);
                multicastSocket.bind(new InetSocketAddress(string2, n2));
            } else {
                multicastSocket = new MulticastSocket();
            }
            DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), this.ssdpMultiGroup);
            multicastSocket.setTimeToLive(UPnP.getTimeToLive());
            multicastSocket.send(datagramPacket);
            multicastSocket.close();
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public boolean send(String string) {
        return this.send(string, null, -1);
    }

    public boolean post(HTTPRequest hTTPRequest, String string, int n2) {
        return this.send(hTTPRequest.toString(), string, n2);
    }

    public boolean post(HTTPRequest hTTPRequest) {
        return this.send(hTTPRequest.toString(), null, -1);
    }

    public SSDPPacket receive() {
        byte[] byArray = new byte[1024];
        SSDPPacket sSDPPacket = new SSDPPacket(byArray, byArray.length);
        sSDPPacket.setLocalAddress(this.getLocalAddress());
        if (this.ssdpMultiSock != null) {
            DatagramPacket datagramPacket = sSDPPacket.getDatagramPacket();
            try {
                if (datagramPacket != null) {
                    this.ssdpMultiSock.receive(datagramPacket);
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        } else {
            throw new IOException("Multicast socket has already been closed.");
        }
        sSDPPacket.setTimeStamp(System.currentTimeMillis());
        return sSDPPacket;
    }
}

