/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.utils.CLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AudioDataSender
extends Thread {
    private static final String TAG = "AudioDataSender";
    private boolean isQuit;
    private DatagramSocket mDatagramSocket;
    private BlockingQueue<byte[]> mVideoDataQueue = new LinkedBlockingQueue<byte[]>(10);
    private DatagramPacket mPacket;
    private byte[] mHeader = new byte[12];
    private long mSn;
    private long mStartPts;
    private byte[] sendData = new byte[0x100000];

    public AudioDataSender() {
        try {
            this.setName(TAG);
            this.mDatagramSocket = new DatagramSocket(null);
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
        }
    }

    public void setServerInfo(String string, int n2) {
        try {
            byte[] byArray = new byte[]{0};
            this.mPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n2);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void putAudioData(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        boolean bl = this.mVideoDataQueue.offer(byArray2);
    }

    @Override
    public void run() {
        super.run();
        try {
            while (!this.isInterrupted()) {
                this.sendData(this.mVideoDataQueue.take());
            }
        }
        catch (InterruptedException interruptedException) {
            CLog.w(TAG, interruptedException);
        }
    }

    public void sendData(byte[] byArray) {
        try {
            this.mHeader[0] = -128;
            this.mHeader[1] = 96;
            ++this.mSn;
            this.mHeader[2] = (byte)(this.mSn >> 8);
            this.mHeader[3] = (byte)this.mSn;
            this.mStartPts += 480L;
            this.mHeader[4] = (byte)(this.mStartPts >> 24);
            this.mHeader[5] = (byte)(this.mStartPts >> 16);
            this.mHeader[6] = (byte)(this.mStartPts >> 8);
            this.mHeader[7] = (byte)this.mStartPts;
            this.mHeader[8] = 0;
            this.mHeader[9] = 0;
            this.mHeader[10] = 0;
            this.mHeader[11] = 0;
            System.arraycopy(this.mHeader, 0, this.sendData, 0, this.mHeader.length);
            System.arraycopy(byArray, 0, this.sendData, this.mHeader.length, byArray.length);
            this.mPacket.setData(this.sendData, 0, this.mHeader.length + byArray.length);
            this.mDatagramSocket.send(this.mPacket);
        }
        catch (IOException iOException) {
            CLog.w(TAG, iOException);
        }
    }

    public void stopTask() {
        this.interrupt();
        try {
            this.mDatagramSocket.close();
            this.mVideoDataQueue.clear();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }
}

