/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartbowlib;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Build;
import java.util.ArrayList;

public class BluetoothTester {
    public static int checkBlePermissions(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
                permissions.add("android.permission.BLUETOOTH");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (context.checkSelfPermission("android.permission.BLUETOOTH_ADMIN") != 0) {
                permissions.add("android.permission.BLUETOOTH_ADMIN");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if (Build.VERSION.SDK_INT >= 29 && context.checkSelfPermission("android.permission.ACCESS_BACKGROUND_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_BACKGROUND_LOCATION");
            }
            if (permissions.size() > 0) {
                int notAskCount = 0;
                for (String permission : permissions) {
                    if (((Activity)context).shouldShowRequestPermissionRationale(permission)) continue;
                    ++notAskCount;
                }
                if (notAskCount > 0) {
                    return -1;
                }
                return 0;
            }
        }
        return 1;
    }

    public static String test(Context context) {
        String text = "";
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
                permissions.add("android.permission.BLUETOOTH");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (context.checkSelfPermission("android.permission.BLUETOOTH_ADMIN") != 0) {
                permissions.add("android.permission.BLUETOOTH_ADMIN");
            }
            if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if (Build.VERSION.SDK_INT >= 29 && context.checkSelfPermission("android.permission.ACCESS_BACKGROUND_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_BACKGROUND_LOCATION");
            }
            if (permissions.size() > 0) {
                for (String permission : permissions) {
                    text = text + permission;
                    if (!((Activity)context).shouldShowRequestPermissionRationale(permission)) {
                        text = text + "===@@@";
                    }
                    text = text + "\n";
                }
            }
        }
        return text;
    }

    public static int checkBleValid() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return -1;
        }
        if (adapter.isEnabled()) {
            return 1;
        }
        return 0;
    }
}

