/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.tony.bluetoothunityapi.BluetoothDeviceAddress;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.ScanResultBluetoothDevice;
import com.tony.bluetoothunityapi.ble.BluetoothHelperCharacteristic;
import com.tony.bluetoothunityapi.ble.BluetoothHelperService;
import com.tony.bluetoothunityapi.transceiver.CharacteristicTransceiver;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class BLEBluetoothHelper
extends BluetoothHelper {
    private BluetoothGatt gatt;
    private BluetoothGattCharacteristic txCharacteristic;
    private BluetoothGattCharacteristic rxCharacteristic;
    private CharacteristicTransceiver transceiver;
    private BluetoothHelperCharacteristic cTxCharacteristic;
    private BluetoothHelperCharacteristic cRxCharacteristic;
    private int retries;
    private final UUID PORT_UUID = UUID.fromString("0000ffe0-0000-1000-8000-00805f9b34fb");
    private final UUID ADA_DATA_OUT_CHAR = UUID.fromString("6e400002-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_DATA_IN_CHAR = UUID.fromString("6e400003-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_SERVICE_UUID = UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_CONFIG_CHAR = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final UUID DF_ROBOT_SERVICE_UUID = UUID.fromString("0000dfb0-0000-1000-8000-00805f9b34fb");
    private LinkedList<BluetoothHelperService> services;
    private List<BluetoothHelperService> peripheralServices;
    private LinkedList<ScanResultBluetoothDevice> bleDevices;
    private static LinkedList<ScanResultBluetoothDevice> sharedBleDevices = new LinkedList();
    private LinkedList<BluetoothGattCharacteristic> pendingCharacteristics;
    private boolean discoveringServices;
    private ScanCallback scanCallback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            super.onScanResult(callbackType, result);
            this.processResult(result);
        }

        private void processResult(ScanResult result) {
            Log.d((String)"BluetoothAPI", (String)"found device ...");
            BluetoothDevice device = result.getDevice();
            result.getRssi();
            ScanResultBluetoothDevice bleScanResult = new ScanResultBluetoothDevice(device, result.getRssi());
            Log.d((String)"BluetoothAPI", (String)("found device [" + device.getName() + "]"));
            if (device.getName() == null) {
                return;
            }
            int index = BLEBluetoothHelper.this.bleDevices.indexOf(bleScanResult);
            if (index == -1) {
                BLEBluetoothHelper.this.bleDevices.add(bleScanResult);
            } else {
                ((ScanResultBluetoothDevice)BLEBluetoothHelper.this.bleDevices.get(index)).setRssi((result.getRssi() + ((ScanResultBluetoothDevice)BLEBluetoothHelper.this.bleDevices.get(index)).getRssi()) / 2);
            }
        }
    };
    private BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            Log.d((String)"BluetoothAPI", (String)("onConnectionStateChange " + status));
            if (status != 0) {
                Log.d((String)"BluetoothAPI", (String)"onConnectionStateChange failed");
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            } else if (newState == 2 && !BLEBluetoothHelper.this.discoveringServices) {
                BLEBluetoothHelper.this.discoveringServices = true;
                gatt.requestConnectionPriority(1);
                Log.d((String)"BluetoothAPI", (String)("Discovering services " + gatt.getServices().size()));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Log.e((String)"BluetoothAPI", (String)e.getMessage());
                }
                if (gatt.getServices().size() != 0) {
                    this.onServicesDiscovered(gatt, status);
                } else if (!gatt.discoverServices()) {
                    Log.w((String)"BluetoothAPI", (String)"Unable to discover services");
                    gatt.disconnect();
                    gatt.close();
                    BLEBluetoothHelper.this.invokeOnConnectionFailed();
                } else {
                    Log.d((String)"BluetoothAPI", (String)"Discovering services started");
                }
            } else if (newState == 0 && (BLEBluetoothHelper.this.connected || BLEBluetoothHelper.this.isConnecting)) {
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.peripheralServices.clear();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            } else if (newState == 1) {
                Log.d((String)"BluetoothAPI", (String)"Connecting");
                BLEBluetoothHelper.this.discoveringServices = false;
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            BLEBluetoothHelper.this.discoveringServices = false;
            BLEBluetoothHelper.this.gatt = gatt;
            Log.d((String)"BluetoothAPI", (String)"onServicesDiscovered");
            BLEBluetoothHelper.this.peripheralServices.clear();
            if (gatt.getServices().size() == 0) {
                Log.w((String)"BluetoothAPI", (String)"no services discovered, disconnecting");
                if (!BLEBluetoothHelper.this.refreshDeviceCache(gatt)) {
                    Log.w((String)"BluetoothAPI", (String)"failed to refresh cache");
                }
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.peripheralServices.clear();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
                return;
            }
            for (BluetoothGattService service : gatt.getServices()) {
                Log.d((String)"BluetoothAPI", (String)service.getUuid().toString());
                BluetoothHelperService s = new BluetoothHelperService(service.getUuid().toString());
                for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                    s.addCharacteristic(new BluetoothHelperCharacteristic(characteristic.getUuid().toString()));
                }
                BLEBluetoothHelper.this.peripheralServices.add(s);
            }
            Log.d((String)"BluetoothAPI", (String)("Services Count " + BLEBluetoothHelper.this.services.size()));
            Log.d((String)"BluetoothAPI", (String)("Total Services Count " + BLEBluetoothHelper.this.peripheralServices.size()));
            if (status == 0) {
                try {
                    gatt.requestMtu(512);
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.startSubscription(gatt);
            } else {
                Log.d((String)"BluetoothAPI", (String)"onServicesDiscovered failed");
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            Log.d((String)"BluetoothAPI", (String)("CHANGED!! " + characteristic.getValue().length));
            if (BLEBluetoothHelper.this.streamManager == null) {
                BluetoothHelperCharacteristic charac = new BluetoothHelperCharacteristic();
                charac.setService(characteristic.getService().getUuid().toString());
                charac.setName(characteristic.getUuid().toString());
                BLEBluetoothHelper.this.invokeOnCharacteristicChanged(characteristic.getValue(), charac);
            } else if (BLEBluetoothHelper.this.transceiver != null) {
                BLEBluetoothHelper.this.transceiver.InvokeMessageReceived(characteristic.getValue());
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            if (status != 0) {
                Log.d((String)"BluetoothAPI", (String)"onMtuChanged failed");
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            } else {
                Log.d((String)"BluetoothAPI", (String)"MTU changed successfully");
            }
        }

        private void startSubscription(BluetoothGatt gatt) {
            Log.d((String)"BluetoothAPI", (String)"Ready to subscribe");
            if (BLEBluetoothHelper.this.services.size() == 0 || BLEBluetoothHelper.this.cTxCharacteristic != null || BLEBluetoothHelper.this.cRxCharacteristic != null) {
                BLEBluetoothHelper.this.subscribeToSerialServices(gatt);
            } else {
                BLEBluetoothHelper.this.subscribeToSelectedServices(gatt);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            Log.d((String)"BluetoothAPI", (String)"Characteristic read");
            BluetoothHelperCharacteristic charac = new BluetoothHelperCharacteristic();
            charac.setService(characteristic.getService().getUuid().toString());
            charac.setName(characteristic.getUuid().toString());
            BLEBluetoothHelper.this.invokeOnCharacteristicChanged(characteristic.getValue(), charac);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            Log.d((String)"BluetoothAPI", (String)("Subscription Completed " + status));
            BLEBluetoothHelper.this.subscribeSingleCharacteristics(gatt);
        }
    };
    private Runnable scanningRunnable = new Runnable(){

        @Override
        public void run() {
            BluetoothHelper.isScanning = false;
            Log.d((String)"BluetoothAPI", (String)"Stopping scan");
            BLEBluetoothHelper.this.bluetoothAdapter.getBluetoothLeScanner().stopScan(BLEBluetoothHelper.this.scanCallback);
            BLEBluetoothHelper.this.bluetoothAdapter.getBluetoothLeScanner().flushPendingScanResults(BLEBluetoothHelper.this.scanCallback);
            sharedBleDevices.clear();
            BluetoothHelper.nearbyDevices.clear();
            sharedBleDevices.addAll(BLEBluetoothHelper.this.bleDevices);
            Log.d((String)"BluetoothAPI", (String)("found " + sharedBleDevices.size() + " devices"));
            for (ScanResultBluetoothDevice device : sharedBleDevices) {
                BluetoothDeviceAddress deviceAddress = new BluetoothDeviceAddress(device.getName(), device.getAddress(), device.getRssi());
                BluetoothHelper.nearbyDevices.add(deviceAddress);
            }
            BLEBluetoothHelper.this.isDevicePaired();
            BLEBluetoothHelper.this.invokeOnScanEnded();
        }
    };
    private Runnable connectionRunnable = new Runnable(){

        @Override
        public void run() {
            if (!BLEBluetoothHelper.this.isConnecting) {
                return;
            }
            BLEBluetoothHelper.this.retries--;
            try {
                BLEBluetoothHelper.this.gatt.disconnect();
                BLEBluetoothHelper.this.gatt.close();
                BLEBluetoothHelper.this.gatt = null;
                if (BLEBluetoothHelper.this.retries > 0) {
                    BLEBluetoothHelper.this.connect();
                } else {
                    BLEBluetoothHelper.this.invokeOnConnectionFailed();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    private void subscribeToSerialServices(BluetoothGatt gatt) {
        try {
            BluetoothGattService service = null;
            if (this.cRxCharacteristic != null || this.cTxCharacteristic != null) {
                if (this.cTxCharacteristic != null) {
                    service = gatt.getService(BLEBluetoothHelper.GetUUIDFromString(this.cTxCharacteristic.getService()));
                    if (service != null) {
                        this.txCharacteristic = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(this.cTxCharacteristic.getName()));
                        if (this.txCharacteristic == null) {
                            this.invokeOnCharacteristicNotFound(this.cTxCharacteristic.getService(), this.cTxCharacteristic.getName());
                        }
                    } else {
                        this.invokeOnServiceNotFound(this.cTxCharacteristic.getService());
                    }
                }
                if (this.cRxCharacteristic != null) {
                    service = gatt.getService(BLEBluetoothHelper.GetUUIDFromString(this.cRxCharacteristic.getService()));
                    if (service != null) {
                        this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, BLEBluetoothHelper.GetUUIDFromString(this.cRxCharacteristic.getName()));
                    } else {
                        this.invokeOnServiceNotFound(this.cTxCharacteristic.getService());
                    }
                }
            } else {
                service = gatt.getService(this.PORT_UUID);
                if (service != null) {
                    this.rxCharacteristic = this.txCharacteristic = (BluetoothGattCharacteristic)service.getCharacteristics().get(0);
                    gatt.setCharacteristicNotification(this.rxCharacteristic, true);
                } else {
                    service = gatt.getService(this.ADA_SERVICE_UUID);
                    if (service != null) {
                        this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, this.ADA_DATA_IN_CHAR);
                        this.txCharacteristic = service.getCharacteristic(this.ADA_DATA_OUT_CHAR);
                    } else {
                        service = gatt.getService(this.DF_ROBOT_SERVICE_UUID);
                        if (service != null) {
                            this.rxCharacteristic = this.txCharacteristic = (BluetoothGattCharacteristic)service.getCharacteristics().get(0);
                            gatt.setCharacteristicNotification(this.rxCharacteristic, true);
                        } else {
                            Log.d((String)"BluetoothAPI", (String)"Not subscribing");
                        }
                    }
                }
            }
            this.invokeOnConnected();
        }
        catch (Exception ex) {
            Log.d((String)"BluetoothAPI", (String)ex.getMessage());
            gatt.disconnect();
            gatt.close();
            this.invokeOnConnectionFailed();
        }
    }

    private boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            BluetoothGatt localBluetoothGatt = gatt;
            Method localMethod = localBluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (localMethod != null) {
                boolean bool = (Boolean)localMethod.invoke((Object)localBluetoothGatt, new Object[0]);
                return bool;
            }
        }
        catch (Exception ex) {
            Log.e((String)"BluetoothAPI", (String)"An exception occurred while refreshing device", (Throwable)ex);
        }
        return false;
    }

    private BluetoothGattCharacteristic subscribeNotifyIndicateCharacteristic(BluetoothGatt gatt, BluetoothGattService s, UUID c) {
        BluetoothGattCharacteristic characteristic = s.getCharacteristic(c);
        if (characteristic == null) {
            this.invokeOnCharacteristicNotFound(s.getUuid().toString(), c.toString());
            return null;
        }
        gatt.setCharacteristicNotification(characteristic, true);
        BluetoothGattDescriptor config = characteristic.getDescriptor(this.ADA_CONFIG_CHAR);
        if (config != null) {
            int j = characteristic.getProperties();
            if ((j & 0x20) != 0) {
                config.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                gatt.writeDescriptor(config);
            } else if ((j & 0x10) != 0) {
                config.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(config);
            }
        }
        return characteristic;
    }

    private void subscribeToSelectedServices(BluetoothGatt gatt) {
        try {
            Object characteristic = null;
            Object config = null;
            for (BluetoothHelperService srvc : this.services) {
                this.subscribeBleService(srvc);
            }
            this.subscribeSingleCharacteristics(gatt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.d((String)"BluetoothAPI", (String)ex.getMessage());
            gatt.disconnect();
            gatt.close();
            this.invokeOnConnectionFailed();
        }
    }

    private void subscribeBleService(BluetoothHelperService srvc) {
        Log.d((String)"BluetoothAPI", (String)("Service Name : " + srvc.getName()));
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(srvc.getName()));
        if (service == null) {
            Log.d((String)"BluetoothAPI", (String)"service is null");
            this.invokeOnServiceNotFound(srvc.getName());
            return;
        }
        for (BluetoothHelperCharacteristic characteristic : srvc.getCharacteristics()) {
            Log.d((String)"BluetoothAPI", (String)characteristic.getName());
            BluetoothGattCharacteristic gattCharacteristic = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
            if (gattCharacteristic == null) {
                Log.d((String)"BluetoothAPI", (String)"characteristic is null");
                this.invokeOnCharacteristicNotFound(characteristic.getService(), characteristic.getName());
                continue;
            }
            Log.d((String)"BluetoothAPI", (String)("Adding " + characteristic.getName()));
            this.pendingCharacteristics.add(gattCharacteristic);
        }
    }

    private void subscribeSingleCharacteristics(BluetoothGatt gatt) {
        if (this.pendingCharacteristics.size() == 0) {
            Log.d((String)"BluetoothAPI", (String)("Done subscribing ... " + this.connected));
            this.services.clear();
            this.invokeOnConnected();
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Subscribing...");
        BluetoothGattCharacteristic characteristic = this.pendingCharacteristics.poll();
        Log.d((String)"BluetoothAPI", (String)("Subscribing to : " + characteristic.getUuid().toString()));
        characteristic.setWriteType(2);
        gatt.setCharacteristicNotification(characteristic, true);
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.ADA_CONFIG_CHAR);
        if (descriptor != null) {
            Log.d((String)"BluetoothAPI", (String)("descr uuid : " + descriptor.getUuid().toString()));
            int j = characteristic.getProperties();
            if ((j & 0x20) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("indication : " + descriptor.getUuid().toString()));
            } else if ((j & 0x10) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("notification : " + descriptor.getUuid().toString()));
            } else {
                this.subscribeSingleCharacteristics(gatt);
            }
        } else {
            this.subscribeSingleCharacteristics(gatt);
        }
    }

    BLEBluetoothHelper(Context context, String deviceName) {
        super(context, deviceName);
    }

    @Override
    protected void BTinit() {
        super.BTinit();
        this.peripheralServices = new ArrayList<BluetoothHelperService>();
        this.bleDevices = new LinkedList();
        this.services = new LinkedList();
        this.transceiver = new CharacteristicTransceiver(this);
        this.pendingCharacteristics = new LinkedList();
    }

    @Override
    public boolean scanNearbyDevices() {
        if (isScanning) {
            return false;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        isScanning = true;
        Log.d((String)"BluetoothAPI", (String)"Preparing scanning");
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
        this.bleDevices.clear();
        Log.d((String)"BluetoothAPI", (String)"Start scanning");
        this.bluetoothAdapter.getBluetoothLeScanner().startScan(this.scanCallback);
        Log.d((String)"BluetoothAPI", (String)"Scan started");
        Handler stopHandler = new Handler();
        stopHandler.postDelayed(this.scanningRunnable, 8000L);
        return true;
    }

    @Override
    public List<BluetoothDeviceAddress> getPairedDevicesList() {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    protected void searchForDevice() {
        this.devicePaired = false;
        this.device = null;
        if (this.deviceName == null && this.deviceAddress == null) {
            return;
        }
        if (this.bluetoothAdapter == null) {
            return;
        }
        for (ScanResultBluetoothDevice iterator : sharedBleDevices) {
            if (this.deviceName != null) {
                if (!iterator.getName().equals(this.deviceName)) continue;
                this.bt_device = iterator;
                this.devicePaired = true;
                break;
            }
            if (!iterator.getAddress().equals(this.deviceAddress)) continue;
            this.bt_device = iterator;
            this.devicePaired = true;
            break;
        }
        if (this.devicePaired) {
            this.device = new BluetoothDeviceAddress(this.bt_device.getName(), this.bt_device.getAddress(), this.bt_device.getRssi());
        }
    }

    @Override
    public void connect() {
        if (this.connected) {
            return;
        }
        if (this.isConnecting && this.retries <= 0) {
            return;
        }
        if (!this.isConnecting) {
            this.retries = 2;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        if (!this.devicePaired) {
            throw new BluetoothHelper.BlueToothNotReadyException();
        }
        this.connected = false;
        Log.d((String)"BluetoothAPI", (String)("Connecting " + this.retries));
        this.isConnecting = true;
        this.discoveringServices = false;
        this.gatt = Build.VERSION.SDK_INT < 23 ? this.bt_device.getBluetoothDevice().connectGatt(this.context, false, this.gattCallback) : this.bt_device.getBluetoothDevice().connectGatt(this.context, false, this.gattCallback, 2);
        Handler stopHandler = new Handler();
        stopHandler.postDelayed(this.connectionRunnable, 10000L);
    }

    @Override
    public void disconnect() {
        this.connected = false;
        this.peripheralServices.clear();
        if (this.gatt != null) {
            this.gatt.disconnect();
            this.gatt.close();
            Log.d((String)"BluetoothAPI", (String)"Disconnected");
        }
        this.gatt = null;
        this.device = null;
        this.bt_device = null;
        this.deviceName = null;
        this.deviceAddress = null;
    }

    @Override
    public ITransceiver getTransceiver() {
        return this.transceiver;
    }

    public BluetoothGatt getGatt() {
        return this.gatt;
    }

    public BluetoothGattCharacteristic getTxCharacteristic() {
        return this.txCharacteristic;
    }

    @Override
    public void subscribe(BluetoothHelperService service) {
        if (!this.connected) {
            if (this.services.contains(service)) {
                return;
            }
            this.services.add(service);
        } else {
            this.subscribeBleService(service);
            this.subscribeSingleCharacteristics(this.gatt);
        }
    }

    @Override
    public void subscribe(BluetoothHelperCharacteristic characteristic) {
        BluetoothHelperService s = new BluetoothHelperService(characteristic.getService());
        if (this.services.contains(s)) {
            s = this.services.get(this.services.indexOf(s));
        }
        s.addCharacteristic(characteristic);
        if (this.connected) {
            this.subscribeBleService(s);
            this.subscribeSingleCharacteristics(this.gatt);
        } else {
            this.services.add(s);
        }
    }

    @Override
    public void writeCharacteristic(BluetoothHelperCharacteristic characteristic, byte[] value) {
        if (!this.connected) {
            throw new BluetoothHelper.BlueToothNotConnectedException();
        }
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(characteristic.getService()));
        if (service == null) {
            throw new BluetoothHelper.ServiceNotFoundException();
        }
        BluetoothGattCharacteristic characteristic1 = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
        if (characteristic1 == null) {
            throw new BluetoothHelper.CharacteristicNotFoundException();
        }
        characteristic1.setValue(value);
        if (!this.gatt.writeCharacteristic(characteristic1)) {
            Log.d((String)"BluetoothAPI", (String)"Writing failed");
        }
    }

    @Override
    public void readCharacteristic(BluetoothHelperCharacteristic characteristic) {
        if (!this.connected) {
            throw new BluetoothHelper.BlueToothNotConnectedException();
        }
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(characteristic.getService()));
        if (service == null) {
            throw new BluetoothHelper.ServiceNotFoundException();
        }
        BluetoothGattCharacteristic characteristic1 = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
        if (characteristic1 == null) {
            throw new BluetoothHelper.CharacteristicNotFoundException();
        }
        Log.d((String)"BluetoothAPI", (String)("Reading characteristic [" + characteristic.getName() + "]"));
        if (!this.gatt.readCharacteristic(characteristic1)) {
            Log.d((String)"BluetoothAPI", (String)"Reading failed");
        }
    }

    private static UUID GetUUIDFromString(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.toLowerCase()).length() == 4) {
            return UUID.fromString("0000" + name + "-0000-1000-8000-00805f9b34fb");
        }
        return UUID.fromString(name);
    }

    @Override
    public void setTxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        this.cTxCharacteristic = characteristic;
    }

    @Override
    public void setRxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        this.cRxCharacteristic = characteristic;
    }

    @Override
    public List<BluetoothHelperService> getGattServices() {
        return this.peripheralServices;
    }
}

