/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.UUID;

public class LeboUtil {
    private static final String TAG = "LeboUtil";
    private static final String CUT_ANDROID = "1";
    private static final String SIGN_NORMAL = "0";
    private static final String SIGN_M = "1";
    private static final String SIGN_IMEI = "2";
    private static final String SIGN_OAID = "6";
    private static final String SIGN_AID = "7";
    private static final String SIGN_NEW_M = "8";
    private static final String DEFAULT_M = "0000000000000000";
    private static String sAID = "";

    public static int getCUid(Context context) {
        if (null == context) {
            return -1;
        }
        return EncryptUtil.fnvHash((String)EncryptUtil.md5EncryData16((String)("1" + LeboUtil.getCUidMaterial(context) + context.getPackageName()).toUpperCase()).toUpperCase());
    }

    public static long getCUid64(Context context) {
        return EncryptUtil.parseMd5L16ToLong((String)EncryptUtil.md5EncryData16((String)("1" + LeboUtil.getCUidMaterial(context) + context.getPackageName()).toUpperCase()).toUpperCase());
    }

    private static String getCUidMaterial(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.delete(0, stringBuilder.length());
        try {
            if (!TextUtils.isEmpty((CharSequence)DeviceUtil.getOAID((Context)context))) {
                stringBuilder.append(DeviceUtil.getOAID((Context)context));
            } else if (!TextUtils.isEmpty((CharSequence)LeboUtil.getAID(context))) {
                stringBuilder.append(LeboUtil.getAID(context));
            }
        }
        catch (Exception exception) {
            LeLog.w((String)TAG, (Throwable)exception);
        }
        if (TextUtils.isEmpty((CharSequence)stringBuilder.toString())) {
            stringBuilder.append(DEFAULT_M);
        }
        return stringBuilder.toString();
    }

    public static String getNewSourceHID(Context context) {
        String string = "";
        if (Build.VERSION.SDK_INT <= 28) {
            try {
                string = EncryptUtil.md5EncryData((String)string.toUpperCase());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    string = SIGN_IMEI + string.toUpperCase();
                    return string;
                }
                string = DEFAULT_M;
            }
            catch (Exception exception) {
                LeLog.w((String)TAG, (Throwable)exception);
                string = DEFAULT_M;
            }
        } else {
            string = DEFAULT_M;
        }
        string = EncryptUtil.md5EncryData((String)string.toUpperCase());
        string = SIGN_NORMAL + string.toUpperCase();
        return string;
    }

    public static String getAID(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAID)) {
            return sAID;
        }
        String string = Preference.getInstance().get("key_lb_ai");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                sAID = new String(Base64.decode((String)string, (int)0));
                return sAID;
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(sAID = DeviceUtil.getAID((Context)context)))) {
            try {
                String string2 = Base64.encodeToString((byte[])sAID.getBytes(), (int)0);
                Preference.getInstance().put("key_lb_ai", string2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            return sAID;
        }
        sAID = UUID.randomUUID().toString();
        try {
            String string3 = Base64.encodeToString((byte[])sAID.getBytes(), (int)0);
            Preference.getInstance().put("key_lb_ai", string3);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return sAID;
    }

    public static String anonymizeByMD5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            string = string.toUpperCase().replace(":", "");
            string = EncryptUtil.md5EncryData((String)string);
            string = string.toUpperCase();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "anonymizeByMD5 error " + exception);
        }
        return string;
    }

    public static String anonymizeBySHA256(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            string = string.toUpperCase().replace(":", "");
            string = EncryptUtil.encryptSHA256ToString((String)string);
            string = string.toUpperCase();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "anonymizeBySHA256 error " + exception);
        }
        return string;
    }
}

