/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.File;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static boolean isExternalStorageAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static long getSDAvailableSize() {
        try {
            long l;
            long l2;
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = new StatFs(file.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                l2 = statFs.getBlockSizeLong();
                l = statFs.getAvailableBlocksLong();
            } else {
                l2 = statFs.getBlockSize();
                l = statFs.getAvailableBlocks();
            }
            return l2 * l;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return 0L;
        }
    }
}

