/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

public class ByteUtils {
    public static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static float bytesToFloat(byte[] byArray, int n) {
        int n2 = byArray[n];
        n2 &= 0xFF;
        n2 = (int)((long)n2 | (long)byArray[n + 1] << 8);
        n2 &= 0xFFFF;
        n2 = (int)((long)n2 | (long)byArray[n + 2] << 16);
        n2 &= 0xFFFFFF;
        n2 = (int)((long)n2 | (long)byArray[n + 3] << 24);
        return Float.intBitsToFloat(n2);
    }

    public static byte[] hexToBytes(String string) {
        if (string == null || string.trim().equals("")) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            byArray[i] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static byte[] float2byte(float f) {
        int n;
        int n2 = Float.floatToIntBits(f);
        byte[] byArray = new byte[4];
        for (n = 0; n < 4; ++n) {
            byArray[n] = (byte)(n2 >> 24 - n * 8);
        }
        n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        for (int i = 0; i < n / 2; ++i) {
            byte by = byArray2[i];
            byArray2[i] = byArray2[n - i - 1];
            byArray2[n - i - 1] = by;
        }
        return byArray2;
    }
}

