/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.log;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.hpplay.common.log.ILogCallback;
import com.hpplay.common.log.LeLog;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.logwriter.ILogcatCollect;
import com.hpplay.logwriter.LogWriter;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.ISourceLog;
import com.hpplay.sdk.source.log.LogCache;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.LogcatLogCollect;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SourceLogWriter
implements ISourceLog {
    private static final String TAG = "hpplay-java:SWR";
    private static LogWriter sLogWriter = null;
    private ILogCallback sLogCallback = new ILogCallback(){

        public void onLogCallback(Object ... objectArray) {
            try {
                SourceLogWriter.this.mHandler.sendMessage(SourceLogWriter.this.mHandler.obtainMessage(1, objectArray[0]));
            }
            catch (Exception exception) {
                Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
            }
        }
    };
    private CLog.IComponentLogCallback sClogCallback = new CLog.IComponentLogCallback(){

        public void onCastLog(int n, String string) {
            try {
                SourceLogWriter.this.mHandler.sendMessage(SourceLogWriter.this.mHandler.obtainMessage(1, (Object)string));
            }
            catch (Exception exception) {
                Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
            }
        }
    };
    private SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.getDefault());
    private Date sDate = new Date();
    private static final int WHAT_WRITE_LOG = 1;
    private HandlerThread mHandlerThread = new HandlerThread("bu log writer");
    private Handler mHandler = null;
    private String mLogDir = null;
    private static LogcatLogCollect sLogcat;

    public SourceLogWriter() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 1: {
                        try {
                            SourceLogWriter.this.writeLogImpl(message.obj.toString());
                            break;
                        }
                        catch (Exception exception) {
                            Log.w((String)SourceLogWriter.TAG, (Throwable)exception);
                        }
                    }
                }
            }
        };
    }

    public String getLogDir() {
        return this.mLogDir;
    }

    public void enableLogNotWriter() {
        try {
            LeLog.enableTrace(null);
            CLog.setLogCallback(null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void enableLogAndWriter(Context context, int n) {
        LeLog.enableTrace((ILogCallback)this.sLogCallback);
        CLog.setLogCallback((CLog.IComponentLogCallback)this.sClogCallback);
        this.checkLogWrite(context, n);
    }

    public void disableLogButWriter(Context context, int n) {
        LeLog.disableTrace((ILogCallback)this.sLogCallback);
        CLog.setLogCallback((CLog.IComponentLogCallback)this.sClogCallback);
        this.checkLogWrite(context, n);
    }

    private void checkLogWrite(Context context, int n) {
        try {
            sLogWriter = LogWriter.getInstance();
            if (!sLogWriter.isStartCollectLog()) {
                this.mLogDir = LogCache.getLogDir();
                Log.i((String)TAG, (String)("enableLog " + this.mLogDir));
                if (sLogcat == null && !a.a()) {
                    sLogcat = new LogcatLogCollect();
                }
                sLogWriter.setLogCat((ILogcatCollect)sLogcat);
                sLogWriter.startWrite(context, this.mLogDir, n);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void disableLogAndWriter() {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.stopWrite();
            sLogWriter = null;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        try {
            LeLog.disableTrace();
            CLog.setLogCallback(null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    public void flushLogWriter() {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.flushLog();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void writeLog(String string) {
        try {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)string));
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
    }

    private void writeLogImpl(String string) {
        try {
            if (sLogWriter == null) {
                return;
            }
            sLogWriter.writeLog(this.getDate() + string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public static void testLog() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                while (sLogWriter != null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sLogWriter.writeLog("testLog *****************  " + n++);
                }
            }
        }).start();
    }

    private String getDate() {
        try {
            this.sDate.setTime(System.currentTimeMillis());
            return this.sDateFormat.format(this.sDate);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void V(String string, String string2) {
        String string3 = LeLog.V((String)string, (String)string2);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void v(String string, String string2) {
        String string3 = LeLog.v((String)string, (String)string2);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void V(String string, String string2, Throwable throwable) {
        String string3 = LeLog.V((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void v(String string, String string2, Throwable throwable) {
        String string3 = LeLog.v((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(2, string3);
    }

    @Override
    public void D(String string, String string2) {
        String string3 = LeLog.D((String)string, (String)string2);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void d(String string, String string2) {
        String string3 = LeLog.d((String)string, (String)string2);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void D(String string, String string2, Throwable throwable) {
        String string3 = LeLog.D((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void d(String string, String string2, Throwable throwable) {
        String string3 = LeLog.d((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(3, string3);
    }

    @Override
    public void I(String string, String string2) {
        String string3 = LeLog.I((String)string, (String)string2);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void i(String string, String string2) {
        String string3 = LeLog.i((String)string, (String)string2);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void I(String string, String string2, Throwable throwable) {
        String string3 = LeLog.I((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void i(String string, String string2, Throwable throwable) {
        String string3 = LeLog.i((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(4, string3);
    }

    @Override
    public void W(String string, String string2) {
        String string3 = LeLog.W((String)string, (String)string2);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void w(String string, String string2) {
        String string3 = LeLog.w((String)string, (String)string2);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void W(String string, String string2, Throwable throwable) {
        String string3 = LeLog.W((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void w(String string, String string2, Throwable throwable) {
        String string3 = LeLog.w((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(5, string3);
    }

    @Override
    public void W(String string, Throwable throwable) {
        String string2 = LeLog.W((String)string, (Throwable)throwable);
        SourceLogWriter.callbackLog(5, string2);
    }

    @Override
    public void w(String string, Throwable throwable) {
        String string2 = LeLog.w((String)string, (Throwable)throwable);
        SourceLogWriter.callbackLog(5, string2);
    }

    @Override
    public void E(String string, String string2) {
        String string3 = LeLog.E((String)string, (String)string2);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void e(String string, String string2) {
        String string3 = LeLog.e((String)string, (String)string2);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void E(String string, String string2, Throwable throwable) {
        String string3 = LeLog.E((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(6, string3);
    }

    @Override
    public void e(String string, String string2, Throwable throwable) {
        String string3 = LeLog.e((String)string, (String)string2, (Throwable)throwable);
        SourceLogWriter.callbackLog(6, string3);
    }

    private static void callbackLog(int n, String string) {
        com.hpplay.sdk.source.api.ILogCallback iLogCallback;
        if (null != Session.getInstance() && null != (iLogCallback = Session.getInstance().getLogCallback())) {
            iLogCallback.onCastLog(n, string);
        }
    }
}

