/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.easycast;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Toast;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.api.LelinkSourceSDK;
import com.hpplay.sdk.source.bean.CastBean;
import com.hpplay.sdk.source.browse.api.IServiceSelectListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.easycast.BrowserController;
import com.hpplay.sdk.source.easycast.BrowserDevice;
import com.hpplay.sdk.source.easycast.IEasyCastListener;
import com.hpplay.sdk.source.easycast.bean.EasyCastBean;
import com.hpplay.sdk.source.log.SourceLog;

public class BrowserManager {
    private static final String TAG = "BrowserManager";
    private static BrowserManager sInstance = null;
    private IEasyCastListener mCastListener;
    private BrowserController mController;
    private LelinkServiceInfo mLastSelectInfo;
    private EasyCastBean mLastCastBean;
    private boolean useDLNA = true;
    private boolean useLelink = true;
    private boolean isPush = true;
    private ViewGroup mContainer;
    private Context mContext;
    private String mPassword;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean isCastError = false;
    private int mErrorWhat = -1;
    private int mErrorExtra = -1;
    private IServiceSelectListener mSelectListener = new IServiceSelectListener(){

        @Override
        public void onSelect(LelinkServiceInfo lelinkServiceInfo) {
            SourceLog.i(BrowserManager.TAG, "onSelect info:" + lelinkServiceInfo);
            BrowserManager.this.mLastSelectInfo = lelinkServiceInfo;
            BrowserManager.this.startPlay(lelinkServiceInfo);
        }
    };
    private INewPlayerListener mPlayerListener = new INewPlayerListener(){

        @Override
        public void onLoading(CastBean castBean) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            BrowserManager.this.isCastError = false;
            SourceLog.i(BrowserManager.TAG, "onLoading info:" + castBean);
            BrowserManager.this.destroyView();
            BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastLoading(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean);
                    }
                }
            });
        }

        @Override
        public void onStart(CastBean castBean) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            BrowserManager.this.isCastError = false;
            SourceLog.i(BrowserManager.TAG, "onStart info:" + castBean);
            BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastStart(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean);
                    }
                }
            });
        }

        @Override
        public void onPause(CastBean castBean) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastPause(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean);
                    }
                }
            });
        }

        @Override
        public void onCompletion(CastBean castBean, int n) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            SourceLog.w(BrowserManager.TAG, "onCompletion ");
            BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastCompletion(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean);
                    }
                    BrowserManager.this.startPush(BrowserManager.this.mLastSelectInfo);
                }
            });
        }

        @Override
        public void onStop(CastBean castBean) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            SourceLog.w(BrowserManager.TAG, "onStop ");
            BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastStop(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean);
                    }
                }
            });
        }

        @Override
        public void onSeekComplete(CastBean castBean, int n) {
        }

        @Override
        public void onInfo(CastBean castBean, int n, int n2) {
        }

        @Override
        public void onInfo(CastBean castBean, int n, String string) {
        }

        @Override
        public void onError(CastBean castBean, int n, int n2) {
            String string = "\u672a\u77e5\u5f02\u5e38";
            switch (n2) {
                case -2: 
                case 0: {
                    string = "SDK\u8ba4\u8bc1\u5931\u8d25";
                    break;
                }
                case 211026: {
                    BrowserManager.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BrowserManager.this.showPWDDialog();
                        }
                    });
                    return;
                }
                case 210004: {
                    string = "\u63a5\u6536\u7aef\u4e0d\u5728\u7ebf";
                    break;
                }
                case 210011: {
                    string = "\u7f51\u7edc\u901a\u8baf\u5f02\u5e38";
                    break;
                }
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = "\u63a8\u9001 onError " + n + "/" + n2;
            }
            BrowserManager.this.isCastError = true;
            BrowserManager.this.mErrorWhat = n;
            BrowserManager.this.mErrorExtra = n2;
            SourceLog.i(BrowserManager.TAG, "onError:" + n + "/" + n2);
            BrowserManager.this.notifyError(n, n2);
        }

        @Override
        public void onVolumeChanged(CastBean castBean, float f) {
        }

        @Override
        public void onPositionUpdate(CastBean castBean, final long l, final long l2) {
            if (!BrowserManager.this.checkSameCast(castBean, BrowserManager.this.mLastCastBean)) {
                return;
            }
            if (BrowserManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrowserManager.this.mCastListener != null) {
                        BrowserManager.this.mCastListener.onCastPositionUpdate(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean, l, l2);
                    }
                }
            })) {
                // empty if block
            }
        }
    };

    private void notifyError(int n, int n2) {
        if (this.mController != null) {
            String string = null;
            String string2 = null;
            switch (n2) {
                case 210004: 
                case 210011: {
                    string = "\u7f51\u7edc\u5f02\u5e38";
                    string2 = "\u8bf7\u68c0\u67e5\n\u5927\u5c4f\u548c\u624b\u673a\u7aef\u7f51\u7edc\u540e\u91cd\u8bd5";
                    break;
                }
                case 210000: 
                case 210010: 
                case 211000: 
                case 211010: {
                    string = "\u6295\u5c4f\u5f02\u5e38";
                    string2 = "\u8bf7\u9000\u51fa\u540e\u91cd\u8fde";
                    break;
                }
                case 211052: {
                    string = "\u4e0d\u652f\u6301\u8be5\u529f\u80fd";
                    string2 = "\u5927\u5c4f\u8bbe\u5907\u4e0d\u652f\u6301\u8be5\u529f\u80fd";
                    break;
                }
                case 211055: {
                    string = "\u5927\u5c4f\u8bbe\u5907\u7248\u672c\u8fc7\u4f4e";
                    string2 = "\u8bf7\u5347\u7ea7\u5927\u5c4f\u8bbe\u5907\u8f6f\u4ef6\u7248\u672c\u540e\u91cd\u8bd5";
                    break;
                }
                default: {
                    string = "\u670d\u52a1\u5f02\u5e38 " + n2;
                    string2 = "\u672a\u77e5\u9519\u8bef\n\u8bf7\u91cd\u542f\u5927\u5c4f\u548c\u624b\u673aapp\u540e\u91cd\u8bd5";
                }
            }
            SourceLog.i(TAG, "notifyError:" + string + "/" + string2);
            this.mController.notifyError(string, string2);
        }
    }

    private void showPWDDialog() {
        final EditText editText = new EditText(this.mContext);
        new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"\u8bf7\u8f93\u5165\u5bc6\u7801").setView((View)editText).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                if (TextUtils.isEmpty((CharSequence)editText.getText().toString())) {
                    Toast.makeText((Context)BrowserManager.this.mContext.getApplicationContext(), (CharSequence)"\u8bf7\u8f93\u5165\u5bc6\u7801", (int)1).show();
                    return;
                }
                BrowserManager.this.mPassword = editText.getText().toString();
                BrowserManager.this.startPlay(BrowserManager.this.mLastSelectInfo);
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", null).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BrowserManager getInstance() {
        Class<BrowserManager> clazz = BrowserManager.class;
        synchronized (BrowserManager.class) {
            if (sInstance == null) {
                sInstance = new BrowserManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void startBrowse() {
        this.startBrowse(this.useLelink, this.useDLNA, this.mContainer, this.isPush);
    }

    public void startBrowse(boolean bl, boolean bl2, ViewGroup viewGroup, boolean bl3) {
        this.isPush = bl3;
        this.useDLNA = bl2;
        this.useLelink = bl;
        this.mContext = viewGroup.getContext();
        if (this.mController != null) {
            this.mController.release();
            this.mController = null;
        }
        if (this.mContainer != null) {
            this.mContainer.removeAllViews();
            this.mContainer = null;
        }
        this.mContainer = viewGroup;
        if (!LelinkSourceSDK.getInstance().isBindSuccess()) {
            if (TextUtils.isEmpty((CharSequence)LelinkSourceSDK.getInstance().getAppID()) || TextUtils.isEmpty((CharSequence)LelinkSourceSDK.getInstance().getAppSecret())) {
                SourceLog.i(TAG, "startBrowse ignore, invalid init info");
                return;
            }
            LelinkSourceSDK.getInstance().setBindSdkListener(BrowserDevice.getInstance().getBindListener()).setBrowseResultListener(BrowserDevice.getInstance().getBrowseListener()).setConnectListener(BrowserDevice.getInstance().getConnectListener()).bindSdk();
            return;
        }
        SourceLog.i(TAG, "startBrowse useLelink:" + bl + ", useDlna:" + bl2);
        LelinkSourceSDK.getInstance().setBrowseResultListener(BrowserDevice.getInstance().getBrowseListener()).setConnectListener(BrowserDevice.getInstance().getConnectListener());
        this.mController = new BrowserController(viewGroup, this.isPush);
        this.mController.setServiceSelectListener(this.mSelectListener);
        this.mController.setCastListener(this.mCastListener);
        this.mController.browser();
    }

    private void startPlay(LelinkServiceInfo lelinkServiceInfo) {
        if (this.isPush) {
            this.startPush(lelinkServiceInfo);
        } else {
            this.startMirror(lelinkServiceInfo);
        }
    }

    private void startPush(final LelinkServiceInfo lelinkServiceInfo) {
        if (this.mCastListener == null) {
            SourceLog.i(TAG, "startPush ignore");
            return;
        }
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                EasyCastBean easyCastBean = BrowserManager.this.mCastListener.onCast(lelinkServiceInfo);
                if (easyCastBean == null) {
                    SourceLog.i(BrowserManager.TAG, "startPush ignore,invalid input");
                    return;
                }
                SourceLog.i(BrowserManager.TAG, "startPush");
                BrowserManager.this.mLastCastBean = easyCastBean;
                LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo();
                lelinkPlayerInfo.setUrl(easyCastBean.url);
                lelinkPlayerInfo.setType(easyCastBean.type);
                lelinkPlayerInfo.setStartPosition(easyCastBean.startPosition);
                if (!TextUtils.isEmpty((CharSequence)BrowserManager.this.mPassword)) {
                    lelinkPlayerInfo.setCastPwd(BrowserManager.this.mPassword);
                }
                lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
                LelinkSourceSDK.getInstance().setNewPlayListener(BrowserManager.this.mPlayerListener);
                LelinkSourceSDK.getInstance().startPlayMedia(lelinkPlayerInfo);
            }
        }, null);
    }

    private void startMirror(final LelinkServiceInfo lelinkServiceInfo) {
        if (this.mCastListener == null) {
            SourceLog.i(TAG, "startMirror ignore");
            return;
        }
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                EasyCastBean easyCastBean = BrowserManager.this.mCastListener.onCast(lelinkServiceInfo);
                if (easyCastBean == null) {
                    SourceLog.i(BrowserManager.TAG, "startMirror ignore,invalid input");
                    return;
                }
                SourceLog.i(BrowserManager.TAG, "startMirror ");
                BrowserManager.this.mLastCastBean = easyCastBean;
                LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo();
                lelinkPlayerInfo.setMirrorAudioEnable(easyCastBean.mirrorAudioEnable);
                lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
                LelinkSourceSDK.getInstance().setNewPlayListener(BrowserManager.this.mPlayerListener);
                LelinkSourceSDK.getInstance().startMirror(lelinkPlayerInfo);
            }
        }, null);
    }

    public void setEasyCastListener(IEasyCastListener iEasyCastListener) {
        SourceLog.i(TAG, "setEasyCastListener:" + iEasyCastListener);
        this.mCastListener = iEasyCastListener;
        if (this.mController != null) {
            this.mController.setCastListener(iEasyCastListener);
        }
    }

    public boolean isShowing() {
        return this.mController != null && this.mController.isShowing();
    }

    public void destroyView() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BrowserManager.this.mController != null) {
                    BrowserManager.this.mController.destroyView();
                }
                if (BrowserManager.this.isCastError && BrowserManager.this.mCastListener != null) {
                    BrowserManager.this.mCastListener.onCastError(BrowserManager.this.mLastSelectInfo, BrowserManager.this.mLastCastBean, BrowserManager.this.mErrorWhat, BrowserManager.this.mErrorExtra);
                }
            }
        });
    }

    private boolean checkSameCast(CastBean castBean, EasyCastBean easyCastBean) {
        if (castBean == null || easyCastBean == null) {
            SourceLog.w(TAG, "checkSameCast true, but invalid input");
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)castBean.url)) {
            return true;
        }
        return TextUtils.equals((CharSequence)castBean.url, (CharSequence)easyCastBean.url);
    }
}

