/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.easycast;

import android.text.TextUtils;
import com.hpplay.sdk.source.api.IBindSdkListener;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.api.IRelevantInfoListener;
import com.hpplay.sdk.source.api.LelinkSourceSDK;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.easycast.BrowserManager;
import com.hpplay.sdk.source.easycast.IEasyDeviceListener;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BrowserDevice {
    private static final String TAG = "BrowserDevice";
    private static BrowserDevice sInstance = null;
    private LelinkServiceInfo mSelectInfo;
    private IEasyDeviceListener mDeviceListener = null;
    private List<LelinkServiceInfo> mBrowseList;
    public static String DONGLE_APP_ID = "14255,16963";
    private boolean isBindSuccess = false;
    private IBindSdkListener mBindSdkListener = new IBindSdkListener(){

        @Override
        public void onBindCallback(boolean bl) {
            SourceLog.i(BrowserDevice.TAG, "onBindCallback " + bl);
            BrowserDevice.this.isBindSuccess = bl;
            BrowserDevice.this.setPassThroughListener();
            if (BrowserDevice.this.isBindSuccess) {
                BrowserManager.getInstance().startBrowse();
            }
        }
    };
    private IBrowseListener mBrowseListener = new IBrowseListener(){

        @Override
        public void onBrowse(int n, List<LelinkServiceInfo> list) {
            if (n == -1) {
                SourceLog.e(BrowserDevice.TAG, "\u6388\u6743\u5931\u8d25");
                if (BrowserDevice.this.mDeviceListener != null) {
                    BrowserDevice.this.mDeviceListener.onBrowserResult(-1);
                }
                return;
            }
            if (n == 2) {
                SourceLog.i(BrowserDevice.TAG, "\u641c\u7d22\u505c\u6b62");
                if (BrowserDevice.this.mDeviceListener != null) {
                    BrowserDevice.this.mDeviceListener.onBrowserResult(2);
                }
            } else if (n == 3) {
                SourceLog.i(BrowserDevice.TAG, "\u641c\u7d22\u8d85\u65f6");
                if (BrowserDevice.this.mDeviceListener != null) {
                    BrowserDevice.this.mDeviceListener.onBrowserResult(3);
                }
            }
            BrowserDevice.this.mBrowseList = BrowserDevice.this.serviceListSort(list);
            if (BrowserDevice.this.mDeviceListener != null) {
                BrowserDevice.this.mDeviceListener.onUpdateDevices(BrowserDevice.this.mBrowseList);
            }
        }
    };
    private IConnectListener mConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n) {
            SourceLog.i(BrowserDevice.TAG, "onConnect:" + lelinkServiceInfo.getName());
            String string = n == 1 ? "Lelink" : (n == 3 ? "DLNA" : (n == 4 ? "IM" : "\u534f\u8bae:" + n));
            SourceLog.i(BrowserDevice.TAG, string + "  " + lelinkServiceInfo.getName() + "\u8fde\u63a5\u6210\u529f");
            BrowserDevice.this.setSelectInfo(lelinkServiceInfo);
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n, int n2) {
            if (lelinkServiceInfo == null) {
                return;
            }
            SourceLog.i(BrowserDevice.TAG, "onDisconnect:" + lelinkServiceInfo.getName() + " disConnectType:" + n + " extra:" + n2);
            String string = null;
            if (n == 212012) {
                string = lelinkServiceInfo.getName() + "\u7b49\u5f85\u7528\u6237\u786e\u8ba4";
            } else if (n == 212000) {
                switch (n2) {
                    case 212013: {
                        string = lelinkServiceInfo.getName() + "\u8fde\u63a5\u88ab\u62d2\u7edd";
                        break;
                    }
                    case 212014: {
                        string = lelinkServiceInfo.getName() + "\u9632\u9a9a\u6270\u54cd\u5e94\u8d85\u65f6";
                        break;
                    }
                    case 212015: {
                        string = lelinkServiceInfo.getName() + "\u5df2\u88ab\u52a0\u5165\u6295\u5c4f\u9ed1\u540d\u5355";
                        break;
                    }
                    case 212018: {
                        string = lelinkServiceInfo.getName() + "\u4e0d\u5728\u7ebf";
                        break;
                    }
                    default: {
                        string = lelinkServiceInfo.getName() + "\u8fde\u63a5\u65ad\u5f00";
                        break;
                    }
                }
            } else if (n == 212010) {
                switch (n2) {
                    case 212018: {
                        string = lelinkServiceInfo.getName() + "\u4e0d\u5728\u7ebf";
                        break;
                    }
                    default: {
                        string = lelinkServiceInfo.getName() + "\u8fde\u63a5\u5931\u8d25";
                    }
                }
            }
            if (TextUtils.isEmpty(string)) {
                string = "onDisconnect " + n + "/" + n2;
            }
            SourceLog.i(BrowserDevice.TAG, string);
            if (BrowserDevice.this.mDeviceListener != null) {
                BrowserDevice.this.mDeviceListener.onDisconnect(lelinkServiceInfo, n, n2);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BrowserDevice getInstance() {
        Class<BrowserDevice> clazz = BrowserDevice.class;
        synchronized (BrowserDevice.class) {
            if (sInstance == null) {
                sInstance = new BrowserDevice();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BrowserDevice() {
    }

    private List<LelinkServiceInfo> serviceListSort(List<LelinkServiceInfo> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        list = this.filterLelink(list);
        list = this.filterDongle(list);
        return list;
    }

    private List<LelinkServiceInfo> filterDongle(List<LelinkServiceInfo> list) {
        try {
            Collections.sort(list, new Comparator<LelinkServiceInfo>(){

                @Override
                public int compare(LelinkServiceInfo lelinkServiceInfo, LelinkServiceInfo lelinkServiceInfo2) {
                    if (lelinkServiceInfo == null || lelinkServiceInfo2 == null) {
                        return 0;
                    }
                    if (BrowserDevice.isDongle(lelinkServiceInfo.getAppId() + "") && BrowserDevice.isDongle(lelinkServiceInfo2.getAppId() + "")) {
                        if (BrowserDevice.this.isSelectInfo(lelinkServiceInfo)) {
                            return -1;
                        }
                    } else {
                        if (BrowserDevice.isDongle(lelinkServiceInfo.getAppId() + "") && !BrowserDevice.isDongle(lelinkServiceInfo2.getAppId() + "")) {
                            return -1;
                        }
                        if (!BrowserDevice.isDongle(lelinkServiceInfo.getAppId() + "") && !BrowserDevice.isDongle(lelinkServiceInfo2.getAppId() + "") && BrowserDevice.this.isSelectInfo(lelinkServiceInfo)) {
                            return -1;
                        }
                    }
                    return 0;
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return list;
    }

    private List<LelinkServiceInfo> filterLelink(List<LelinkServiceInfo> list) {
        try {
            Collections.sort(list, new Comparator<LelinkServiceInfo>(){

                @Override
                public int compare(LelinkServiceInfo lelinkServiceInfo, LelinkServiceInfo lelinkServiceInfo2) {
                    if (lelinkServiceInfo == null || lelinkServiceInfo2 == null) {
                        return 0;
                    }
                    if (lelinkServiceInfo.getTypes().equalsIgnoreCase("Lelink") && !lelinkServiceInfo2.getTypes().equalsIgnoreCase("Lelink")) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return list;
    }

    public static boolean isDongle(String string) {
        String[] stringArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        for (String string2 : stringArray = DONGLE_APP_ID.split(",")) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectInfo(LelinkServiceInfo lelinkServiceInfo) {
        String string;
        if (lelinkServiceInfo == null || this.mSelectInfo == null) {
            return false;
        }
        String string2 = lelinkServiceInfo.getIp() + lelinkServiceInfo.getName() + lelinkServiceInfo.getUid();
        return TextUtils.equals((CharSequence)string2, (CharSequence)(string = this.mSelectInfo.getIp() + this.mSelectInfo.getName() + this.mSelectInfo.getUid()));
    }

    public void setSelectInfo(LelinkServiceInfo lelinkServiceInfo) {
        this.mSelectInfo = lelinkServiceInfo;
    }

    public void setDeviceListener(IEasyDeviceListener iEasyDeviceListener) {
        this.mDeviceListener = iEasyDeviceListener;
    }

    public LelinkServiceInfo getSelectInfo() {
        return this.mSelectInfo;
    }

    public IBindSdkListener getBindListener() {
        return this.mBindSdkListener;
    }

    public boolean isBindSuccess() {
        return this.isBindSuccess;
    }

    public IBrowseListener getBrowseListener() {
        return this.mBrowseListener;
    }

    public IConnectListener getConnectListener() {
        return this.mConnectListener;
    }

    public List<LelinkServiceInfo> getBrowseList() {
        return this.mBrowseList;
    }

    public void clearBrowseList() {
        try {
            if (this.mBrowseList != null) {
                this.mBrowseList.clear();
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void setPassThroughListener() {
        LelinkSourceSDK.getInstance().setPassThroughListener(new IRelevantInfoListener(){

            @Override
            public void onSendRelevantInfoResult(int n, String string) {
            }

            @Override
            public void onReverseInfoResult(int n, String string) {
                SourceLog.i(BrowserDevice.TAG, "onReverseInfoResult option = " + n + ", result = " + string);
            }
        });
    }
}

