/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.easycast;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import com.hpplay.sdk.source.api.ISearchBannerDataCallback;
import com.hpplay.sdk.source.api.LelinkSourceSDK;
import com.hpplay.sdk.source.browse.api.IServiceSelectListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browser.IBrowserUICallback;
import com.hpplay.sdk.source.browser.bean.LelinkServiceBean;
import com.hpplay.sdk.source.browser.util.DisplayMetricsUtil;
import com.hpplay.sdk.source.browser.view.BrowserDeviceView;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.easycast.BrowserDevice;
import com.hpplay.sdk.source.easycast.IEasyCastListener;
import com.hpplay.sdk.source.easycast.IEasyDeviceListener;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.ArrayList;
import java.util.List;

public class BrowserController {
    private static final String TAG = "BrowserController";
    private ViewGroup mContainerView = null;
    private BrowserDeviceView mBrowserView;
    private IServiceSelectListener mServiceSelectListener;
    private List<LelinkServiceInfo> mLelinkServiceInfoList;
    private List<LelinkServiceBean> mLelinkServiceBeanList;
    private IEasyCastListener mCastListener;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    public boolean isPush;
    private IBrowserUICallback mBusinessCallback = new IBrowserUICallback(){

        public void onDestroy() {
            SourceLog.i(BrowserController.TAG, "IBrowserUICallback onDestroy");
            BrowserController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BrowserController.this.destroyView();
                }
            });
        }

        public void onSelect(int n, LelinkServiceBean lelinkServiceBean) {
            try {
                for (LelinkServiceInfo lelinkServiceInfo : BrowserController.this.mLelinkServiceInfoList) {
                    if (!lelinkServiceInfo.getName().equals(lelinkServiceBean.getName())) continue;
                    SourceLog.i(BrowserController.TAG, "IBrowserUICallback onSelect position:" + n + ", info:" + lelinkServiceInfo);
                    BrowserController.this.mServiceSelectListener.onSelect(lelinkServiceInfo);
                    BrowserDevice.getInstance().setSelectInfo(lelinkServiceInfo);
                }
            }
            catch (Exception exception) {
                SourceLog.w(BrowserController.TAG, exception);
            }
        }

        public void onRefresh() {
            BrowserController.this.browser();
        }
    };
    private IEasyDeviceListener mListener = new IEasyDeviceListener(){

        @Override
        public synchronized void onUpdateDevices(List<LelinkServiceInfo> list) {
            if (BrowserController.this.mBrowserView != null) {
                BrowserController.this.mLelinkServiceInfoList = list;
                BrowserController.this.mLelinkServiceBeanList.clear();
                boolean bl = false;
                try {
                    for (LelinkServiceInfo lelinkServiceInfo : BrowserController.this.mLelinkServiceInfoList) {
                        try {
                            if (!BrowserController.this.isPush && !lelinkServiceInfo.getTypes().toLowerCase().contains("lelink")) {
                                SourceLog.i(BrowserController.TAG, "++++++++++++++++++++++" + lelinkServiceInfo.getName());
                                continue;
                            }
                            LelinkServiceBean lelinkServiceBean = new LelinkServiceBean();
                            lelinkServiceBean.setAppid(lelinkServiceInfo.getAppId());
                            lelinkServiceBean.setIp(lelinkServiceInfo.getIp());
                            lelinkServiceBean.setName(lelinkServiceInfo.getName());
                            lelinkServiceBean.setUid(lelinkServiceInfo.getUid());
                            if (!bl && BrowserDevice.getInstance().isSelectInfo(lelinkServiceInfo)) {
                                lelinkServiceBean.setSelectFlag(true);
                                bl = true;
                            }
                            BrowserController.this.mLelinkServiceBeanList.add(lelinkServiceBean);
                        }
                        catch (Exception exception) {
                            SourceLog.w(BrowserController.TAG, exception);
                        }
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(BrowserController.TAG, exception);
                }
                BrowserController.this.mBrowserView.updateBrowseAdapter(BrowserController.this.mLelinkServiceBeanList);
            }
        }

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo) {
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n, int n2) {
            String string = "\u7f51\u7edc\u5f02\u5e38";
            String string2 = "\u8bf7\u68c0\u67e5\n\u5927\u5c4f\u548c\u624b\u673a\u7aef\u7f51\u7edc\u540e\u91cd\u8bd5";
            BrowserController.this.notifyError(string, string2);
        }

        @Override
        public void onBrowserResult(int n) {
            if (BrowserController.this.mBrowserView != null) {
                BrowserController.this.mBrowserView.browserResult(n);
            }
        }
    };

    public BrowserController(ViewGroup viewGroup, boolean bl) {
        this.mContainerView = viewGroup;
        this.mLelinkServiceBeanList = new ArrayList<LelinkServiceBean>();
        this.isPush = bl;
        this.initView();
    }

    private void initView() {
        if (this.mContainerView == null) {
            SourceLog.w(TAG, "initView ignore,mContainerView is null");
            return;
        }
        if (this.mBrowserView != null && this.mBrowserView.getParent() != null) {
            SourceLog.w(TAG, "initView ignore, parent is not null");
            return;
        }
        Context context = this.mContainerView.getContext();
        DisplayMetricsUtil.updateScreenWidth((Context)context);
        this.mBrowserView = new BrowserDeviceView(context, Session.getInstance().getBannerData());
        this.mBrowserView.setBusinessCallback(this.mBusinessCallback);
        LelinkSourceSDK.getInstance().setSearchBannerDataCallback(new ISearchBannerDataCallback(){

            @Override
            public void onBannerData(final String string) {
                if (BrowserController.this.mBrowserView != null) {
                    SourceLog.i(BrowserController.TAG, "onBannerData");
                    BrowserController.this.mBrowserView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            BrowserController.this.mBrowserView.updateBannerData(string);
                        }
                    }, 0L);
                    Session.getInstance().setBannerData(string);
                }
            }
        });
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.mContainerView.addView((View)this.mBrowserView, layoutParams);
    }

    public void notifyError(String string, String string2) {
        if (this.mBrowserView != null) {
            this.mBrowserView.notifyError(string, string2);
        }
    }

    public void destroyView() {
        SourceLog.i(TAG, "destroyView mBrowserView:" + this.mBrowserView);
        if (this.mBrowserView == null) {
            return;
        }
        this.mBrowserView.release();
        if (this.mBrowserView.getParent() != null) {
            try {
                SourceLog.i(TAG, "destroyView parent:" + this.mBrowserView.getParent());
                ViewGroup viewGroup = (ViewGroup)this.mBrowserView.getParent();
                viewGroup.removeView((View)this.mBrowserView);
                if (this.mCastListener != null) {
                    this.mCastListener.onDismiss();
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        this.mBrowserView = null;
    }

    public void setServiceSelectListener(IServiceSelectListener iServiceSelectListener) {
        this.mServiceSelectListener = iServiceSelectListener;
    }

    public void setCastListener(IEasyCastListener iEasyCastListener) {
        this.mCastListener = iEasyCastListener;
    }

    public void browser() {
        BrowserDevice.getInstance().setDeviceListener(this.mListener);
        BrowserDevice.getInstance().clearBrowseList();
        LelinkSourceSDK.getInstance().startBrowse();
    }

    public boolean isShowing() {
        return this.mContainerView != null && this.mContainerView.getChildCount() > 0;
    }

    public void release() {
        this.destroyView();
        this.mHandler.removeCallbacksAndMessages(null);
    }
}

