/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.common.store;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.utils.ContextPath;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.bean.AuthRepeatInfoBean;
import com.hpplay.sdk.source.bean.DebugTimestampBean;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.LeboUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class Session {
    private static final String TAG = "Session";
    private static Session mInstance = null;
    private final Context mContext;
    public int serverPort = 0;
    public String serverProtocolVer = "";
    public String tid = "";
    private String token = "";
    @Deprecated
    public int scanTime = 60;
    public int mExpireTime;
    public String appKey;
    public String appSecret;
    public String appVersion;
    public String userID;
    public String oaID;
    public String mTUID;
    private String mUID;
    private String mHID;
    private long mRegTime;
    public boolean isAuthSuccess;
    public boolean isFirstBoot = true;
    public boolean isPreferLelink = false;
    public ContextPath mContextPath;
    public boolean isFilter501Version = true;
    public String department;
    public String jobNumber;
    private ILogCallback mLogCallback;
    private IDebugAVListener mDebugAVListener;
    private AuthRepeatInfoBean infoBean;
    private DebugTimestampBean mDebugBean;
    private boolean mDebugTimestamp = false;
    private String mBannerData = null;
    private boolean disableIM = false;
    private HashMap<String, String> mBrandMap = new HashMap();
    public static final String DEFAULT_M = "02:00:00:00:00:00";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSession(Context context) {
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (mInstance == null) {
                mInstance = new Session(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Session getInstance() {
        Application application;
        if (mInstance == null && (application = HapplayUtils.getApplication()) != null) {
            Session.initSession((Context)application);
        }
        return mInstance;
    }

    private Session(Context context) {
        this.mContext = context;
        try {
            this.mContextPath = ContextPath.getInstance((Context)context, (int)2, (String)(Feature.isZTEChannel() ? "smartcast" : ""));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void initManufacture() {
        try {
            if (this.mBrandMap.size() == 0) {
                String string;
                InputStream inputStream = this.mContext.getAssets().open("lelink_config");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string).append(",");
                }
                String[] stringArray = stringBuilder.toString().split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    if ((i + 1) % 2 != 0 || i + 1 >= stringArray.length) continue;
                    this.mBrandMap.put(stringArray[i], stringArray[i - 1]);
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public String getBrand(String string) {
        if (this.mBrandMap.containsKey(string)) {
            return this.mBrandMap.get(string);
        }
        return "unknown";
    }

    public void updateRepeatInfo(AuthRepeatInfoBean authRepeatInfoBean) {
        this.infoBean = authRepeatInfoBean;
        this.updateUID();
        this.updateHID();
    }

    public String getUID() {
        if (TextUtils.isEmpty((CharSequence)this.mUID)) {
            this.updateUID();
        }
        return this.mUID;
    }

    public void updateUID() {
        if (this.infoBean != null && !TextUtils.isEmpty((CharSequence)this.infoBean.getUid())) {
            this.mUID = this.infoBean.getUid();
            SourceLog.i(TAG, "updateUID use server uid " + this.mUID);
        } else {
            this.mUID = String.valueOf(LeboUtil.getCUid64(this.mContext));
            SourceLog.i(TAG, "updateUID use local uid " + this.mUID);
        }
    }

    public String getHID() {
        if (TextUtils.isEmpty((CharSequence)this.mHID)) {
            this.updateHID();
        }
        return this.mHID;
    }

    public void updateHID() {
        if (this.infoBean != null && !TextUtils.isEmpty((CharSequence)this.infoBean.getHid())) {
            this.mHID = this.infoBean.getHid();
            SourceLog.i(TAG, "updateHID use server hid " + this.mHID);
        } else {
            this.mHID = LeboUtil.getNewSourceHID(this.mContext);
            SourceLog.i(TAG, "updateHID create new hid " + this.mHID);
        }
    }

    public long getRegTime() {
        if (this.infoBean != null) {
            this.mRegTime = this.infoBean.getRegTime();
        }
        return this.mRegTime;
    }

    public void setRegTime(long l) {
        this.mRegTime = l;
    }

    public ILogCallback getLogCallback() {
        return this.mLogCallback;
    }

    public void setLogCallback(ILogCallback iLogCallback) {
        this.mLogCallback = iLogCallback;
    }

    public IDebugAVListener getDebugAVListener() {
        return this.mDebugAVListener;
    }

    public void setDebugAVListener(IDebugAVListener iDebugAVListener) {
        this.mDebugAVListener = iDebugAVListener;
    }

    public void setDebugTimestamp(boolean bl) {
        this.mDebugTimestamp = bl;
    }

    public boolean getDebugTimestamp() {
        return this.mDebugTimestamp;
    }

    public void setDebugTimestampBean(DebugTimestampBean debugTimestampBean) {
        this.mDebugBean = debugTimestampBean;
    }

    public DebugTimestampBean getDebugTimestampBean() {
        return this.mDebugBean;
    }

    public ContextPath getContextPath() {
        if (this.mContextPath == null) {
            try {
                this.mContextPath = ContextPath.getInstance((Context)this.mContext.getApplicationContext(), (int)2, (String)(Feature.isZTEChannel() ? "smartcast" : ""));
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        return this.mContextPath;
    }

    public String getToken() {
        if (TextUtils.isEmpty((CharSequence)this.token)) {
            SourceLog.w(TAG, "invalid token");
        }
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public String getBannerData() {
        if (TextUtils.isEmpty((CharSequence)this.mBannerData)) {
            SourceLog.w(TAG, "invalid mBannerData");
        }
        return this.mBannerData;
    }

    public void setBannerData(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "invalid mBannerData");
        }
        this.mBannerData = string;
    }

    public void disableIM(boolean bl) {
        this.disableIM = bl;
    }

    public boolean isDisableIM() {
        return this.disableIM;
    }
}

