/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.common.store;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;

public class Preference {
    private static final String TAG = "Preference";
    public static final String KEY_SDK_VERIFY_SUCCESSFUL = "sdk_verify_successful";
    public static final String KEY_SDK_VERIFY = "sdk_verify";
    public static final String KEY_SDK_SERVER_LIST = "sdk_server_list";
    public static final String KEY_SDK_SWITCH = "sdk_switch";
    public static final String KEY_REPEAT_INFO = "repeat_info";
    public static final String KEY_SDK_AUTH_URL = "key_sdk_auth_url";
    public static final String KEY_SDK_AUTH_TIME = "key_sdk_auth_time";
    public static final String KEY_SDK_AUTH_DISABLE = "key_sdk_auth_disable";
    public static final String KEY_LOG_DIR = "key_log_dir";
    public static final String KEY_ENABLE_LOG = "key_enable_log";
    public static final String KEY_DEVICE_ID = "key_device_id";
    public static final String KEY_SDK_CONFIG = "key_sdk_config";
    public static final String KEY_MULTI_CHANNEL = "key_multi_channel";
    public static final String KEY_LB_FAKE_AID = "key_lb_ai";
    public static final String KEY_DA_CONNECT_TIMEOUT = "da_connect_timeout";
    public static final String KEY_DA_RETRY_COUNT = "da_retry_count";
    public static final String KEY_MIRROR_WATERMARK_OBJ_JSON_STR = "mirror_watermark_obj_json_str";
    public static final String KEY_MIRROR_WATERMARK_SWITCH = "mirror_watermark_switch";
    public static final String KEY_MIRROR_SECRET_SWITCH = "mirror_secret_switch";
    public static final String KEY_LICENSE_TSN = "key_license_tsn";
    public static final String KEY_LICENSE = "key_lcs_data";
    public static final String KEY_PERMISSION_MODE = "key_permission_mode";
    public static final String KEY_AUTH_FAIL_TIME = "auth_fail_time";
    public static final String KEY_SDK_LOGIN_TIME = "key_sdk_login_time";
    public static final String KEY_ENCODE_ERROR_EXIT_MIRROR = "key_encode_error_exit_mirror";
    public static final String KEY_MIRROR_FPS = "key_mirror_fps";
    private static Preference mPreference;
    private SharedPreferences mPref;
    @Deprecated
    private static final String KEY_IMSERVER_IP = "ImServer";
    @Deprecated
    private static final String KEY_LOGOIN_PARAMS = "key_login_params";
    @Deprecated
    private static final String KEY_LOGOIN_PARAMS_TIME = "key_login_params_time";
    @Deprecated
    private static final String KEY_SERVER_UID = "server_uid";
    @Deprecated
    private static final String KEY_SERVER_HID = "server_hid";
    @Deprecated
    private static final String KEY_SWITCH_VER = "switch_ver";
    @Deprecated
    private static final String KEY_LOCAL_SERVICE_CONFIG = "key_local_service_config";

    private Preference(Context context) {
        this.mPref = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.mPref.edit().remove(KEY_IMSERVER_IP).apply();
        this.mPref.edit().remove(KEY_LOGOIN_PARAMS).apply();
        this.mPref.edit().remove(KEY_LOGOIN_PARAMS_TIME).apply();
        this.mPref.edit().remove(KEY_SERVER_UID).apply();
        this.mPref.edit().remove(KEY_SERVER_HID).apply();
        this.mPref.edit().remove(KEY_SWITCH_VER).apply();
        this.mPref.edit().remove(KEY_LOCAL_SERVICE_CONFIG).apply();
    }

    public static synchronized Preference getInstance() {
        if (mPreference == null) {
            Preference.initPreference((Context)HapplayUtils.getApplication());
        }
        return mPreference;
    }

    public static Preference initPreference(Context context) {
        SourceLog.i(TAG, "Preference initPreference");
        if (mPreference == null) {
            mPreference = new Preference(context);
        }
        return mPreference;
    }

    public boolean get(String string, boolean bl) {
        return this.mPref.getBoolean(string, bl);
    }

    public int get(String string, int n) {
        return this.mPref.getInt(string, n);
    }

    public float get(String string, float f) {
        return this.mPref.getFloat(string, f);
    }

    public long get(String string, long l) {
        return this.mPref.getLong(string, l);
    }

    public String get(String string) {
        return this.get(string, null);
    }

    public String get(String string, String string2) {
        return this.mPref.getString(string, string2);
    }

    public void put(String string, boolean bl) {
        this.mPref.edit().putBoolean(string, bl).apply();
    }

    public void put(String string, int n) {
        this.mPref.edit().putInt(string, n).apply();
    }

    public void put(String string, float f) {
        this.mPref.edit().putFloat(string, f).apply();
    }

    public void put(String string, long l) {
        this.mPref.edit().putLong(string, l).apply();
    }

    public void put(String string, String string2) {
        this.mPref.edit().putString(string, string2).apply();
    }
}

