/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.hpplay.sdk.source.log.SourceLog;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public class DramaInfoBean
implements Parcelable {
    private static final String TAG = "DramaInfoBean";
    public static final String CATEGORY_STD = "std";
    public static final String CATEGORY_HIGH = "high";
    public static final String CATEGORY_SUPER = "super";
    public static final String SET_PLAY_LIST = "set-playlist";
    public static final String APPEND_PLAY_LIST = "append-playlist";
    public static final String CLEAR_PLAY_LIST = "clear-playlist";
    public String name;
    public UrlBean[] urls;
    public static final Parcelable.Creator<DramaInfoBean> CREATOR = new Parcelable.Creator<DramaInfoBean>(){

        public DramaInfoBean createFromParcel(Parcel parcel) {
            return new DramaInfoBean(parcel);
        }

        public DramaInfoBean[] newArray(int n) {
            return new DramaInfoBean[n];
        }
    };

    public DramaInfoBean() {
    }

    private DramaInfoBean(Parcel parcel) {
        this.name = parcel.readString();
        Parcelable[] parcelableArray = parcel.readParcelableArray(UrlBean.class.getClassLoader());
        if (parcelableArray != null) {
            this.urls = new UrlBean[parcelableArray.length];
            for (int i = 0; i < parcelableArray.length; ++i) {
                this.urls[i] = (UrlBean)parcelableArray[i];
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.name);
        parcel.writeParcelableArray((Parcelable[])this.urls, n);
    }

    public static DramaInfoBean formJSON(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            DramaInfoBean dramaInfoBean = new DramaInfoBean();
            dramaInfoBean.name = URLDecoder.decode(jSONObject.optString("name"), "utf-8");
            JSONArray jSONArray = jSONObject.optJSONArray("urls");
            if (jSONArray != null) {
                dramaInfoBean.urls = new UrlBean[jSONArray.length()];
                for (int i = 0; i < jSONArray.length(); ++i) {
                    UrlBean urlBean;
                    JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                    dramaInfoBean.urls[i] = urlBean = UrlBean.formJSON(jSONObject2);
                }
            }
            return dramaInfoBean;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public JSONObject toJson() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", (Object)URLEncoder.encode(this.name, "utf-8"));
            JSONArray jSONArray = new JSONArray();
            if (this.urls != null) {
                for (UrlBean urlBean : this.urls) {
                    jSONArray.put((Object)urlBean.toJSON());
                }
            }
            jSONObject.put("urls", (Object)jSONArray);
            return jSONObject;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static class UrlBean
    implements Parcelable {
        public String id;
        public String url;
        public String category;
        public int width;
        public int height;
        public static final Parcelable.Creator<UrlBean> CREATOR = new Parcelable.Creator<UrlBean>(){

            public UrlBean createFromParcel(Parcel parcel) {
                return new UrlBean(parcel);
            }

            public UrlBean[] newArray(int n) {
                return new UrlBean[n];
            }
        };

        public UrlBean() {
        }

        private UrlBean(Parcel parcel) {
            this.id = parcel.readString();
            this.url = parcel.readString();
            this.category = parcel.readString();
            this.width = parcel.readInt();
            this.height = parcel.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.id);
            parcel.writeString(this.url);
            parcel.writeString(this.category);
            parcel.writeInt(this.width);
            parcel.writeInt(this.height);
        }

        public static UrlBean formJSON(JSONObject jSONObject) {
            UrlBean urlBean = new UrlBean();
            urlBean.id = jSONObject.optString("id");
            urlBean.url = jSONObject.optString("url");
            urlBean.category = jSONObject.optString("category");
            urlBean.width = jSONObject.optInt("width");
            urlBean.height = jSONObject.optInt("height");
            return urlBean;
        }

        public String toJSON() {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", (Object)this.id);
                jSONObject.put("url", (Object)this.url);
                jSONObject.put("category", (Object)this.category);
                jSONObject.put("width", this.width);
                jSONObject.put("height", this.height);
                return jSONObject.toString();
            }
            catch (Exception exception) {
                SourceLog.w(DramaInfoBean.TAG, exception);
                return null;
            }
        }
    }
}

