/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import org.json.JSONObject;

public class DanmakuBean
implements Parcelable {
    private static final String TAG = "DanmakuBean";
    private String content;
    private String fontColor;
    private long displayTime;
    private int fontSize;
    private int columSpace;
    private boolean immShow;
    public static final Parcelable.Creator<DanmakuBean> CREATOR = new Parcelable.Creator<DanmakuBean>(){

        public DanmakuBean createFromParcel(Parcel parcel) {
            return new DanmakuBean(parcel);
        }

        public DanmakuBean[] newArray(int n) {
            return new DanmakuBean[n];
        }
    };

    public void setContent(String string) {
        try {
            this.content = URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SourceLog.w(TAG, unsupportedEncodingException);
        }
    }

    public void setDisplayTime(long l) {
        this.displayTime = l;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public void setFontColor(String string) {
        this.fontColor = string;
    }

    public void setColumSpace(int n) {
        this.columSpace = n;
    }

    public void setImmShow(boolean bl) {
        this.immShow = bl;
    }

    public String toJson(String string, int n) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", n);
            jSONObject.put("danmukuId", (Object)UUID.randomUUID().toString());
            jSONObject.put("content", (Object)this.content);
            jSONObject.put("displayTime", this.displayTime);
            jSONObject.put("fontSize", this.fontSize);
            jSONObject.put("fontColor", (Object)this.fontColor);
            jSONObject.put("columSpace", this.columSpace);
            jSONObject.put("immShow", this.immShow);
            jSONObject.put("uri", (Object)string);
            SourceLog.i(TAG, jSONObject.toString());
            return jSONObject.toString();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.content);
        parcel.writeString(this.fontColor);
        parcel.writeLong(this.displayTime);
        parcel.writeInt(this.fontSize);
        parcel.writeInt(this.columSpace);
        parcel.writeByte(this.immShow ? (byte)1 : 0);
    }

    public DanmakuBean() {
    }

    protected DanmakuBean(Parcel parcel) {
        this.content = parcel.readString();
        this.fontColor = parcel.readString();
        this.displayTime = parcel.readLong();
        this.fontSize = parcel.readInt();
        this.columSpace = parcel.readInt();
        this.immShow = parcel.readByte() != 0;
    }
}

