/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.api;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.api.CommonDispatcher;
import com.hpplay.sdk.source.api.IBindSdkListener;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.ILelinkSourceSDK;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.api.IMirrorChangeListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.IRelevantInfoListener;
import com.hpplay.sdk.source.api.ISearchBannerDataCallback;
import com.hpplay.sdk.source.api.ISendPassCallback;
import com.hpplay.sdk.source.api.ISinkKeyEventListener;
import com.hpplay.sdk.source.api.ISinkTouchEventListener;
import com.hpplay.sdk.source.api.LelinkAccessibilityService;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.BrowserConfigBean;
import com.hpplay.sdk.source.bean.DanmakuBean;
import com.hpplay.sdk.source.bean.DanmakuPropertyBean;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.ShortMediaBean;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.bean.WatermarkBean;
import com.hpplay.sdk.source.browse.api.DeprecatedParceResultListenerWrapper;
import com.hpplay.sdk.source.browse.api.IAPICallbackListener;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IParceResultListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.easycast.BrowserManager;
import com.hpplay.sdk.source.easycast.IEasyCastListener;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.proxy.ModuleLoader;
import com.hpplay.sdk.source.transceiver.SourceTransceiver;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class LelinkSourceSDK {
    private static final String TAG = "LelinkSourceSDK";
    private static final String PROCESS_NAME = "lelinkps";
    public static final int MEDIA_TYPE_VIDEO = 102;
    public static final int MEDIA_TYPE_AUDIO = 101;
    public static final int MEDIA_TYPE_IMAGE = 103;
    public static final int MEDIA_TYPE_MICRO_APP = 105;
    public static final int RESOLUTION_HIGH = 1;
    public static final int RESOLUTION_MIDDLE = 2;
    public static final int RESOLUTION_AUTO = 3;
    public static final int BITRATE_HIGH = 4;
    public static final int BITRATE_MIDDLE = 5;
    public static final int BITRATE_LOW = 6;
    public static final int MIRROR_LOADING = 1;
    public static final int VIDEO_LOADING = 2;
    public static final int MUSIC_LOADING = 3;
    public static final int PICTURE_LOADING = 4;
    public static final int MIRROR_PLAYING = 5;
    public static final int VIDEO_PLAYING = 6;
    public static final int MUSIC_PLAYING = 7;
    public static final int PICTURE_PLAYING = 8;
    public static final int VIDEO_PAUSE = 9;
    public static final int MUSIC_PAUSE = 10;
    public static final int MIRROR_PAUSE = 11;
    public static final int PLAY_STOPPED = 0;
    public static final float PLAYBACK_SPEED1 = 0.5f;
    public static final float PLAYBACK_SPEED2 = 0.75f;
    public static final float PLAYBACK_SPEED3 = 1.0f;
    public static final float PLAYBACK_SPEED4 = 1.25f;
    public static final float PLAYBACK_SPEED5 = 1.5f;
    public static final float PLAYBACK_SPEED6 = 2.0f;
    public static final int KEY_GET_UID = 1;
    public static final int KEY_GET_HID = 2;
    public static final int EXTERNAL_VIDEO_H264 = 1;
    public static final int EXTERNAL_VIDEO_RGB = 2;
    public static final int EXTERNAL_AUDIO_PCM = 1;
    public static final int CREATE_TYPE_LOCAL_CACHE = 7;
    public static String PROTOCOL_ANDLINK = "Andlink";
    public static final int AUDIO_SAMPLERATE_16K = 16000;
    public static final int AUDIO_SAMPLERATE_44K = 44100;
    public static final int AUDIO_SAMPLERATE_48K = 48000;
    public static final int AUDIO_CHANNEL_IN_MONO = 1;
    public static final int AUDIO_CHANNEL_IN_STEREO = 2;
    public static final String FEEDBACK_PUSH_UNSMOOTH = "1001";
    public static final String FEEDBACK_PUSH_BLACK = "1002";
    public static final String FEEDBACK_PUSH_PLAY_FAILED = "1003";
    public static final String FEEDBACK_PUSH_FLASH_BACK = "1004";
    public static final String FEEDBACK_PUSH_SCALE = "1005";
    public static final String FEEDBACK_PUSH_LOAD_FAILED = "1006";
    public static final String FEEDBACK_PUSH_AV_ASYNC = "1007";
    public static final String FEEDBACK_PUSH_OTHER = "1008";
    public static final String FEEDBACK_PUSH_CONTROL_ERROR = "1009";
    public static final String FEEDBACK_MIRROR_BLACK = "2001";
    public static final String FEEDBACK_MIRROR_FLASH_BACK = "2002";
    public static final String FEEDBACK_MIRROR_BLURRED = "2003";
    public static final String FEEDBACK_MIRROR_UNSMOOTH = "2004";
    public static final String FEEDBACK_MIRROR_AV_ASYNC = "2005";
    public static final String FEEDBACK_MIRROR_SCALE = "2006";
    public static final String FEEDBACK_MIRROR_NOT_CHANGE_ORIENTATION = "2007";
    public static final String FEEDBACK_MIRROR_OTHER = "2008";
    public static final String FEEDBACK_MIRROR_PLAY_FAILED = "2009";
    public static final String FEEDBACK_CONNECT_FAILED = "4001";
    private Context mContext;
    private String mAppid;
    private String mAppSecret;
    private String mUserId;
    private String mAppVersion;
    private String mOaid;
    private static LelinkSourceSDK mLelinkSDKController;
    private ILelinkSourceSDK mILelinkSourceSdk;
    private ILelinkPlayerListener mPlayerListener;
    private INewPlayerListener mNewPlayerListener;
    private IDaPlayerListener mDaPlayerListener;
    private IBrowseListener mIBrowseListener;
    private IConnectListener mConnectListener;
    private IBindSdkListener mAppBindSdkListener;
    private boolean isBindSuccess = false;
    private IBindSdkListener mBindSdkListener = new IBindSdkListener(){

        @Override
        public void onBindCallback(boolean bl) {
            LelinkSourceSDK.this.isBindSuccess = bl;
            if (LelinkSourceSDK.this.mAppBindSdkListener != null) {
                LelinkSourceSDK.this.mAppBindSdkListener.onBindCallback(bl);
            }
            if (LelinkSourceSDK.this.mCallBrowseType == 1) {
                LelinkSourceSDK.this.startBrowse(LelinkSourceSDK.this.useLelink, LelinkSourceSDK.this.useDlna);
            } else if (LelinkSourceSDK.this.mCallBrowseType == 2 && LelinkSourceSDK.this.mBrowseConfigBean != null) {
                LelinkSourceSDK.this.startBrowse(LelinkSourceSDK.this.mBrowseConfigBean);
            }
        }
    };
    private ILogCallback mLogCallback;
    private IDebugAVListener mDebugAVListener;
    private ISinkKeyEventListener mSinkKeyEventListener;
    private ISendPassCallback mPassCallback;
    private boolean isChildProcessBind = false;
    private int mCallBrowseType = -1;
    private boolean useLelink = true;
    private boolean useDlna = true;
    private BrowserConfigBean mBrowseConfigBean = null;
    private CommonDispatcher mListenerDispatcher = new CommonDispatcher();
    private SourceTransceiver mTransceiver;
    @Deprecated
    public static final int PLAY_STOPED = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LelinkSourceSDK getInstance() {
        Class<LelinkSourceSDK> clazz = LelinkSourceSDK.class;
        synchronized (LelinkSourceSDK.class) {
            if (mLelinkSDKController == null) {
                mLelinkSDKController = new LelinkSourceSDK();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mLelinkSDKController;
        }
    }

    private LelinkSourceSDK() {
    }

    public LelinkSourceSDK setSdkInitInfo(Context context, String string, String string2) {
        this.mContext = context;
        this.mAppid = string;
        this.mAppSecret = string2;
        return this;
    }

    public LelinkSourceSDK setSdkInitInfo(Context context, String string, String string2, String string3) {
        this.mContext = context;
        this.mAppid = string;
        this.mAppSecret = string2;
        this.mOaid = string3;
        return this;
    }

    public LelinkSourceSDK setSdkInitInfo(Context context, String string, String string2, String string3, String string4, String string5) {
        this.mContext = context;
        this.mAppid = string;
        this.mAppSecret = string2;
        this.mUserId = string3;
        this.mAppVersion = string4;
        this.mOaid = string5;
        return this;
    }

    public String getAppID() {
        return this.mAppid;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public void bindOfChildProcess() {
        this.isChildProcessBind = true;
        this.bindSdk();
    }

    public void bindSdk() {
        this.bindSdk(this.mContext, this.mAppid, this.mAppSecret, this.mUserId, this.mAppVersion, this.mOaid, this.mAppBindSdkListener);
    }

    public void bindSdk(Context context, String string, String string2, IBindSdkListener iBindSdkListener) {
        this.bindSdk(context, string, string2, null, null, null, iBindSdkListener);
    }

    public void bindSdk(Context context, String string, String string2, String string3, IBindSdkListener iBindSdkListener) {
        this.bindSdk(context, string, string2, null, null, string3, iBindSdkListener);
    }

    public LelinkSourceSDK setDebugMode(boolean bl) {
        try {
            SourceLog.i(TAG, "setDebugMode," + bl);
            this.mILelinkSourceSdk.setDebugMode(bl);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return this;
    }

    public LelinkSourceSDK setDebugTimestamp(boolean bl) {
        try {
            this.mILelinkSourceSdk.setDebugTimestamp(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this;
    }

    public void bindSdk(Context context, String string, String string2, String string3, String string4, String string5, IBindSdkListener iBindSdkListener) {
        this.mAppBindSdkListener = iBindSdkListener;
        if (this.isBindSuccess) {
            SourceLog.i(TAG, "bindSdk ignore, already binded");
            if (this.mAppBindSdkListener != null) {
                this.mAppBindSdkListener.onBindCallback(this.isBindSuccess);
            }
            return;
        }
        try {
            SourceLog.i(TAG, "start bind sdk");
            if (LelinkSourceSDK.isMyApp(context) || this.isChildProcessBind) {
                this.mILelinkSourceSdk = ModuleLoader.loadSourceSDKImpl();
                this.mILelinkSourceSdk.bindSdk(context, string, string2, string3, string4, string5, this.mBindSdkListener);
                if (this.mIBrowseListener != null) {
                    this.mILelinkSourceSdk.setBrowseResultListener(this.mIBrowseListener);
                }
                if (this.mConnectListener != null) {
                    this.mILelinkSourceSdk.setConnectListener(this.mConnectListener);
                }
                if (this.mPlayerListener != null) {
                    this.mILelinkSourceSdk.setPlayListener(this.mPlayerListener);
                }
                if (this.mNewPlayerListener != null) {
                    this.mILelinkSourceSdk.setNewPlayListener(this.mNewPlayerListener);
                }
                if (this.mDaPlayerListener != null) {
                    this.mILelinkSourceSdk.setDaPlayListener(this.mDaPlayerListener);
                }
                if (this.mDebugAVListener != null) {
                    this.mILelinkSourceSdk.setDebugAVListener(this.mDebugAVListener);
                }
                if (this.mSinkKeyEventListener != null) {
                    this.mILelinkSourceSdk.setSinkKeyEventListener(this.mSinkKeyEventListener);
                }
                if (this.mPassCallback != null) {
                    this.mILelinkSourceSdk.setSendPassCallback(this.mPassCallback);
                }
                this.mILelinkSourceSdk.setCommonListener(this.mListenerDispatcher);
            } else {
                SourceLog.i(TAG, "is process sdk");
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public boolean isBindSuccess() {
        return this.isBindSuccess;
    }

    public void unBindSdk() {
        SourceLog.w(TAG, "unBindSdk");
        try {
            this.mILelinkSourceSdk.unBindSdk();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.isBindSuccess = false;
        this.mCallBrowseType = -1;
    }

    public static boolean isMyApp(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != Process.myPid() || !runningAppProcessInfo.processName.equals(context.getPackageName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    public LelinkSourceSDK setBrowseResultListener(IBrowseListener iBrowseListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setBrowseResultListener(iBrowseListener);
        } else {
            this.mIBrowseListener = iBrowseListener;
        }
        return this;
    }

    public LelinkSourceSDK setDebugAVListener(IDebugAVListener iDebugAVListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setDebugAVListener(iDebugAVListener);
        } else {
            this.mDebugAVListener = iDebugAVListener;
        }
        return this;
    }

    public LelinkSourceSDK setConnectListener(IConnectListener iConnectListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setConnectListener(iConnectListener);
        } else {
            this.mConnectListener = iConnectListener;
        }
        return this;
    }

    public LelinkSourceSDK setPlayListener(ILelinkPlayerListener iLelinkPlayerListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setPlayListener(iLelinkPlayerListener);
        } else {
            this.mPlayerListener = iLelinkPlayerListener;
        }
        return this;
    }

    public LelinkSourceSDK setNewPlayListener(INewPlayerListener iNewPlayerListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setNewPlayListener(iNewPlayerListener);
        } else {
            this.mNewPlayerListener = iNewPlayerListener;
        }
        return this;
    }

    public LelinkSourceSDK setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setDaPlayListener(iDaPlayerListener);
        } else {
            this.mDaPlayerListener = iDaPlayerListener;
        }
        return this;
    }

    public LelinkSourceSDK setBindSdkListener(IBindSdkListener iBindSdkListener) {
        this.mAppBindSdkListener = iBindSdkListener;
        return this;
    }

    public int easyPush(ViewGroup viewGroup) {
        if (!a.j()) {
            return -1;
        }
        BrowserManager.getInstance().startBrowse(true, true, viewGroup, true);
        return 0;
    }

    public int easyMirror(ViewGroup viewGroup) {
        if (!a.j()) {
            return -1;
        }
        BrowserManager.getInstance().startBrowse(true, true, viewGroup, false);
        return 0;
    }

    public int setEasyCastListener(IEasyCastListener iEasyCastListener) {
        if (!a.j()) {
            return -1;
        }
        BrowserManager.getInstance().setEasyCastListener(iEasyCastListener);
        return 0;
    }

    public boolean isBrowseShowing() {
        if (!a.j()) {
            return false;
        }
        return BrowserManager.getInstance().isShowing();
    }

    public int dismissBrowserUI() {
        if (!a.j()) {
            return -1;
        }
        BrowserManager.getInstance().destroyView();
        return 0;
    }

    public void startBrowse() {
        this.startBrowse(true, true);
    }

    public void startBrowse(boolean bl, boolean bl2) {
        if (!this.isBindSuccess) {
            SourceLog.w(TAG, "startBrowse ignore,waiting bind callback");
            this.mCallBrowseType = 1;
            this.useLelink = bl;
            this.useDlna = bl2;
            return;
        }
        this.mCallBrowseType = -1;
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startBrowse(bl, bl2);
        }
    }

    public void startBrowse(BrowserConfigBean browserConfigBean) {
        if (!this.isBindSuccess) {
            SourceLog.w(TAG, "startBrowse ignore,waiting bind callback");
            this.mCallBrowseType = 2;
            this.mBrowseConfigBean = browserConfigBean;
            return;
        }
        if (this.mILelinkSourceSdk == null || browserConfigBean == null) {
            return;
        }
        this.mCallBrowseType = -1;
        this.mILelinkSourceSdk.setOption(0x200002, browserConfigBean.toJSON());
    }

    public void stopBrowse() {
        this.mCallBrowseType = -1;
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.stopBrowse();
        }
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.connect(lelinkServiceInfo);
        }
    }

    public boolean disconnect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.disconnect(lelinkServiceInfo);
        }
        return false;
    }

    public List<LelinkServiceInfo> getConnectInfos() {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.getConnectInfos();
        }
        return null;
    }

    @Deprecated
    public void startMirror(LelinkServiceInfo lelinkServiceInfo, boolean bl, boolean bl2) {
        LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo();
        lelinkPlayerInfo.setMirrorAudioEnable(bl);
        lelinkPlayerInfo.setAutoBitrate(bl2);
        lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
        this.startMirror(lelinkPlayerInfo);
    }

    public void startMirror(LelinkPlayerInfo lelinkPlayerInfo) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startMirror(lelinkPlayerInfo);
        } else {
            SourceLog.w(TAG, "startMirror ignore");
        }
    }

    public void resume() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.resume();
        }
    }

    public void pause() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.pause();
        }
    }

    public boolean isSupportPlayList(LelinkServiceInfo lelinkServiceInfo) {
        Object object = this.getOption(0x200008, lelinkServiceInfo);
        if (object == null || TextUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public boolean isSupportTrack(LelinkServiceInfo lelinkServiceInfo) {
        Object object = this.getOption(2097177, lelinkServiceInfo);
        if (object == null || TextUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public void playDrama(String string) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(0x200009, string);
        }
    }

    public void playNextDrama() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(0x2000010, new Object[0]);
        }
    }

    public void playPreDrama() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(0x2000011, new Object[0]);
        }
    }

    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n, int n2, int n3) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.appendPlayList(dramaInfoBeanArray, n, n2, n3);
        }
    }

    public void clearPlayList() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.clearPlayList();
        }
    }

    public void addVolume() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.addVolume();
        }
    }

    public void subVolume() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.subVolume();
        }
    }

    public void seekTo(int n) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.seekTo(n);
        }
    }

    public void startPlayMedia(String string, int n, boolean bl) {
        SourceLog.i(TAG, "startPlayMedia path:" + string);
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startPlayMedia(string, n, bl);
        }
    }

    public void startPlayMedia(LelinkPlayerInfo lelinkPlayerInfo) {
        SourceLog.i(TAG, "startPlayMedia path:" + lelinkPlayerInfo.getUrl());
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startPlayMedia(lelinkPlayerInfo);
        }
    }

    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, String string, int n, boolean bl) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startPlayMediaImmed(lelinkServiceInfo, string, n, bl);
        }
    }

    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, Uri uri, int n) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.startPlayMediaImmed(lelinkServiceInfo, uri, n);
        }
    }

    public void stopPlay() {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.stopPlay();
        }
    }

    public void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.createPinCode(iCreatePinCodeListener);
        }
    }

    public void createShortUrl(ICreateShortUrlListener iCreateShortUrlListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.createShortUrl(iCreateShortUrlListener);
        }
    }

    public void addQRCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.addQRCodeToLelinkServiceInfo(string, iServiceInfoParseListener);
        }
    }

    public void addPinCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.addPinCodeToLelinkServiceInfo(string, iServiceInfoParseListener);
        }
    }

    public void createLelinkSeviceInfo(SinkParameterBean sinkParameterBean, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.createLelinkServiceInfo(sinkParameterBean, iServiceInfoParseListener);
        }
    }

    public boolean canPlayScreen(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.canPlayScreen(lelinkServiceInfo);
        }
        return false;
    }

    public boolean canPlayLocalMedia(LelinkServiceInfo lelinkServiceInfo) {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.canPlayLocalMedia(lelinkServiceInfo);
        }
        return false;
    }

    public LelinkSourceSDK enableExternalAudio() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x100061, true);
        }
        return this;
    }

    public LelinkSourceSDK disableExternalAudio() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x100061, false);
        }
        return this;
    }

    public LelinkSourceSDK enableExternalVideo() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x200001, true);
        }
        return this;
    }

    public LelinkSourceSDK disableExternalVideo() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x200001, false);
        }
        return this;
    }

    public LelinkSourceSDK updateVideoData(byte[] byArray, VideoFrameBean videoFrameBean) {
        if (this.mILelinkSourceSdk == null || videoFrameBean == null) {
            return this;
        }
        this.mILelinkSourceSdk.updateVideoData(byArray, videoFrameBean);
        return this;
    }

    public LelinkSourceSDK updateAudioData(byte[] byArray, AudioFrameBean audioFrameBean) {
        if (this.mILelinkSourceSdk == null || audioFrameBean == null) {
            return this;
        }
        this.mILelinkSourceSdk.updateAudioData(byArray, audioFrameBean);
        return this;
    }

    public LelinkSourceSDK updatePCMData(int n, int n2, int n3, byte[] byArray, int n4, int n5) {
        if (this.mILelinkSourceSdk != null) {
            AudioFrameBean audioFrameBean = new AudioFrameBean();
            audioFrameBean.sampleRate = n;
            audioFrameBean.channel = n2;
            audioFrameBean.audioFormat = n3;
            audioFrameBean.offset = n4;
            audioFrameBean.length = n5;
            this.mILelinkSourceSdk.updateAudioData(byArray, audioFrameBean);
        }
        return this;
    }

    public void registerSinkKeyEvent() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x100066, true);
        }
    }

    public void unregisterSinkKeyEvent() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x100066, false);
        }
    }

    public void setSinkKeyEventListener(ISinkKeyEventListener iSinkKeyEventListener) {
        this.mSinkKeyEventListener = iSinkKeyEventListener;
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setSinkKeyEventListener(iSinkKeyEventListener);
        }
    }

    public void setSendPassCallback(ISendPassCallback iSendPassCallback) {
        this.mPassCallback = iSendPassCallback;
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setSendPassCallback(iSendPassCallback);
        }
    }

    public void registerSinkTouchEvent() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(1048679, true);
        }
    }

    public void unregisterSinkTouchEvent() {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(1048679, false);
        }
    }

    public void setSinkTouchEventListener(SinkTouchEventArea sinkTouchEventArea, float f, ISinkTouchEventListener iSinkTouchEventListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setSinkTouchEventListener(sinkTouchEventArea, f, iSinkTouchEventListener);
        }
    }

    public void setSinkTouchEventListener(ISinkTouchEventListener iSinkTouchEventListener) {
        this.setSinkTouchEventListener(null, 0.0f, iSinkTouchEventListener);
    }

    public void setSinkTouchEventListener(SinkTouchEventArea sinkTouchEventArea, ISinkTouchEventListener iSinkTouchEventListener) {
        this.setSinkTouchEventListener(sinkTouchEventArea, 0.0f, iSinkTouchEventListener);
    }

    public void setSinkTouchEventListener(float f, ISinkTouchEventListener iSinkTouchEventListener) {
        this.setSinkTouchEventListener(null, f, iSinkTouchEventListener);
    }

    public String getSDKInfos(int n) {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.getSDKInfos(n);
        }
        return "";
    }

    public LelinkSourceSDK setLogCallback(ILogCallback iLogCallback) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setLogCallback(iLogCallback);
        }
        return this;
    }

    public void setSearchBannerDataCallback(ISearchBannerDataCallback iSearchBannerDataCallback) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setSearchBannerDataCallback(iSearchBannerDataCallback);
        }
    }

    public void sendDanmaku(DanmakuBean danmakuBean) {
        if (null == danmakuBean) {
            return;
        }
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(1048675, danmakuBean);
        }
    }

    public void sendDanmakuProperty(DanmakuPropertyBean danmakuPropertyBean) {
        if (null == danmakuPropertyBean) {
            return;
        }
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(1048676, danmakuPropertyBean);
        }
    }

    public boolean isSupportDanmaku(LelinkServiceInfo lelinkServiceInfo) {
        return this.checkForOption(1048675, lelinkServiceInfo);
    }

    public boolean isSupportQueryRate(LelinkServiceInfo lelinkServiceInfo) {
        return this.checkForOption(1048631, lelinkServiceInfo);
    }

    public boolean isSupportRate(LelinkServiceInfo lelinkServiceInfo) {
        return this.checkForOption(1048629, lelinkServiceInfo);
    }

    public boolean isSupportTempRestrict(LelinkServiceInfo lelinkServiceInfo) {
        return this.checkForOption(2097175, lelinkServiceInfo);
    }

    private boolean checkForOption(int n, LelinkServiceInfo lelinkServiceInfo) {
        if (null == lelinkServiceInfo) {
            return false;
        }
        if (this.mILelinkSourceSdk != null) {
            Object object = this.mILelinkSourceSdk.getOption(n, lelinkServiceInfo);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        return false;
    }

    public void setRate(float f) {
        if (f == 0.5f || f == 0.75f || f == 1.0f || f == 1.25f || f == 1.5f || f == 2.0f) {
            this.setOption(1048629, Float.valueOf(f));
        } else {
            SourceLog.i(TAG, "Invalid rate value");
        }
    }

    public void queryRate() {
        this.setOption(1048631, new Object[0]);
    }

    public void enableLogCache(boolean bl) {
        this.setOption(1048649, bl);
    }

    public void uploadLog(String string, String string2) {
        this.setOption(1048659, string, string2);
    }

    public String getLogDir() {
        Object object = LelinkSourceSDK.getInstance().getOption(0x200003, new Object[0]);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public void setCacheList(List<ShortMediaBean> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (ShortMediaBean shortMediaBean : list) {
            JSONObject jSONObject = ShortMediaBean.toJSON(shortMediaBean);
            if (jSONObject == null) continue;
            jSONArray.put((Object)jSONObject);
        }
        this.setOption(1048680, jSONArray.toString());
    }

    public void startOnlineCheck(IAPICallbackListener iAPICallbackListener, List<LelinkServiceInfo> list) {
        if (iAPICallbackListener == null || list == null || list.isEmpty()) {
            SourceLog.w(TAG, "startOnlineCheck ignore, invalid input");
            return;
        }
        this.setOption(65539, iAPICallbackListener, list);
    }

    public void setPassThroughListener(IRelevantInfoListener iRelevantInfoListener) {
        this.setOption(0x120002, iRelevantInfoListener);
    }

    public void enableMultiChannel(boolean bl) {
        this.setOption(0x200004, bl ? "1" : "0");
    }

    public boolean isSupportMultiChannel(LelinkServiceInfo lelinkServiceInfo) {
        Object object = this.getOption(0x200007, lelinkServiceInfo);
        if (object == null || TextUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public boolean isSupportReverseControl(LelinkServiceInfo lelinkServiceInfo) {
        Object object = this.getOption(2097173, lelinkServiceInfo);
        if (object == null || TextUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public void switchMirror(int n) {
        this.setOption(0x200005, n);
    }

    public void setMirrorRotation(int n, boolean bl) {
        this.setOption(0x200030, n, bl);
    }

    public void setMirrorChangeListener(IMirrorChangeListener iMirrorChangeListener) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setMirrorChangeListener(iMirrorChangeListener);
        }
    }

    public void setOverlayPermission(int n) {
        this.setOption(0x200012, "" + n);
    }

    public void selectTrack(int n) {
        this.setOption(2097174, "" + n);
    }

    public void enableTempRestrict(boolean bl) {
        this.setOption(2097175, bl);
    }

    public void disableCloudCast(boolean bl) {
        this.setOption(0x200020, bl);
    }

    public void enableMirrorNotification(boolean bl) {
        this.setOption(2097176, bl);
    }

    public void setMirrorNotificationType(int n) {
        this.setOption(0x200032, n);
    }

    public void setWatermarkInfo(WatermarkBean watermarkBean) {
        if (this.mILelinkSourceSdk != null) {
            this.setOption(0x200021, watermarkBean.toJson());
        }
    }

    public void setWatermarkVisible(boolean bl) {
        this.setOption(0x200022, bl);
    }

    public void setMirrorScreenSecret(boolean bl) {
        this.setOption(0x200028, bl);
    }

    public CommonDispatcher getListenerDispatcher() {
        return this.mListenerDispatcher;
    }

    public boolean isAccessibilityServiceStart(Context context) {
        return LelinkAccessibilityService.isServiceStart(context);
    }

    public synchronized SourceTransceiver getTransceiver() {
        if (this.mTransceiver == null) {
            this.mTransceiver = new SourceTransceiver();
        }
        return this.mTransceiver;
    }

    public void setPermissionMode(int n, String string) {
        this.setOption(0x200027, n, string);
    }

    public boolean isMirroring() {
        Object object = this.getOption(0x200029, new Object[0]);
        if (object == null || TextUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public void setOption(int n, Object ... objectArray) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setOption(n, objectArray);
        }
    }

    public Object getOption(int n, Object ... objectArray) {
        if (this.mILelinkSourceSdk != null) {
            Object object = this.mILelinkSourceSdk.getOption(n, objectArray);
            if (n == 1048626 && object == null) {
                object = 0;
            }
            return object;
        }
        return null;
    }

    public VirtualDisplay getVirtualDisplay() {
        if (this.mILelinkSourceSdk != null) {
            return this.mILelinkSourceSdk.getVirtualDisplay();
        }
        return null;
    }

    @Deprecated
    public boolean disConnect(LelinkServiceInfo lelinkServiceInfo) {
        return this.disconnect(lelinkServiceInfo);
    }

    @Deprecated
    public void setVolume(int n) {
        if (this.mILelinkSourceSdk != null) {
            this.mILelinkSourceSdk.setVolume(n);
        }
    }

    @Deprecated
    public void addQRCodeToLelinkServiceInfo(String string, IParceResultListener iParceResultListener) {
        this.addQRCodeToLelinkServiceInfo(string, new DeprecatedParceResultListenerWrapper(iParceResultListener));
    }

    @Deprecated
    public void addPinCodeToLelinkServiceInfo(String string, IParceResultListener iParceResultListener) {
        this.addPinCodeToLelinkServiceInfo(string, new DeprecatedParceResultListenerWrapper(iParceResultListener));
    }

    @Deprecated
    public void addNfcTagToLelinkServiceInfo(Intent intent, IParceResultListener iParceResultListener) {
    }

    @Deprecated
    public void addNfcTagToLelinkServiceInfo(Intent intent, IServiceInfoParseListener iServiceInfoParseListener) {
    }

    @Deprecated
    public boolean writeDeviceDataToNfcCard(Intent intent, String string) {
        return false;
    }
}

