/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.api;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.hpplay.sdk.source.bean.DanmakuBean;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.MediaAssetBean;
import com.hpplay.sdk.source.bean.MicroAppInfoBean;
import com.hpplay.sdk.source.bean.PlayerInfoBean;
import com.hpplay.sdk.source.browse.api.IAPI;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.ArrayList;

public class LelinkPlayerInfo
implements Parcelable,
IAPI {
    private static final String TAG = "LelinkPlayerInfo";
    public static final int TYPE_URL = 1;
    public static final int TYPE_MIRROR = 2;
    public static final int TYPE_SCREEN = 100;
    public static final int TYPE_AUDIO = 101;
    public static final int TYPE_VIDEO = 102;
    public static final int TYPE_IMAGE = 103;
    public static final int TYPE_MICRO_APP = 105;
    public static final int LOOP_MODE_UNDEFINED = -1;
    public static final int LOOP_MODE_DEFAULT = 0;
    public static final int LOOP_MODE_SINGLE = 1;
    public static final int MONITOR_START = 1;
    public static final int MONITOR_STOP = 2;
    public static final int MONITOR_PAUSE = 3;
    public static final int MONITOR_RESUME = 4;
    public static final int FULLSCREEN_AUTO = 0;
    public static final int FULLSCREEN_ON = 1;
    public static final int FULLSCREEN_OFF = 2;
    public static final int CAPTURE_AUDIO_CLOSE = 0;
    public static final int CAPTURE_AUDIO_OPEN = 1;
    public static final int CAPTURE_AUDIO_AUTO = 2;
    public static final int CAPTURE_AUDIO_APP = 3;
    public static final int CAPTURE_AUDIO_ASUS_ALL = 4;
    private LelinkServiceInfo mLelinkServiceInfo;
    private DanmakuBean danmukuInfo;
    private String url;
    private String localPath;
    private Uri uri;
    private String params;
    private int startPosition;
    private int type;
    private int resolutionLevel = -1;
    private int bitRateLevel = -1;
    private int mirrorAudioType = 0;
    private boolean requestAudioFocus = true;
    private String screenCode;
    private boolean isZoom = true;
    private String screenShotPath;
    private MediaAssetBean mediaAssetBean;
    private SparseArray<Object> mMonitors;
    private PlayerInfoBean playerInfoBean;
    private int fullScreenType;
    private boolean isAutoBitrate = false;
    private boolean mirrorInner = true;
    private boolean retryDLNAHttp = true;
    private ArrayList<LelinkServiceInfo> subMirrorInfos = new ArrayList();
    private Intent intent;
    private int mirrorSendTimeout;
    private MicroAppInfoBean microAppInfoBean;
    private DramaInfoBean[] urlList;
    private String dramaID;
    private int period;
    private int headDuration;
    private int tailDuration;
    public static final Parcelable.Creator<LelinkPlayerInfo> CREATOR = new Parcelable.Creator<LelinkPlayerInfo>(){

        public LelinkPlayerInfo createFromParcel(Parcel parcel) {
            LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo(parcel);
            int n = parcel.readInt();
            if (n > 0) {
                ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
                for (int i = 0; i < n; ++i) {
                    LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)parcel.readParcelable(LelinkServiceInfo.class.getClassLoader());
                    arrayList.add(lelinkServiceInfo);
                }
                lelinkPlayerInfo.subMirrorInfos = arrayList;
            }
            return lelinkPlayerInfo;
        }

        public LelinkPlayerInfo[] newArray(int n) {
            return new LelinkPlayerInfo[n];
        }
    };
    @Deprecated
    private boolean isUseCurrentConnection = false;
    @Deprecated
    private boolean isShowExternalScreenMirror = false;
    @Deprecated
    private boolean useRealResolution;

    public LelinkPlayerInfo() {
        this.playerInfoBean = new PlayerInfoBean();
        this.playerInfoBean.getAesBean().setMode(1);
    }

    public int getResolutionLevel() {
        return this.resolutionLevel;
    }

    public void setResolutionLevel(int n) {
        this.resolutionLevel = n;
    }

    public int getBitRateLevel() {
        return this.bitRateLevel;
    }

    public void setBitRateLevel(int n) {
        this.bitRateLevel = n;
    }

    @Deprecated
    public boolean isMirrorAudioEnable() {
        return this.mirrorAudioType != 0;
    }

    @Deprecated
    public void setMirrorAudioEnable(boolean bl) {
        this.mirrorAudioType = bl ? 1 : 0;
    }

    public int getMirrorAudioType() {
        return this.mirrorAudioType;
    }

    public void setMirrorAudioType(int n) {
        if (n == 4) {
            this.mirrorAudioType = n;
            return;
        }
        if (n == 3 && Build.VERSION.SDK_INT < 29) {
            SourceLog.w(TAG, "setMirrorAudioType ignore");
            return;
        }
        this.mirrorAudioType = n;
    }

    public boolean isRequestAudioFocus() {
        return this.requestAudioFocus;
    }

    public void setRequestAudioFocus(boolean bl) {
        this.requestAudioFocus = bl;
    }

    public LelinkServiceInfo getLelinkServiceInfo() {
        return this.mLelinkServiceInfo;
    }

    public void setLelinkServiceInfo(LelinkServiceInfo lelinkServiceInfo) {
        this.mLelinkServiceInfo = lelinkServiceInfo;
    }

    public DanmakuBean getDanmukuInfo() {
        return this.danmukuInfo;
    }

    public void setDanmukuInfo(DanmakuBean danmakuBean) {
        this.danmukuInfo = danmakuBean;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public void setParams(String string) {
        this.params = string;
    }

    public String getParams() {
        return this.params;
    }

    public String getUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            return this.url;
        }
        if (this.urlList == null || this.urlList.length <= 0) {
            return null;
        }
        for (DramaInfoBean dramaInfoBean : this.urlList) {
            if (dramaInfoBean.urls == null || dramaInfoBean.urls.length <= 0) continue;
            for (DramaInfoBean.UrlBean urlBean : dramaInfoBean.urls) {
                if (!TextUtils.equals((CharSequence)this.dramaID, (CharSequence)urlBean.id)) continue;
                return urlBean.url;
            }
        }
        return null;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    public int getMirrorSendTimeout() {
        return this.mirrorSendTimeout;
    }

    public void setMirrorSendTimeout(int n) {
        this.mirrorSendTimeout = n;
    }

    public MediaAssetBean getMediaAsset() {
        return this.mediaAssetBean;
    }

    public void setMediaAsset(MediaAssetBean mediaAssetBean) {
        this.mediaAssetBean = mediaAssetBean;
    }

    public String getHeader() {
        return this.playerInfoBean.getHeader();
    }

    public void setHeader(String string) {
        this.playerInfoBean.setHeader(string);
    }

    public int getLoopMode() {
        return this.playerInfoBean.getLoopMode();
    }

    public void setLoopMode(int n) {
        this.playerInfoBean.setLoopMode(n);
    }

    public void setAesKey(String string) {
        this.playerInfoBean.getAesBean().setKey(string);
    }

    public void setAesIv(String string) {
        this.playerInfoBean.getAesBean().setIv(string);
    }

    public PlayerInfoBean getPlayInfoBean() {
        return this.playerInfoBean;
    }

    public void setFullScreen(int n) {
        this.fullScreenType = n;
    }

    public void setFullScreen(boolean bl) {
        this.fullScreenType = bl ? 1 : 2;
    }

    public int getFullScreen() {
        return this.fullScreenType;
    }

    public void setCastPwd(String string) {
        this.screenCode = string;
    }

    public String getCastPwd() {
        return this.screenCode;
    }

    public void setAutoBitrate(boolean bl) {
        this.isAutoBitrate = bl;
    }

    public boolean isAutoBitrate() {
        return this.isAutoBitrate;
    }

    public Uri getLocalUri() {
        return this.uri;
    }

    public void setLocalUri(Uri uri) {
        this.uri = uri;
    }

    public void clearActivityTaskWhenStartMirror(boolean bl) {
        this.mirrorInner = !bl;
    }

    public boolean isClearActivityTaskWhenStartMirror() {
        return !this.mirrorInner;
    }

    public void setPlayList(DramaInfoBean[] dramaInfoBeanArray, String string, int n, int n2, int n3) {
        this.urlList = dramaInfoBeanArray;
        this.dramaID = string;
        this.period = n;
        this.headDuration = n2;
        this.tailDuration = n3;
    }

    public String getDramaID() {
        try {
            if (TextUtils.isEmpty((CharSequence)this.dramaID) && this.urlList != null && this.urlList.length > 0) {
                this.dramaID = this.urlList[0].urls[0].id;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "getDramaID :" + exception);
        }
        return this.dramaID;
    }

    public DramaInfoBean[] getUrlList() {
        return this.urlList;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getHeadDuration() {
        return this.headDuration;
    }

    public int getTailDuration() {
        return this.tailDuration;
    }

    public MicroAppInfoBean getMicroAppInfoBean() {
        return this.microAppInfoBean;
    }

    public void setMicroAppInfoBean(MicroAppInfoBean microAppInfoBean) {
        this.microAppInfoBean = microAppInfoBean;
    }

    public SparseArray<Object> getMonitors() {
        return this.mMonitors;
    }

    public boolean isRetryDLNAHttp() {
        return this.retryDLNAHttp;
    }

    public void setRetryDLNAHttp(boolean bl) {
        this.retryDLNAHttp = bl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.mLelinkServiceInfo, n);
        parcel.writeParcelable((Parcelable)this.danmukuInfo, n);
        parcel.writeString(this.url);
        parcel.writeString(this.dramaID);
        parcel.writeInt(this.period);
        parcel.writeInt(this.headDuration);
        parcel.writeInt(this.tailDuration);
        parcel.writeParcelableArray((Parcelable[])this.urlList, n);
        parcel.writeString(this.localPath);
        parcel.writeString(this.params);
        parcel.writeInt(this.startPosition);
        parcel.writeInt(this.type);
        parcel.writeInt(this.resolutionLevel);
        parcel.writeInt(this.bitRateLevel);
        parcel.writeInt(this.mirrorAudioType);
        parcel.writeByte(this.requestAudioFocus ? (byte)1 : 0);
        parcel.writeString(this.screenCode);
        parcel.writeByte(this.isZoom ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.mediaAssetBean, n);
        parcel.writeSparseArray(this.mMonitors);
        parcel.writeParcelable((Parcelable)this.playerInfoBean, n);
        parcel.writeInt(this.fullScreenType);
        parcel.writeByte(this.isUseCurrentConnection ? (byte)1 : 0);
        parcel.writeString(this.screenShotPath);
        parcel.writeByte(this.isAutoBitrate ? (byte)1 : 0);
        parcel.writeByte(this.isShowExternalScreenMirror ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.uri, n);
        parcel.writeByte(this.mirrorInner ? (byte)1 : 0);
        parcel.writeByte(this.useRealResolution ? (byte)1 : 0);
        parcel.writeByte(this.retryDLNAHttp ? (byte)1 : 0);
        parcel.writeInt(this.mirrorSendTimeout);
        parcel.writeParcelable((Parcelable)this.microAppInfoBean, n);
        if (this.subMirrorInfos.size() > 0) {
            parcel.writeInt(this.subMirrorInfos.size());
            for (LelinkServiceInfo lelinkServiceInfo : this.subMirrorInfos) {
                parcel.writeParcelable((Parcelable)lelinkServiceInfo, n);
            }
        } else {
            parcel.writeInt(0);
        }
    }

    protected LelinkPlayerInfo(Parcel parcel) {
        try {
            this.mLelinkServiceInfo = (LelinkServiceInfo)parcel.readParcelable(LelinkServiceInfo.class.getClassLoader());
            this.danmukuInfo = (DanmakuBean)parcel.readParcelable(DramaInfoBean.class.getClassLoader());
            this.url = parcel.readString();
            this.dramaID = parcel.readString();
            this.period = parcel.readInt();
            this.headDuration = parcel.readInt();
            this.tailDuration = parcel.readInt();
            Parcelable[] parcelableArray = parcel.readParcelableArray(DramaInfoBean.class.getClassLoader());
            if (parcelableArray != null && parcelableArray.length > 0) {
                this.urlList = new DramaInfoBean[parcelableArray.length];
                for (int i = 0; i < parcelableArray.length; ++i) {
                    this.urlList[i] = (DramaInfoBean)parcelableArray[i];
                }
            }
            this.localPath = parcel.readString();
            this.params = parcel.readString();
            this.startPosition = parcel.readInt();
            this.type = parcel.readInt();
            this.resolutionLevel = parcel.readInt();
            this.bitRateLevel = parcel.readInt();
            this.mirrorAudioType = parcel.readInt();
            this.requestAudioFocus = parcel.readByte() != 0;
            this.screenCode = parcel.readString();
            this.isZoom = parcel.readByte() != 0;
            this.mediaAssetBean = (MediaAssetBean)parcel.readParcelable(MediaAssetBean.class.getClassLoader());
            this.mMonitors = parcel.readSparseArray(Object.class.getClassLoader());
            this.playerInfoBean = (PlayerInfoBean)parcel.readParcelable(PlayerInfoBean.class.getClassLoader());
            this.fullScreenType = parcel.readInt();
            this.isUseCurrentConnection = parcel.readByte() != 0;
            this.screenShotPath = parcel.readString();
            this.isAutoBitrate = parcel.readByte() != 0;
            this.isShowExternalScreenMirror = parcel.readByte() != 0;
            this.uri = (Uri)parcel.readParcelable(Uri.class.getClassLoader());
            this.mirrorInner = parcel.readByte() != 0;
            this.useRealResolution = parcel.readByte() != 0;
            this.retryDLNAHttp = parcel.readByte() != 0;
            this.mirrorSendTimeout = parcel.readInt();
            this.microAppInfoBean = (MicroAppInfoBean)parcel.readParcelable(MicroAppInfoBean.class.getClassLoader());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    @Deprecated
    public Object getOption(int n, Object ... objectArray) {
        switch (n) {
            case 65542: {
                return this.screenCode;
            }
            case 0x100010: {
                return this.fullScreenType;
            }
            case 0x100018: {
                return this.isZoom;
            }
            case 0x100019: {
                return this.screenShotPath;
            }
            case 0x100022: {
                return this.isUseCurrentConnection;
            }
            case 0x100030: {
                return this.isShowExternalScreenMirror;
            }
            case 0x100031: {
                return this.isAutoBitrate;
            }
            case 1048632: {
                return this.mirrorInner;
            }
            case 1048658: {
                return this.useRealResolution;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Object setOption(int n, Object ... objectArray) {
        try {
            switch (n) {
                case 65542: {
                    if (objectArray == null || objectArray[0] == null) break;
                    this.screenCode = objectArray[0].toString();
                    break;
                }
                case 0x100010: {
                    if (objectArray[0] instanceof Boolean) {
                        this.fullScreenType = (Boolean)objectArray[0] != false ? 1 : 2;
                        break;
                    }
                    this.fullScreenType = (Integer)objectArray[0];
                    break;
                }
                case 0x100018: {
                    this.isZoom = (Boolean)objectArray[0];
                    break;
                }
                case 0x100019: {
                    this.screenShotPath = (String)objectArray[0];
                    break;
                }
                case 0x100022: {
                    this.isUseCurrentConnection = (Boolean)objectArray[0];
                    break;
                }
                case 0x100030: {
                    this.isShowExternalScreenMirror = (Boolean)objectArray[0];
                    break;
                }
                case 0x100031: {
                    this.isAutoBitrate = (Boolean)objectArray[0];
                    break;
                }
                case 1048632: {
                    this.mirrorInner = (Boolean)objectArray[0];
                    break;
                }
                case 1048658: {
                    this.useRealResolution = (Boolean)objectArray[0];
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return null;
    }

    @Deprecated
    public void setSubMirrorInfos(LelinkServiceInfo ... lelinkServiceInfoArray) {
        if (lelinkServiceInfoArray != null) {
            for (int i = 0; i < lelinkServiceInfoArray.length; ++i) {
                this.subMirrorInfos.add(lelinkServiceInfoArray[0]);
            }
        }
    }

    @Deprecated
    public ArrayList<LelinkServiceInfo> getSubMirrorInfos() {
        return this.subMirrorInfos;
    }

    @Deprecated
    public Uri getLoaclUri() {
        return this.uri;
    }

    @Deprecated
    public void setLoaclUri(Uri uri) {
        this.uri = uri;
    }
}

