/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.api;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.GestureDescription;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Path;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.sdk.source.bean.PathEventInfo;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.List;

@SuppressLint(value={"LongLogTag"})
public class LelinkAccessibilityService
extends AccessibilityService {
    private static final String TAG = "LelinkAccessibilityService";
    private static volatile String mForegroundPackageName = "";
    static Handler handler;
    public static LelinkAccessibilityService lelinkAccessibilityService;
    private int mScreenWidth;
    private int mScreenHeight;

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        try {
            if (lelinkAccessibilityService == null) {
                lelinkAccessibilityService = this;
            }
            if (accessibilityEvent.getEventType() == 32 && !TextUtils.isEmpty((CharSequence)accessibilityEvent.getPackageName())) {
                mForegroundPackageName = accessibilityEvent.getPackageName() + "";
            }
            if (this.mScreenWidth == 0) {
                this.mScreenWidth = ScreenUtil.getRelScreenSize((Context)this.getApplicationContext())[0];
                this.mScreenHeight = ScreenUtil.getRelScreenSize((Context)this.getApplicationContext())[1];
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        SourceLog.i(TAG, "onServiceConnected: ");
    }

    public boolean onUnbind(Intent intent) {
        SourceLog.i(TAG, "onUnbind: ");
        return super.onUnbind(intent);
    }

    public static boolean isForeground(Context context) {
        if (TextUtils.isEmpty((CharSequence)mForegroundPackageName)) {
            return false;
        }
        String string = context.getApplicationContext().getPackageName();
        return mForegroundPackageName.equals(string);
    }

    public static boolean isServiceStart(Context context) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        List list = accessibilityManager.getEnabledAccessibilityServiceList(-1);
        for (AccessibilityServiceInfo accessibilityServiceInfo : list) {
            if (accessibilityServiceInfo.getId() == null || !accessibilityServiceInfo.getId().contains(LelinkAccessibilityService.class.getName()) || !accessibilityServiceInfo.getId().contains(context.getPackageName())) continue;
            return true;
        }
        mForegroundPackageName = "";
        return false;
    }

    public static void startMove() {
        handler.sendEmptyMessageDelayed(0, 4000L);
    }

    public void clickOnScreen(float f, float f2, int n, AccessibilityService.GestureResultCallback gestureResultCallback) {
        Path path = new Path();
        path.moveTo(f, f2);
        this.gestureOnScreen(path, 0L, n, gestureResultCallback);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        SourceLog.i(TAG, "onConfigurationChanged orientation:" + configuration.orientation);
        int n = ScreenUtil.getRelScreenSize((Context)this.getApplicationContext())[0];
        int n2 = ScreenUtil.getRelScreenSize((Context)this.getApplicationContext())[1];
        if (configuration.orientation == 2) {
            this.mScreenWidth = n > n2 ? n : n2;
            this.mScreenHeight = n > n2 ? n2 : n;
        } else {
            this.mScreenWidth = n > n2 ? n2 : n;
            this.mScreenHeight = n > n2 ? n : n2;
        }
    }

    public void moveOnScreen(PathEventInfo pathEventInfo, AccessibilityService.GestureResultCallback gestureResultCallback) {
        SourceLog.i(TAG, "moveOnScreen pathEventInfo.getStartRatioX():" + pathEventInfo.getStartRatioX() + ",pathEventInfo.getStartRatioY():" + pathEventInfo.getStartRatioY() + ",pathEventInfo.getTargetRatioX():" + pathEventInfo.getTargetRatioX() + ",pathEventInfo.getTargetRatioY():" + pathEventInfo.getTargetRatioY() + ",mScreenWidth:" + this.mScreenWidth + ",mScreenHeight:" + this.mScreenHeight);
        Path path = new Path();
        float f = pathEventInfo.getStartRatioX() * (float)this.mScreenWidth;
        float f2 = pathEventInfo.getStartRatioY() * (float)this.mScreenHeight;
        float f3 = pathEventInfo.getTargetRatioX() * (float)this.mScreenWidth;
        float f4 = pathEventInfo.getTargetRatioY() * (float)this.mScreenHeight;
        SourceLog.i(TAG, "moveOnScreen startX:" + f + "  startY:" + f2 + "   targetX " + f3 + " targetY  " + f4);
        path.moveTo(f, f2);
        path.lineTo(f3, f4);
        this.gestureOnScreen(path, 0L, (long)pathEventInfo.getDuration(), gestureResultCallback);
    }

    protected void gestureOnScreen(Path path, long l, long l2, AccessibilityService.GestureResultCallback gestureResultCallback) {
        GestureDescription.Builder builder = null;
        if (Build.VERSION.SDK_INT >= 24) {
            builder = new GestureDescription.Builder();
            builder.addStroke(new GestureDescription.StrokeDescription(path, l, l2));
            GestureDescription gestureDescription = builder.build();
            this.dispatchGesture(gestureDescription, gestureResultCallback, null);
        }
    }

    public void onInterrupt() {
        SourceLog.i(TAG, "onInterrupt");
    }
}

