/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.api;

import com.hpplay.sdk.source.api.ICommonListener;
import com.hpplay.sdk.source.api.LelinkSourceSDK;
import com.hpplay.sdk.source.bean.CommonResultBean;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.transceiver.IRemoteServerListener;
import com.hpplay.sdk.source.transceiver.ISinkNotifyMirrorListener;
import com.hpplay.sdk.source.transceiver.bean.NotifyMirrorBean;
import org.json.JSONObject;

public class CommonDispatcher
implements ICommonListener {
    private static final String TAG = "CommonDispatcher";
    private ISinkNotifyMirrorListener mSinkNotifyMirrorListener;
    private IRemoteServerListener mRemoteServerListener;

    public void setSinkNotifyMirrorListener(ISinkNotifyMirrorListener iSinkNotifyMirrorListener) {
        this.mSinkNotifyMirrorListener = null;
    }

    public void setRemoteSeverListener(IRemoteServerListener iRemoteServerListener) {
        this.mRemoteServerListener = iRemoteServerListener;
        if (iRemoteServerListener == null) {
            LelinkSourceSDK.getInstance().setOption(0x200024, 2);
        } else {
            LelinkSourceSDK.getInstance().setOption(0x200023, 2);
        }
    }

    @Override
    public CommonResultBean onCallback(int n, int n2, String string) {
        switch (n) {
            case 1: {
                return this.dispatchSinkNotifyMirror(n2, string);
            }
            case 2: {
                return this.dispatchRemoteServer(n2, string);
            }
        }
        return null;
    }

    private CommonResultBean dispatchSinkNotifyMirror(int n, String string) {
        if (this.mSinkNotifyMirrorListener != null) {
            switch (n) {
                case 1: {
                    NotifyMirrorBean notifyMirrorBean = NotifyMirrorBean.formJSON(string);
                    this.mSinkNotifyMirrorListener.onNotifyMirror(notifyMirrorBean);
                }
            }
        }
        return null;
    }

    private CommonResultBean dispatchRemoteServer(int n, String string) {
        SourceLog.i(TAG, "dispatchRemoteServer " + string);
        if (this.mRemoteServerListener != null) {
            switch (n) {
                case 1: {
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        this.mRemoteServerListener.onServerStarted(jSONObject.optInt("port"));
                    }
                    catch (Exception exception) {
                        SourceLog.w(TAG, exception);
                    }
                    break;
                }
                case 2: {
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        this.mRemoteServerListener.onServerStarted(jSONObject.optInt("error"));
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(TAG, exception);
                    }
                }
            }
        }
        return null;
    }
}

