/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview.bridge;

import android.os.Parcel;
import android.os.Parcelable;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.webview.bridge.CallbackStatus;
import com.unity3d.splash.services.core.webview.bridge.Invocation;
import java.util.ArrayList;
import java.util.Arrays;

public class WebViewCallback
implements Parcelable {
    private boolean _invoked;
    private int _invocationId;
    private String _callbackId;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final WebViewCallback createFromParcel(Parcel parcel) {
            return new WebViewCallback(parcel);
        }

        public final WebViewCallback[] newArray(int n2) {
            return new WebViewCallback[n2];
        }
    };

    public WebViewCallback(String string, int n2) {
        this._callbackId = string;
        this._invocationId = n2;
    }

    public WebViewCallback(Parcel parcel) {
        this._callbackId = parcel.readString();
        this._invoked = parcel.readByte() != 0;
        this._invocationId = parcel.readInt();
    }

    public void invoke(Object ... objectArray) {
        this.invoke(CallbackStatus.OK, null, objectArray);
    }

    private void invoke(CallbackStatus callbackStatus, Enum enum_, Object ... object) {
        if (this._invoked || this._callbackId == null || this._callbackId.length() == 0) {
            return;
        }
        this._invoked = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(object));
        arrayList.add(0, this._callbackId);
        object = Invocation.getInvocationById(this._invocationId);
        if (object == null) {
            DeviceLog.error("Couldn't get batch with id: " + this.getInvocationId());
            return;
        }
        ((Invocation)object).setInvocationResponse(callbackStatus, enum_, arrayList.toArray());
    }

    public void error(Enum enum_, Object ... objectArray) {
        this.invoke(CallbackStatus.ERROR, enum_, objectArray);
    }

    public int getInvocationId() {
        return this._invocationId;
    }

    public String getCallbackId() {
        return this._callbackId;
    }

    public int describeContents() {
        return 45678;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this._callbackId);
        parcel.writeByte((byte)(this._invoked ? 1 : 0));
        parcel.writeInt(this._invocationId);
    }
}

