/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview.bridge;

import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.bridge.NativeCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewBridgeError;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;

public class WebViewBridge {
    private static HashMap _classTable;

    public static void setClassTable(Class[] classArray) {
        if (classArray == null) {
            return;
        }
        _classTable = new HashMap();
        for (Class clazz : classArray) {
            if (clazz == null || !clazz.getPackage().getName().startsWith("com.unity3d.splash.services") && !clazz.getPackage().getName().startsWith("com.unity3d.splash.test")) continue;
            HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(WebViewExposed.class) == null) continue;
                String string = method.getName();
                HashMap hashMap2 = hashMap.containsKey(string) ? (HashMap)hashMap.get(string) : new HashMap();
                hashMap2.put(Arrays.deepHashCode(method.getParameterTypes()), method);
                hashMap.put(string, hashMap2);
            }
            _classTable.put(clazz.getName(), hashMap);
        }
    }

    private static Method findMethod(String object, String objectArray, Object[] objectArray2) {
        if (!_classTable.containsKey(object)) {
            throw new NoSuchMethodException();
        }
        if (!((HashMap)(object = (HashMap)_classTable.get(object))).containsKey(objectArray)) {
            throw new NoSuchMethodException();
        }
        object = (HashMap)((HashMap)object).get(objectArray);
        objectArray = WebViewBridge.getTypes(objectArray2);
        return (Method)((HashMap)object).get(Arrays.deepHashCode(objectArray));
    }

    private static Class[] getTypes(Object[] objectArray) {
        Class[] classArray = objectArray == null ? new Class[1] : new Class[objectArray.length + 1];
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                classArray[i2] = objectArray[i2].getClass();
            }
        }
        classArray[classArray.length - 1] = WebViewCallback.class;
        return classArray;
    }

    private static Object[] getValues(Object[] objectArray, WebViewCallback webViewCallback) {
        Object[] objectArray2;
        if (objectArray == null) {
            if (webViewCallback == null) {
                return null;
            }
            objectArray2 = new Object[1];
        } else {
            objectArray2 = new Object[objectArray.length + (webViewCallback != null ? 1 : 0)];
        }
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        if (webViewCallback != null) {
            objectArray2[objectArray2.length - 1] = webViewCallback;
        }
        return objectArray2;
    }

    public static void handleInvocation(String string, String string2, Object[] objectArray, WebViewCallback webViewCallback) {
        Method method;
        try {
            method = WebViewBridge.findMethod(string, string2, objectArray);
        }
        catch (NoSuchMethodException | JSONException throwable) {
            webViewCallback.error(WebViewBridgeError.METHOD_NOT_FOUND, string, string2, objectArray);
            throw throwable;
        }
        try {
            Object[] objectArray2 = WebViewBridge.getValues(objectArray, webViewCallback);
            method.invoke(null, objectArray2);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException throwable) {
            webViewCallback.error(WebViewBridgeError.INVOCATION_FAILED, string, string2, objectArray, throwable.getMessage());
            throw throwable;
        }
    }

    public static void handleCallback(String object, String string, Object[] objectArray) {
        object = WebViewApp.getCurrentApp().getCallback((String)object);
        try {
            ((NativeCallback)object).invoke(string, WebViewBridge.getValues(objectArray, null));
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException throwable) {
            DeviceLog.error("Error while invoking method");
            throw throwable;
        }
    }
}

