/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview;

import android.os.Build;
import android.os.ConditionVariable;
import android.os.Looper;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebViewClient;
import com.unity3d.splash.services.core.configuration.Configuration;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.properties.SdkProperties;
import com.unity3d.splash.services.core.webview.WebView;
import com.unity3d.splash.services.core.webview.bridge.CallbackStatus;
import com.unity3d.splash.services.core.webview.bridge.Invocation;
import com.unity3d.splash.services.core.webview.bridge.NativeCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewBridge;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;

public class WebViewApp
extends WebViewClient {
    private static WebViewApp _currentApp;
    private static ConditionVariable _conditionVariable;
    private static final int INVOKE_JS_CHARS_LENGTH = 22;
    private boolean _webAppLoaded = false;
    private WebView _webView;
    private Configuration _configuration;
    private HashMap _nativeCallbacks;
    private boolean _initialized = false;

    private WebViewApp(Configuration configuration) {
        this.setConfiguration(configuration);
        WebViewBridge.setClassTable(this.getConfiguration().getWebAppApiClassList());
        this._webView = new WebView(ClientProperties.getApplicationContext());
        this._webView.setWebViewClient(new WebAppClient());
        this._webView.setWebChromeClient(new WebAppChromeClient());
    }

    public WebViewApp() {
    }

    public void setWebAppLoaded(boolean bl) {
        this._webAppLoaded = bl;
    }

    public boolean isWebAppLoaded() {
        return this._webAppLoaded;
    }

    public void setWebAppInitialized(boolean bl) {
        this._initialized = bl;
        _conditionVariable.open();
    }

    public boolean isWebAppInitialized() {
        return this._initialized;
    }

    public WebView getWebView() {
        return this._webView;
    }

    public void setWebView(WebView webView) {
        this._webView = webView;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    private void invokeJavascriptMethod(String string, String string2, JSONArray object) {
        object = object.toString();
        int n2 = 22 + string.length() + string2.length() + ((String)object).length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append("javascript:window.");
        stringBuilder.append(string);
        stringBuilder.append(".");
        stringBuilder.append(string2);
        stringBuilder.append("(");
        stringBuilder.append((String)object);
        stringBuilder.append(");");
        string = stringBuilder.toString();
        DeviceLog.debug("Invoking javascript: " + string);
        this.getWebView().invokeJavascript(string);
    }

    public boolean sendEvent(Enum objectArray, Enum enum_, Object ... objectArray2) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("sendEvent ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)objectArray.name());
        jSONArray.put((Object)enum_.name());
        objectArray = objectArray2;
        int n2 = objectArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            jSONArray.put(object);
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleEvent", jSONArray);
        }
        catch (Exception exception) {
            DeviceLog.exception("Error while sending event to WebView", exception);
            return false;
        }
        return true;
    }

    public boolean invokeMethod(String objectArray, String string, Method method, Object ... object) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeMethod ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)objectArray);
        jSONArray.put((Object)string);
        if (method != null) {
            objectArray = new NativeCallback(method);
            this.addCallback((NativeCallback)objectArray);
            jSONArray.put((Object)objectArray.getId());
        } else {
            jSONArray.put(null);
        }
        if (object != null) {
            objectArray = object;
            int n2 = ((Object[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = objectArray[i2];
                jSONArray.put(object);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleInvocation", jSONArray);
        }
        catch (Exception exception) {
            DeviceLog.exception("Error invoking javascript method", exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean invokeCallback(Invocation iterator) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeBatchCallback ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        if ((iterator = ((Invocation)((Object)iterator)).getResponses()) != null && !((ArrayList)((Object)iterator)).isEmpty()) {
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                void e2;
                JSONArray jSONArray2 = (JSONArray)iterator.next();
                CallbackStatus callbackStatus = (CallbackStatus)((Object)jSONArray2.get(0));
                Enum enum_ = (Enum)jSONArray2.get(1);
                jSONArray2 = (JSONArray)jSONArray2.get(2);
                String string = (String)jSONArray2[0];
                jSONArray2 = Arrays.copyOfRange(jSONArray2, 1, ((Object[])jSONArray2).length);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(callbackStatus.toString());
                callbackStatus = new JSONArray();
                if (enum_ != null) {
                    callbackStatus.put(enum_.name());
                }
                int n2 = ((Object[])jSONArray2).length;
                boolean bl = false;
                while (e2 < n2) {
                    Object object = jSONArray2[e2];
                    callbackStatus.put(object);
                    ++e2;
                }
                arrayList.add((Object)callbackStatus);
                jSONArray2 = new JSONArray();
                for (Object e3 : arrayList) {
                    jSONArray2.put(e3);
                }
                jSONArray.put((Object)jSONArray2);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleCallback", jSONArray);
        }
        catch (Exception exception) {
            DeviceLog.exception("Error while invoking batch response for WebView", exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(NativeCallback nativeCallback) {
        if (this._nativeCallbacks == null) {
            this._nativeCallbacks = new HashMap();
        }
        HashMap hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.put(nativeCallback.getId(), nativeCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(NativeCallback nativeCallback) {
        if (this._nativeCallbacks == null) {
            return;
        }
        HashMap hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.remove(nativeCallback.getId());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCallback getCallback(String string) {
        HashMap hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            return (NativeCallback)this._nativeCallbacks.get(string);
        }
    }

    public static WebViewApp getCurrentApp() {
        return _currentApp;
    }

    public static void setCurrentApp(WebViewApp webViewApp) {
        _currentApp = webViewApp;
    }

    public static boolean create(final Configuration configuration) {
        DeviceLog.entered();
        if (Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new IllegalThreadStateException("Cannot call create() from main thread!");
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                WebViewApp webViewApp;
                try {
                    webViewApp = new WebViewApp(configuration);
                }
                catch (Exception exception) {
                    DeviceLog.error("Couldn't construct WebViewApp");
                    _conditionVariable.open();
                    return;
                }
                String string = "?platform=android";
                try {
                    if (configuration.getWebViewUrl() != null) {
                        string = string + "&origin=" + URLEncoder.encode(configuration.getWebViewUrl(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    DeviceLog.exception("Unsupported charset when encoding origin url", unsupportedEncodingException);
                }
                try {
                    if (configuration.getWebViewVersion() != null) {
                        string = string + "&version=" + URLEncoder.encode(configuration.getWebViewVersion(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    DeviceLog.exception("Unsupported charset when encoding webview version", unsupportedEncodingException);
                }
                webViewApp.getWebView().loadDataWithBaseURL("file://" + SdkProperties.getLocalWebViewFile() + string, configuration.getWebViewData(), "text/html", "UTF-8", null);
                WebViewApp.setCurrentApp(webViewApp);
            }
        });
        _conditionVariable = new ConditionVariable();
        return _conditionVariable.block(60000L) && WebViewApp.getCurrentApp() != null;
    }

    private class WebAppChromeClient
    extends WebChromeClient {
        private WebAppChromeClient() {
        }

        public void onConsoleMessage(String string, int n2, String string2) {
            String string3 = string2;
            File file = null;
            try {
                file = new File(string2);
            }
            catch (Exception exception) {
                DeviceLog.exception("Could not handle sourceId", exception);
            }
            if (file != null) {
                string3 = file.getName();
            }
            if (Build.VERSION.SDK_INT < 19) {
                DeviceLog.debug("JavaScript (sourceId=" + string3 + ", line=" + n2 + "): " + string);
            }
        }
    }

    private class WebAppClient
    extends WebViewClient {
        private WebAppClient() {
        }

        public void onPageFinished(android.webkit.WebView webView, String string) {
            super.onPageFinished(webView, string);
            DeviceLog.debug("onPageFinished url: " + string);
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView webView, String string) {
            DeviceLog.debug("Trying to load url: " + string);
            return false;
        }

        public void onReceivedError(android.webkit.WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
            super.onReceivedError(webView, webResourceRequest, webResourceError);
            if (webView != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + webView.toString());
            }
            if (webResourceRequest != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + webResourceRequest.toString());
            }
            if (webResourceError != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + webResourceError.toString());
            }
        }
    }
}

