/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.misc.ViewUtilities;
import com.unity3d.splash.services.core.webview.bridge.WebViewBridgeInterface;
import java.lang.reflect.Method;

public class WebView
extends android.webkit.WebView {
    private static Method _evaluateJavascript = null;

    public WebView(Context context) {
        super(context);
        context = this.getSettings();
        if (Build.VERSION.SDK_INT >= 16) {
            context.setAllowFileAccessFromFileURLs(true);
            context.setAllowUniversalAccessFromFileURLs(true);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                _evaluateJavascript = android.webkit.WebView.class.getMethod("evaluateJavascript", String.class, ValueCallback.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DeviceLog.exception("Method evaluateJavascript not found", noSuchMethodException);
                _evaluateJavascript = null;
            }
        }
        context.setAppCacheEnabled(false);
        context.setBlockNetworkImage(false);
        context.setBlockNetworkLoads(false);
        context.setBuiltInZoomControls(false);
        context.setCacheMode(2);
        context.setDatabaseEnabled(false);
        if (Build.VERSION.SDK_INT >= 11) {
            context.setDisplayZoomControls(false);
        }
        context.setDomStorageEnabled(false);
        if (Build.VERSION.SDK_INT >= 11) {
            context.setEnableSmoothTransition(false);
        }
        context.setGeolocationEnabled(false);
        context.setJavaScriptCanOpenWindowsAutomatically(false);
        context.setJavaScriptEnabled(true);
        context.setLightTouchEnabled(false);
        context.setLoadWithOverviewMode(false);
        context.setLoadsImagesAutomatically(true);
        if (Build.VERSION.SDK_INT >= 17) {
            context.setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            context.setMixedContentMode(1);
        }
        context.setNeedInitialFocus(true);
        context.setPluginState(WebSettings.PluginState.OFF);
        context.setRenderPriority(WebSettings.RenderPriority.NORMAL);
        context.setSaveFormData(false);
        context.setSavePassword(false);
        context.setSupportMultipleWindows(false);
        context.setSupportZoom(false);
        context.setUseWideViewPort(true);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setBackgroundColor(0);
        ViewUtilities.setBackground((View)this, (Drawable)new ColorDrawable(0));
        this.setBackgroundResource(0);
        this.addJavascriptInterface(new WebViewBridgeInterface(), "webviewbridge");
    }

    public void invokeJavascript(String string) {
        Utilities.runOnUiThread(new JavaScriptInvocation(string, this));
    }

    public void loadUrl(String string) {
        DeviceLog.debug("Loading url: " + string);
        super.loadUrl(string);
    }

    private class JavaScriptInvocation
    implements Runnable {
        private String _jsString = null;
        private android.webkit.WebView _webView = null;

        public JavaScriptInvocation(String string, android.webkit.WebView webView2) {
            this._jsString = string;
            this._webView = webView2;
        }

        @Override
        public void run() {
            if (this._jsString != null) {
                try {
                    if (Build.VERSION.SDK_INT >= 19) {
                        _evaluateJavascript.invoke((Object)this._webView, this._jsString, null);
                        return;
                    }
                    WebView.this.loadUrl(this._jsString);
                    return;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Error while processing JavaScriptString", exception);
                    return;
                }
            }
            DeviceLog.error("Could not process JavaScript, the string is NULL");
        }
    }
}

