/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.properties;

import android.content.Context;
import com.unity3d.splash.BuildConfig;
import com.unity3d.splash.services.IUnityServicesListener;
import com.unity3d.splash.services.core.cache.CacheDirectory;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class SdkProperties {
    private static String _configUrl = null;
    private static CacheDirectory _cacheDirectory = null;
    private static final String CACHE_DIR_NAME = "UnitySplashAdsCache";
    private static final String LOCAL_CACHE_FILE_PREFIX = "UnitySplashAdsCache-";
    private static final String LOCAL_STORAGE_FILE_PREFIX = "UnitySplashAdsStorage-";
    private static final String CHINA_ISO_ALPHA_2_CODE = "CN";
    private static final String CHINA_ISO_ALPHA_3_CODE = "CHN";
    private static long _initializationTime = 0L;
    private static IUnityServicesListener _listener;
    private static boolean _initialized;
    private static boolean _reinitialized;
    private static boolean _testMode;
    private static boolean _perPlacementLoadEnabled;
    private static boolean _debugMode;

    public static boolean isInitialized() {
        return _initialized;
    }

    public static void setInitialized(boolean bl) {
        _initialized = bl;
    }

    public static boolean isTestMode() {
        return _testMode;
    }

    public static void setTestMode(boolean bl) {
        _testMode = bl;
    }

    public static boolean isPerPlacementLoadEnabled() {
        return _perPlacementLoadEnabled;
    }

    public static void setPerPlacementLoadEnabled(boolean bl) {
        _perPlacementLoadEnabled = bl;
    }

    public static int getVersionCode() {
        return 3300;
    }

    public static String getVersionName() {
        return "3.3.0";
    }

    public static String getCacheDirectoryName() {
        return CACHE_DIR_NAME;
    }

    public static String getCacheFilePrefix() {
        return LOCAL_CACHE_FILE_PREFIX;
    }

    public static String getLocalStorageFilePrefix() {
        return LOCAL_STORAGE_FILE_PREFIX;
    }

    public static void setConfigUrl(String string) {
        if (string == null) {
            throw new MalformedURLException();
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            throw new MalformedURLException();
        }
        new URL(string).toURI();
        _configUrl = string;
    }

    public static String getConfigUrl() {
        if (_configUrl == null) {
            _configUrl = SdkProperties.getDefaultConfigUrl("release");
        }
        return _configUrl;
    }

    public static String getDefaultConfigUrl(String string) {
        return "https://splash-ads.unitychina.cn/webview/release/native/config.json";
    }

    private static String getWebViewBranch() {
        if (BuildConfig.DEBUG) {
            return "3.3.0";
        }
        return SdkProperties.getVersionName();
    }

    public static String getLocalWebViewFile() {
        return SdkProperties.getCacheDirectory().getAbsolutePath() + "/UnitySplashAdsWebApp.html";
    }

    public static File getCacheDirectory() {
        return SdkProperties.getCacheDirectory(ClientProperties.getApplicationContext());
    }

    public static File getCacheDirectory(Context context) {
        if (_cacheDirectory == null) {
            SdkProperties.setCacheDirectory(new CacheDirectory(CACHE_DIR_NAME));
        }
        return _cacheDirectory.getCacheDirectory(context);
    }

    public static void setCacheDirectory(CacheDirectory cacheDirectory) {
        _cacheDirectory = cacheDirectory;
    }

    public static CacheDirectory getCacheDirectoryObject() {
        return _cacheDirectory;
    }

    public static void setInitializationTime(long l2) {
        _initializationTime = l2;
    }

    public static long getInitializationTime() {
        return _initializationTime;
    }

    public static void setReinitialized(boolean bl) {
        _reinitialized = bl;
    }

    public static boolean isReinitialized() {
        return _reinitialized;
    }

    public static void setDebugMode(boolean bl) {
        _debugMode = bl;
        if (bl) {
            DeviceLog.setLogLevel(8);
            return;
        }
        DeviceLog.setLogLevel(4);
    }

    public static boolean getDebugMode() {
        return _debugMode;
    }

    public static void setListener(IUnityServicesListener iUnityServicesListener) {
        _listener = iUnityServicesListener;
    }

    public static IUnityServicesListener getListener() {
        return _listener;
    }

    public static boolean isChinaLocale(String string) {
        return string.equalsIgnoreCase(CHINA_ISO_ALPHA_2_CODE) || string.equalsIgnoreCase(CHINA_ISO_ALPHA_3_CODE);
    }

    static {
        _initialized = false;
        _reinitialized = false;
        _testMode = false;
        _perPlacementLoadEnabled = false;
        _debugMode = false;
    }
}

