/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.misc;

import android.text.TextUtils;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonStorage {
    private JSONObject _data;

    public synchronized boolean initData() {
        if (this._data == null) {
            this._data = new JSONObject();
            return true;
        }
        return false;
    }

    public synchronized void setData(JSONObject jSONObject) {
        this._data = jSONObject;
    }

    public synchronized JSONObject getData() {
        return this._data;
    }

    public synchronized boolean hasData() {
        return this._data != null && this._data.length() > 0;
    }

    public synchronized void clearData() {
        this._data = null;
    }

    public synchronized boolean set(String stringArray, Object object) {
        if (this._data == null || stringArray == null || stringArray.length() == 0 || object == null) {
            DeviceLog.error("Storage not properly initialized or incorrect parameters:" + this._data + ", " + (String)stringArray + ", " + object);
            return false;
        }
        this.createObjectTree(this.getParentObjectTreeFor((String)stringArray));
        if (this.findObject(this.getParentObjectTreeFor((String)stringArray)) instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)this.findObject(this.getParentObjectTreeFor((String)stringArray));
            stringArray = stringArray.split("\\.");
            if (jSONObject != null) {
                try {
                    jSONObject.put(stringArray[stringArray.length - 1], object);
                }
                catch (JSONException jSONException) {
                    DeviceLog.exception("Couldn't set value", (Exception)((Object)jSONException));
                    return false;
                }
            }
        } else {
            DeviceLog.debug("Cannot set subvalue to an object that is not JSONObject");
            return false;
        }
        return true;
    }

    public synchronized Object get(String string) {
        if (this._data == null) {
            DeviceLog.error("Data is NULL, readStorage probably not called");
            return null;
        }
        String[] stringArray = string.split("\\.");
        if (this.findObject(this.getParentObjectTreeFor(string)) instanceof JSONObject && (string = (JSONObject)this.findObject(this.getParentObjectTreeFor(string))) != null) {
            Object object = null;
            try {
                if (string.has(stringArray[stringArray.length - 1])) {
                    object = string.get(stringArray[stringArray.length - 1]);
                }
            }
            catch (Exception exception) {
                DeviceLog.exception("Error getting data", exception);
            }
            return object;
        }
        return null;
    }

    public synchronized List getKeys(String string, boolean bl) {
        if (this.get(string) instanceof JSONObject) {
            Object object = (JSONObject)this.get(string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (object != null) {
                Iterator iterator = object.keys();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    Object object2 = null;
                    if (bl) {
                        object2 = this.getKeys(string + "." + (String)object, bl);
                    }
                    arrayList.add(object);
                    if (object2 == null) continue;
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        String string2 = (String)object2.next();
                        arrayList.add((String)object + "." + string2);
                    }
                }
            }
            return arrayList;
        }
        return null;
    }

    public synchronized boolean delete(String string) {
        if (this._data == null) {
            DeviceLog.error("Data is NULL, readStorage probably not called");
            return false;
        }
        String[] stringArray = string.split("\\.");
        return this.findObject(this.getParentObjectTreeFor(string)) instanceof JSONObject && (string = (JSONObject)this.findObject(this.getParentObjectTreeFor(string))) != null && string.remove(stringArray[stringArray.length - 1]) != null;
    }

    private synchronized Object findObject(String string) {
        String[] stringArray = string.split("\\.");
        JSONObject jSONObject = this._data;
        if (string.length() == 0) {
            return jSONObject;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (jSONObject.has(stringArray[i2])) {
                try {
                    jSONObject = jSONObject.getJSONObject(stringArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't read JSONObject: " + stringArray[i2], exception);
                    return null;
                }
            }
            return null;
        }
        return jSONObject;
    }

    private synchronized void createObjectTree(String string) {
        String[] stringArray = string.split("\\.");
        JSONObject jSONObject = this._data;
        if (string.length() == 0) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!jSONObject.has(stringArray[i2])) {
                try {
                    jSONObject = jSONObject.put(stringArray[i2], (Object)new JSONObject());
                    jSONObject = jSONObject.getJSONObject(stringArray[i2]);
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't create new JSONObject", exception);
                }
                continue;
            }
            try {
                jSONObject = jSONObject.getJSONObject(stringArray[i2]);
                continue;
            }
            catch (Exception exception) {
                DeviceLog.exception("Couldn't get existing JSONObject", exception);
            }
        }
    }

    private synchronized String getParentObjectTreeFor(String object) {
        object = ((String)object).split("\\.");
        object = new ArrayList<String>(Arrays.asList(object));
        ((ArrayList)object).remove(((ArrayList)object).size() - 1);
        object = ((ArrayList)object).toArray();
        return TextUtils.join((CharSequence)".", (Object[])object);
    }
}

