/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.log;

import android.util.Log;
import com.unity3d.splash.services.core.log.DeviceLogEntry;
import com.unity3d.splash.services.core.log.DeviceLogLevel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;

public class DeviceLog {
    private static boolean LOG_ERROR = true;
    private static boolean LOG_WARNING = true;
    private static boolean LOG_INFO = true;
    private static boolean LOG_DEBUG = true;
    private static boolean FORCE_DEBUG_LOG = false;
    private static final int MAX_DEBUG_MSG_LENGTH = 3072;
    private static final int LOGLEVEL_ERROR = 1;
    private static final int LOGLEVEL_WARNING = 2;
    public static final int LOGLEVEL_INFO = 4;
    public static final int LOGLEVEL_DEBUG = 8;
    private static final HashMap _deviceLogLevel = new HashMap();

    public static void setLogLevel(int n2) {
        if (n2 >= 8) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = true;
            LOG_DEBUG = true;
            return;
        }
        if (n2 >= 4) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = true;
            LOG_DEBUG = false;
            return;
        }
        if (n2 >= 2) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = false;
            LOG_DEBUG = false;
            return;
        }
        if (n2 > 0) {
            LOG_ERROR = true;
            LOG_WARNING = false;
            LOG_INFO = false;
            LOG_DEBUG = false;
            return;
        }
        LOG_ERROR = false;
        LOG_WARNING = false;
        LOG_INFO = false;
        LOG_DEBUG = false;
    }

    public static void entered() {
        DeviceLog.debug("ENTERED METHOD");
    }

    public static void info(String string) {
        DeviceLog.write(UnityAdsLogLevel.INFO, DeviceLog.checkMessage(string));
    }

    public static void info(String string, Object ... objectArray) {
        DeviceLog.info(String.format(string, objectArray));
    }

    public static void debug(String string) {
        if (!LOG_DEBUG && !FORCE_DEBUG_LOG) {
            return;
        }
        if (string.length() > 3072) {
            DeviceLog.debug(string.substring(0, 3072));
            if (string.length() < 30720) {
                DeviceLog.debug(string.substring(3072));
            }
            return;
        }
        DeviceLog.write(UnityAdsLogLevel.DEBUG, DeviceLog.checkMessage(string));
    }

    public static void debug(String string, Object ... objectArray) {
        DeviceLog.debug(String.format(string, objectArray));
    }

    public static void warning(String string) {
        DeviceLog.write(UnityAdsLogLevel.WARNING, DeviceLog.checkMessage(string));
    }

    public static void warning(String string, Object ... objectArray) {
        DeviceLog.warning(String.format(string, objectArray));
    }

    public static void error(String string) {
        DeviceLog.write(UnityAdsLogLevel.ERROR, DeviceLog.checkMessage(string));
    }

    public static void exception(String string, Exception exception) {
        String string2 = "";
        if (string != null) {
            string2 = string2 + string;
        }
        if (exception != null) {
            string2 = string2 + ": " + exception.getMessage();
        }
        if (exception != null && exception.getCause() != null) {
            string2 = string2 + ": " + exception.getCause().getMessage();
        }
        DeviceLog.write(UnityAdsLogLevel.ERROR, string2);
    }

    public static void error(String string, Object ... objectArray) {
        DeviceLog.error(String.format(string, objectArray));
    }

    private static void write(UnityAdsLogLevel unityAdsLogLevel, String string) {
        boolean bl = true;
        switch (unityAdsLogLevel) {
            case INFO: {
                bl = LOG_INFO;
                break;
            }
            case DEBUG: {
                bl = LOG_DEBUG;
                break;
            }
            case WARNING: {
                bl = LOG_WARNING;
                break;
            }
            case ERROR: {
                bl = LOG_ERROR;
            }
        }
        if (FORCE_DEBUG_LOG) {
            bl = true;
        }
        if (bl) {
            DeviceLog.writeToLog(DeviceLog.createLogEntry(unityAdsLogLevel, string));
        }
    }

    private static String checkMessage(String string) {
        block0: {
            if (string != null && string.length() != 0) break block0;
            string = "DO NOT USE EMPTY MESSAGES, use DeviceLog.entered() instead";
        }
        return string;
    }

    private static DeviceLogLevel getLogLevel(UnityAdsLogLevel unityAdsLogLevel) {
        return (DeviceLogLevel)_deviceLogLevel.get((Object)unityAdsLogLevel);
    }

    private static DeviceLogEntry createLogEntry(UnityAdsLogLevel object, String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        DeviceLogLevel deviceLogLevel = DeviceLog.getLogLevel((UnityAdsLogLevel)((Object)object));
        DeviceLogEntry deviceLogEntry = null;
        if (deviceLogLevel != null) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
                object = stackTraceElementArray[n2];
                if (((StackTraceElement)object).getClassName().equals(DeviceLog.class.getName())) {
                    bl = true;
                }
                if (!((StackTraceElement)object).getClassName().equals(DeviceLog.class.getName()) && bl) break;
            }
            object = null;
            if (n2 < stackTraceElementArray.length) {
                object = stackTraceElementArray[n2];
            }
            if (object != null) {
                deviceLogEntry = new DeviceLogEntry(deviceLogLevel, string, (StackTraceElement)object);
            }
        }
        return deviceLogEntry;
    }

    private static void writeToLog(DeviceLogEntry deviceLogEntry) {
        Method method = null;
        if (deviceLogEntry != null && deviceLogEntry.getLogLevel() != null) {
            try {
                method = Log.class.getMethod(deviceLogEntry.getLogLevel().getReceivingMethodName(), String.class, String.class);
            }
            catch (Exception exception) {
                Log.e((String)"UnityAds", (String)"Writing to log failed!", (Throwable)exception);
            }
            if (method != null) {
                try {
                    method.invoke(null, deviceLogEntry.getLogLevel().getLogTag(), deviceLogEntry.getParsedMessage());
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)"UnityAds", (String)"Writing to log failed!", (Throwable)exception);
                }
            }
        }
    }

    static {
        if (_deviceLogLevel.size() == 0) {
            _deviceLogLevel.put(UnityAdsLogLevel.INFO, new DeviceLogLevel("i"));
            _deviceLogLevel.put(UnityAdsLogLevel.DEBUG, new DeviceLogLevel("d"));
            _deviceLogLevel.put(UnityAdsLogLevel.WARNING, new DeviceLogLevel("w"));
            _deviceLogLevel.put(UnityAdsLogLevel.ERROR, new DeviceLogLevel("e"));
        }
        if (new File("/data/local/tmp/UnityAdsForceDebugMode").exists()) {
            FORCE_DEBUG_LOG = true;
        }
    }

    public static enum UnityAdsLogLevel {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }
}

