/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.unity3d.splash.services.core.device.Device;
import com.unity3d.splash.services.core.device.IVolumeChangeListener;
import com.unity3d.splash.services.core.properties.ClientProperties;
import java.util.ArrayList;

public class VolumeChange {
    private static ContentObserver _contentObserver;
    private static ArrayList _listeners;

    public static void startObserving() {
        if (_contentObserver == null) {
            _contentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

                public final boolean deliverSelfNotifications() {
                    return false;
                }

                public final void onChange(boolean bl, Uri uri) {
                    VolumeChange.triggerListeners();
                }
            };
            Context context = ClientProperties.getApplicationContext();
            if (context != null && (context = context.getContentResolver()) != null) {
                context.registerContentObserver(Settings.System.CONTENT_URI, true, _contentObserver);
            }
        }
    }

    public static void stopObservering() {
        if (_contentObserver != null) {
            Context context = ClientProperties.getApplicationContext();
            if (context != null && (context = context.getContentResolver()) != null) {
                context.unregisterContentObserver(_contentObserver);
            }
            _contentObserver = null;
        }
    }

    public static void registerListener(IVolumeChangeListener iVolumeChangeListener) {
        if (_listeners == null) {
            _listeners = new ArrayList();
        }
        if (!_listeners.contains(iVolumeChangeListener)) {
            VolumeChange.startObserving();
            _listeners.add(iVolumeChangeListener);
        }
    }

    public static void unregisterListener(IVolumeChangeListener iVolumeChangeListener) {
        if (_listeners.contains(iVolumeChangeListener)) {
            _listeners.remove(iVolumeChangeListener);
        }
        if (_listeners == null || _listeners.size() == 0) {
            VolumeChange.stopObservering();
        }
    }

    public static void clearAllListeners() {
        if (_listeners != null) {
            _listeners.clear();
        }
        VolumeChange.stopObservering();
        _listeners = null;
    }

    private static void triggerListeners() {
        if (_listeners != null) {
            for (IVolumeChangeListener iVolumeChangeListener : _listeners) {
                int n2 = Device.getStreamVolume(iVolumeChangeListener.getStreamType());
                iVolumeChangeListener.onVolumeChanged(n2);
            }
        }
    }
}

